/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.ModifiableFilesToBeProcessedData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IUndoRedoExtension;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import java.util.List;

public final class RevertModifiedModifiableFilesCommand
extends SoftwareSystemBasedCommand<IInteraction> {
    public RevertModifiedModifiableFilesCommand(IInteraction interaction, ISoftwareSystemProvider provider) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.REVERT;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        Files files = this.getController().getSoftwareSystem().getUniqueExistingChild(Files.class);
        List<IModifiableFile> modifiableFilesNeedingSave = files.getModifiableFilesNeedingSave();
        assert (modifiableFilesNeedingSave.size() > 0) : "There must be files available for revert if this command is enabled";
        ModifiableFilesToBeRevertedData modifiableFilesToBeRevertedData = new ModifiableFilesToBeRevertedData(files.getConflictStates(modifiableFilesNeedingSave));
        modifiableFilesToBeRevertedData.setToBeReverted(modifiableFilesNeedingSave);
        if (!((IInteraction)this.getInteraction()).collect(modifiableFilesToBeRevertedData)) {
            return;
        }
        List<IModifiableFile> toBeReverted = modifiableFilesToBeRevertedData.getToBeReverted();
        if (toBeReverted.isEmpty()) {
            return;
        }
        IUndoRedoExtension undoRedoExtension = this.getController().getSoftwareSystem().getExtension(IUndoRedoExtension.class);
        OperationResult revertResult = undoRedoExtension.revert(workerContext, toBeReverted);
        ((IInteraction)this.getInteraction()).processModifiableFilesRevertedResult(revertResult);
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    protected boolean canBeQueued() {
        return false;
    }

    @Override
    public Result isEnabled() {
        Result result = super.isEnabled();
        if (result.isFailure()) {
            return result;
        }
        Result result2 = new Result();
        IUndoRedoExtension extension = this.getController().getSoftwareSystem().getExtension(IUndoRedoExtension.class);
        if (!extension.isRevertAvailable()) {
            result2.addErrorMessage("Revert is unavailable");
        }
        return result2;
    }

    public static interface IInteraction
    extends ICommandInteraction {
        public boolean collect(ModifiableFilesToBeRevertedData var1);

        public boolean processModifiableFilesRevertedResult(OperationResult var1);
    }

    public static final class ModifiableFilesToBeRevertedData
    extends ModifiableFilesToBeProcessedData {
        public ModifiableFilesToBeRevertedData(List<Pair<IModifiableFile, Files.ConflictState>> needingSave) {
            super(needingSave);
        }

        public List<IModifiableFile> getToBeReverted() {
            return this.getToBeProcessed();
        }

        public void setToBeReverted(List<IModifiableFile> toBeReverted) {
            this.setToBeProcessed(toBeReverted);
        }
    }
}

