/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IWorkspaceExtension;
import com.hello2morrow.sonargraph.core.model.filter.Filter;
import com.hello2morrow.sonargraph.core.model.filter.Pattern;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import java.util.ArrayList;
import java.util.List;

public abstract class MoveFilterPatternsCommand
extends SoftwareSystemBasedCommand<IInteraction> {
    public MoveFilterPatternsCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    protected final void internalRun(IWorkerContext workerContext) {
        Data data;
        IInteraction interaction = (IInteraction)this.getInteraction();
        if (!interaction.collect(data = new Data())) {
            return;
        }
        OperationResult result = this.getController().getSoftwareSystem().getExtension(IWorkspaceExtension.class).movePatternsTo(workerContext, data.getPatterns(), data.getTargetFilter(), data.getTargetPosition());
        interaction.processMoveResult(result);
    }

    public static final class Data
    implements ICommandInteractionData {
        private List<Pattern> m_patterns = null;
        private Filter m_targetFilter = null;
        private int m_targetPosition = -1;

        Data() {
        }

        public void setData(List<Pattern> patterns, Filter targetFilter, int targetPosition) {
            assert (patterns != null && !patterns.isEmpty()) : "Parameter 'patterns' of method 'setData' must not be empty";
            assert (targetFilter != null) : "Parameter 'targetFilter' of method 'setTargesetDatatPosition' must not be null";
            assert (targetPosition >= -1) : "'targetPosition' not valid: " + targetPosition;
            this.m_patterns = new ArrayList<Pattern>(patterns);
            this.m_targetFilter = targetFilter;
            this.m_targetPosition = targetPosition;
        }

        List<Pattern> getPatterns() {
            assert (this.m_patterns != null && !this.m_patterns.isEmpty()) : "Parameter 'm_patterns' of method 'getPatterns' must not be empty";
            return this.m_patterns;
        }

        Filter getTargetFilter() {
            assert (this.m_targetFilter != null) : "'m_targetFilter' of method 'getTargetFilter' must not be null";
            return this.m_targetFilter;
        }

        int getTargetPosition() {
            assert (this.m_targetPosition >= -1) : "'m_targetPosition' not valid: " + this.m_targetPosition;
            return this.m_targetPosition;
        }
    }

    public static interface IInteraction
    extends ICommandInteraction {
        public boolean collect(Data var1);

        public void processMoveResult(OperationResult var1);
    }
}

