/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IWorkspaceProfileExtension;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.model.filter.ProductionCodeFilter;
import com.hello2morrow.sonargraph.core.model.system.FilterModification;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.IWorkspaceProfilePattern;
import com.hello2morrow.sonargraph.core.model.system.IWorkspaceProfileProvider;
import com.hello2morrow.sonargraph.core.model.system.IWorkspaceProvider;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfile;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import java.util.ArrayList;
import java.util.List;

public class CreateWorkspaceProfileCommand
extends SoftwareSystemBasedCommand<ICreateInteraction> {
    public CreateWorkspaceProfileCommand(ISoftwareSystemProvider provider, ICreateInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.CREATE_WORKSPACE_PROFILE_PATTERN_BASED;
    }

    @Override
    public Result isEnabled() {
        Result result = super.isEnabled();
        if (result.isSuccess() && !this.getController().getSoftwareSystem().getExtension(IWorkspaceProfileProvider.class).isCreationPossible()) {
            result.addErrorMessage("No modules supporting workspace profiles exist.");
        }
        return result;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        CreateData data;
        ICreateInteraction interaction = (ICreateInteraction)this.getInteraction();
        if (!interaction.collect(data = new CreateData())) {
            return;
        }
        OperationResultWithOutcome<WorkspaceProfile> result = this.getController().getSoftwareSystem().getExtension(IWorkspaceProfileExtension.class).create(workerContext, data.getName(), data.getDescription(), data.getPatterns(), data.getFilters());
        interaction.processCreateResult((OperationResult)result);
    }

    public static ITextValidator getWorkspaceFilterValidator(ISoftwareSystemProvider provider, ProductionCodeFilter filter) {
        assert (provider != null) : "Parameter 'provider' of method 'getWorkspaceFilterValidator' must not be null";
        assert (provider.hasSoftwareSystem()) : "Software system must be opened";
        assert (filter != null) : "Parameter 'filter' of method 'getWorkspaceFilterValidator' must not be null";
        return provider.getSoftwareSystem().getExtension(IWorkspaceProvider.class).getPatternValidator(filter);
    }

    public static final class CreateData
    implements ICommandInteractionData {
        private String m_name;
        private String m_description = "";
        private final List<IWorkspaceProfilePattern> m_patterns = new ArrayList<IWorkspaceProfilePattern>();
        private FilterModification m_filterModification;

        public void setName(String profileName) {
            assert (profileName != null && profileName.length() > 0) : "Parameter 'profileName' of method 'setName' must not be empty";
            this.m_name = profileName;
        }

        public String getName() {
            return this.m_name;
        }

        public String getDescription() {
            return this.m_description;
        }

        public void setDescription(String description) {
            this.m_description = description;
        }

        public List<IWorkspaceProfilePattern> getPatterns() {
            return this.m_patterns;
        }

        public void setPatterns(List<IWorkspaceProfilePattern> patterns) {
            assert (patterns != null) : "Parameter 'patterns' of method 'setPatterns' must not be null";
            this.m_patterns.clear();
            this.m_patterns.addAll(patterns);
        }

        public void setFilters(FilterModification filterModification) {
            assert (filterModification != null) : "Parameter 'filterModification' of method 'setFilters' must not be null";
            this.m_filterModification = filterModification;
        }

        public FilterModification getFilters() {
            return this.m_filterModification;
        }
    }

    public static interface ICreateInteraction
    extends ICommandInteraction {
        public boolean collect(CreateData var1);

        public void processCreateResult(OperationResult var1);
    }
}

