/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IReportExtension;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.report.CreateReportResult;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import java.util.Collections;
import java.util.List;

public class CreateReportCommand
extends SoftwareSystemBasedCommand<IReportInteraction> {
    public static final ICommandId ID = CoreCommandId.CREATE_REPORT;

    public CreateReportCommand(ISoftwareSystemProvider provider, IReportInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public ActivityMode getActivityMode() {
        return ActivityMode.MODAL_CANCELABLE;
    }

    @Override
    public boolean providesProgress() {
        return true;
    }

    @Override
    public ICommandId getId() {
        return ID;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        List<IMetricLevel> levels = this.getController().getInstallation().getExtension(IMetricsProvider.class).getAvailableElementMetricLevels(true, true);
        IReportExtension reportExtension = this.getController().getSoftwareSystem().getExtension(IReportExtension.class);
        ReportInteractionData data = new ReportInteractionData(levels, reportExtension.getStandardMetricLevels());
        if (((IReportInteraction)this.getInteraction()).collect(data)) {
            OperationResultWithOutcome<CreateReportResult> result = reportExtension.createReport(workerContext, data);
            if (!workerContext.hasBeenCanceled()) {
                ((IReportInteraction)this.getInteraction()).handleResult(result);
            }
        }
    }

    public static interface IReportInteraction
    extends ICommandInteraction {
        public boolean collect(ReportInteractionData var1);

        public void handleResult(OperationResultWithOutcome<CreateReportResult> var1);
    }

    public static final class ReportInteractionData
    extends IReportExtension.CreateReportRequest
    implements ICommandInteractionData {
        private final List<IMetricLevel> m_availableLevels;
        private final List<IMetricLevel> m_standardLevels;

        public ReportInteractionData(List<IMetricLevel> availableLevels, List<IMetricLevel> standardLevels) {
            assert (availableLevels != null) : "Parameter 'availableLevels' of method 'ReportInteractionData' must not be null";
            assert (!availableLevels.isEmpty()) : "Parameter 'availableLevels' of method 'ReportInteractionData' must not be empty";
            assert (standardLevels != null) : "Parameter 'standardLevels' of method 'ReportInteractionData' must not be null";
            this.m_availableLevels = availableLevels;
            this.m_standardLevels = standardLevels;
        }

        public List<IMetricLevel> getAvailableLevels() {
            return Collections.unmodifiableList(this.m_availableLevels);
        }

        public List<IMetricLevel> getStandardLevels() {
            return Collections.unmodifiableList(this.m_standardLevels);
        }
    }
}

