/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.snapshot;

import com.hello2morrow.sonargraph.api.Any;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotComponentContainer;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotDependency;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotPath;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotRootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotSourceFilePath;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.core.model.system.IAnalyzerProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.persistence.snapshot.SnapshotBaseDirectory;
import com.hello2morrow.sonargraph.core.persistence.snapshot.SnapshotProcessor;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.TrueZipFacade;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.attribute.FileTime;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SnapshotWriter
extends SnapshotProcessor
implements ISnapshotWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnapshotWriter.class);
    private final SoftwareSystem m_softwareSystem;
    private final ISnapshotProcessor.Mode m_mode;
    private final Map<NamedElement, Integer> m_namedElementToId = new LinkedHashMap<NamedElement, Integer>(5000);
    private final Map<String, Integer> m_stringToId = new HashMap<String, Integer>();
    private final Map<String, String> m_rootMap = new HashMap<String, String>();
    private final Map<ISnapshotWriter.IStorable, ISnapshotWriter.IWriteStorableContext> m_contexts = new LinkedHashMap<ISnapshotWriter.IStorable, ISnapshotWriter.IWriteStorableContext>();
    private WritableByteChannel m_dataChannel;
    private ByteBuffer m_dataBuffer;
    private IWorkerContext m_workerContext;

    public SnapshotWriter(SoftwareSystem softwareSystem, ISnapshotProcessor.Mode mode) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'SnapshotWriter' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'SnapshotWriter' must not be null";
        this.m_softwareSystem = softwareSystem;
        this.m_mode = mode;
    }

    @Override
    public String getPersistentPath(ISnapshotPath persistentPath) {
        assert (persistentPath != null) : "Parameter 'provider' of method 'getPersistentPath' must not be null";
        if (this.m_mode != ISnapshotProcessor.Mode.WORKSPACE && persistentPath instanceof ISnapshotRootDirectoryPath) {
            String path = persistentPath.getPath();
            String result = this.m_rootMap.get(path);
            if (result == null) {
                String newRoot = String.format("./root-%d", this.m_rootMap.size());
                this.m_rootMap.put(path, newRoot);
                result = newRoot;
            }
            return result;
        }
        return persistentPath.getPath();
    }

    private void walkElementTree(NamedElement element) throws IOException {
        assert (element != null) : "Parameter 'element' of method 'walkElementTree' must not be null";
        assert (this.m_workerContext != null) : "Parameter 'm_workerContext' of method 'walkElementTree' must not be null";
        assert (this.m_dataBuffer != null) : "Parameter 'm_dataBuffer' of method 'walkElementTree' must not be null";
        if (this.m_workerContext.hasBeenCanceled()) {
            return;
        }
        assert (element.getOriginal() == element) : "Not an original: [" + Integer.toHexString(element.hashCode()) + "] " + element.getClass().getName() + ": " + String.valueOf(element);
        int id = this.m_namedElementToId.size();
        this.m_namedElementToId.put(element, id);
        this.writeString(element.getClass().getName());
        if (element instanceof ISnapshotDependency.IDependencyEndpoint) {
            ISnapshotDependency.IDependencyEndpoint dependencyEndpoint = (ISnapshotDependency.IDependencyEndpoint)((Object)element);
            dependencyEndpoint.writeDependencyList(this);
        }
        try {
            if (element.persistChildren(this.m_mode)) {
                for (NamedElement child : element.getChildrenList()) {
                    if (!child.persist(this.m_mode)) continue;
                    this.ensureBufferSpace(4);
                    this.m_dataBuffer.putInt(id);
                    this.walkElementTree(child);
                }
            }
        }
        catch (Throwable t) {
            LOGGER.error("Failed to walk element tree for " + element.getFullyQualifiedName(), t);
            throw t;
        }
    }

    private String getTruncatedName(String name) {
        assert (name != null) : "Parameter 'name' of method 'getTruncatedName' must not be null";
        if (name.startsWith("./")) {
            return name.substring(2);
        }
        return name;
    }

    private void writeFile(OperationResult result, WritableByteChannel out, ByteBuffer dataBuffer, TFile file) throws FileNotFoundException, IOException {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (ReadableByteChannel in = Channels.newChannel((InputStream)new TFileInputStream((File)file));){
                while (in.read(dataBuffer) > 0) {
                    this.m_dataBuffer.flip();
                    out.write(this.m_dataBuffer);
                    this.m_dataBuffer.clear();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException ex) {
            result.addWarning((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, "Could not find file " + file.getPath(), new Object[0]);
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public boolean writeSnapshot(IWorkerContext workerContext, TFile targetFile, OperationResult result) {
        if (!SnapshotWriter.$assertionsDisabled && workerContext == null) {
            throw new AssertionError((Object)"Parameter 'workerContext' of method 'writeSnapshot' must not be null");
        }
        if (!SnapshotWriter.$assertionsDisabled && targetFile == null) {
            throw new AssertionError((Object)"Parameter 'targetFile' of method 'writeSnapshot' must not be null");
        }
        if (!SnapshotWriter.$assertionsDisabled && result == null) {
            throw new AssertionError((Object)"Parameter 'result' of method 'writeSnapshot' must not be null");
        }
        success = false;
        try {
            try {
                var5_5 = null;
                var6_8 = null;
                try {
                    dataStream = new FileOutputStream((File)targetFile);
                    try {
                        zos = new ZipOutputStream(dataStream);
                        try {
                            dataChannel = Channels.newChannel(zos);
                            try {
                                zos.putNextEntry(new ZipEntry("snapshot.data"));
                                this.m_dataChannel = dataChannel;
                                this.m_dataBuffer = ByteBuffer.allocateDirect(65536);
                                this.m_dataBuffer.putInt(this.getMagicNumber());
                                this.m_dataBuffer.putShort((short)26);
                                for (Language nextLanguage : this.m_softwareSystem.getUsedLanguages()) {
                                    this.writeString(nextLanguage.getStandardName());
                                }
                                this.writeString(null);
                                this.m_workerContext = workerContext;
                                this.walkElementTree(this.m_softwareSystem);
                                this.ensureBufferSpace(4);
                                this.m_dataBuffer.putInt(-1);
                                for (NamedElement nextNamedElement : this.m_namedElementToId.keySet()) {
                                    if (workerContext.hasBeenCanceled()) break;
                                    nextNamedElement.store(this);
                                }
                                this.m_dataBuffer.flip();
                                dataChannel.write(this.m_dataBuffer);
                                this.m_dataBuffer.clear();
                                zos.closeEntry();
                                if (this.m_mode != ISnapshotProcessor.Mode.WORKSPACE) {
                                    prefix = String.format("%s.sonargraph", new Object[]{this.m_softwareSystem.getName()});
                                    systemDir = new TFile((File)this.m_softwareSystem.getDirectoryFile(), prefix);
                                    this.copyDirectory(result, systemDir, prefix, zos, dataChannel, this.m_dataBuffer, (Predicate<TFile>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$0(de.schlichtherle.truezip.file.TFile ), (Lde/schlichtherle/truezip/file/TFile;)Z)(), (Predicate<TFile>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$1(de.schlichtherle.truezip.file.TFile ), (Lde/schlichtherle/truezip/file/TFile;)Z)());
                                    analyzerController = this.m_softwareSystem.getExtension(IAnalyzerProvider.class);
                                    analyzerResultDir = analyzerController.getAnalyzerResultStorageDirectory();
                                    this.copyDirectory(result, analyzerResultDir, analyzerResultDir.getName(), zos, dataChannel, this.m_dataBuffer, (Predicate<TFile>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$2(de.schlichtherle.truezip.file.TFile ), (Lde/schlichtherle/truezip/file/TFile;)Z)(), (Predicate<TFile>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$3(de.schlichtherle.truezip.file.TFile ), (Lde/schlichtherle/truezip/file/TFile;)Z)());
                                }
                                if (this.m_mode == ISnapshotProcessor.Mode.FULL_WITH_SOURCECODE) {
                                    for (ISnapshotComponentContainer nextComponentContainer : this.m_softwareSystem.getComponentContainer()) {
                                        for (ISnapshotSourceFilePath nextFilePath : nextComponentContainer.getSourceFiles()) {
                                            nextBaseDirectory = nextFilePath.getRootDirectoryPath();
                                            if (!SnapshotWriter.$assertionsDisabled && nextBaseDirectory == null) {
                                                throw new AssertionError((Object)"'nextBaseDirectory' of method 'writeSnapshot' must not be null");
                                            }
                                            root = this.m_rootMap.get(nextBaseDirectory.getPath());
                                            if (!SnapshotWriter.$assertionsDisabled && root == null) {
                                                throw new AssertionError((Object)"'root' of method 'writeSnapshot' must not be null");
                                            }
                                            entryName = String.format("%s/%s", new Object[]{this.getTruncatedName(root), this.getTruncatedName(SnapshotBaseDirectory.convertPathIfNecessary(nextFilePath.getPath()))});
                                            try {
                                                zos.putNextEntry(new ZipEntry(entryName));
                                                this.writeFile(result, dataChannel, this.m_dataBuffer, nextFilePath.getFile());
                                                zos.closeEntry();
                                            }
                                            catch (ZipException var17_22) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                }
                                if (this.m_mode != ISnapshotProcessor.Mode.WORKSPACE) {
                                    this.writeMappingFile(zos);
                                }
                                success = true;
                            }
                            finally {
                                if (dataChannel != null) {
                                    dataChannel.close();
                                }
                            }
                            ** if (zos == null) goto lbl-1000
                        }
                        catch (Throwable var6_9) {
                            if (var5_5 == null) {
                                var5_5 = var6_9;
                            } else if (var5_5 != var6_9) {
                                var5_5.addSuppressed(var6_9);
                            }
                            if (zos != null) {
                                zos.close();
                            }
                            throw var5_5;
                        }
lbl-1000:
                        // 1 sources

                        {
                            zos.close();
                        }
lbl-1000:
                        // 2 sources

                        {
                        }
                        ** if (dataStream == null) goto lbl-1000
                    }
                    catch (Throwable var6_10) {
                        if (var5_5 == null) {
                            var5_5 = var6_10;
                        } else if (var5_5 != var6_10) {
                            var5_5.addSuppressed(var6_10);
                        }
                        if (dataStream != null) {
                            dataStream.close();
                        }
                        throw var5_5;
                    }
lbl-1000:
                    // 1 sources

                    {
                        dataStream.close();
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
                catch (Throwable var6_11) {
                    if (var5_5 == null) {
                        var5_5 = var6_11;
                    } else if (var5_5 != var6_11) {
                        var5_5.addSuppressed(var6_11);
                    }
                    throw var5_5;
                }
            }
            catch (Throwable e) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, e);
                this.m_namedElementToId.clear();
                this.m_stringToId.clear();
                this.m_dataBuffer = null;
                this.m_dataChannel = null;
                this.m_workerContext = null;
            }
        }
        finally {
            this.m_namedElementToId.clear();
            this.m_stringToId.clear();
            this.m_dataBuffer = null;
            this.m_dataChannel = null;
            this.m_workerContext = null;
        }
        return success;
    }

    private void writeMappingFile(ZipOutputStream zos) throws FileNotFoundException, IOException {
        assert (zos != null) : "Parameter 'zos' of method 'writeMappingFile' must not be null";
        zos.putNextEntry(new ZipEntry("RootMapping.properties"));
        for (Map.Entry<String, String> entry : this.m_rootMap.entrySet()) {
            byte[] line = String.format("%s=%s\n", entry.getValue(), entry.getKey()).getBytes(this.getCharacterSet());
            this.ensureBufferSpace(line.length);
            this.m_dataBuffer.put(line);
        }
        this.m_dataBuffer.flip();
        this.m_dataChannel.write(this.m_dataBuffer);
        this.m_dataBuffer.clear();
        zos.closeEntry();
    }

    private void copyDirectory(OperationResult result, TFile dir, String prefix, ZipOutputStream zos, WritableByteChannel dataChannel, ByteBuffer buffer, Predicate<TFile> fileFilter, Predicate<TFile> dirFilter) throws IOException {
        assert (dir != null) : "Parameter 'dir' of method 'copyDirectory' must not be null";
        TFile[] files = dir.listFiles();
        if (files != null) {
            TFile[] tFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                TFile file = tFileArray[n2];
                if (file.isDirectory()) {
                    if (dirFilter.test(file)) {
                        this.copyDirectory(result, file, String.format("%s/%s", prefix, file.getName()), zos, dataChannel, buffer, fileFilter, dirFilter);
                    }
                } else if (fileFilter.test(file)) {
                    ZipEntry ze = new ZipEntry(String.format("%s/%s", prefix, file.getName()));
                    ze.setLastModifiedTime(FileTime.fromMillis(file.lastModified()));
                    zos.putNextEntry(ze);
                    this.writeFile(result, dataChannel, buffer, file);
                    zos.closeEntry();
                }
                ++n2;
            }
        }
    }

    @Override
    public ISnapshotProcessor.Mode getMode() {
        return this.m_mode;
    }

    public void writeSnapshot(IWorkerContext workerContext, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'writeSnapshot' must not be null";
        assert (result != null) : "Parameter 'result' of method 'writeSnapshot' must not be null";
        try {
            TFile newDataFile = this.getNewSnapshotFile(this.m_softwareSystem);
            if (this.writeSnapshot(workerContext, newDataFile, result)) {
                TFile dataFile = SnapshotWriter.getSnapshotFile(this.m_softwareSystem);
                if (result.isSuccess()) {
                    if (dataFile.exists()) {
                        dataFile.rm_r();
                    }
                    assert (newDataFile.canRead()) : "Written snapshot must be readable: " + newDataFile.getPath();
                    TrueZipFacade.clear((TFile)newDataFile);
                    newDataFile.mv((File)dataFile);
                    TrueZipFacade.clear((TFile)dataFile);
                }
            }
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)ex);
        }
    }

    private void ensureBufferSpace(int bytes) throws IOException {
        if (this.m_dataBuffer.remaining() <= bytes) {
            this.m_dataBuffer.flip();
            this.m_dataChannel.write(this.m_dataBuffer);
            this.m_dataBuffer.clear();
        }
    }

    @Override
    public void writeByte(byte value) throws IOException {
        this.ensureBufferSpace(1);
        this.m_dataBuffer.put(value);
    }

    @Override
    public void writeShort(short value) throws IOException {
        this.ensureBufferSpace(2);
        this.m_dataBuffer.putShort(value);
    }

    @Override
    public void writeFloat(float value) throws IOException {
        this.ensureBufferSpace(4);
        this.m_dataBuffer.putFloat(value);
    }

    @Override
    public void writeInt(int value) throws IOException {
        this.ensureBufferSpace(4);
        this.m_dataBuffer.putInt(value);
    }

    @Override
    public void writeLong(long value) throws IOException {
        this.ensureBufferSpace(8);
        this.m_dataBuffer.putLong(value);
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        this.ensureBufferSpace(1);
        this.m_dataBuffer.put((byte)(value ? 1 : 0));
    }

    @Override
    public void writeString(String value) throws IOException {
        if (value == null) {
            this.ensureBufferSpace(1);
            this.m_dataBuffer.put((byte)110);
        } else if (value.length() == 0) {
            this.ensureBufferSpace(1);
            this.m_dataBuffer.put((byte)101);
        } else {
            Integer index = this.m_stringToId.get(value);
            if (index == null) {
                index = this.m_stringToId.size();
                this.m_stringToId.put(value, index);
                byte[] bytes = value.getBytes(this.getCharacterSet());
                this.ensureBufferSpace(3 + bytes.length);
                this.m_dataBuffer.put((byte)83);
                assert (bytes.length > 0 && bytes.length < 32768) : "String too long: " + bytes.length;
                this.m_dataBuffer.putShort((short)bytes.length);
                this.m_dataBuffer.put(bytes);
            } else {
                this.ensureBufferSpace(1);
                this.m_dataBuffer.put((byte)115);
                this.writeInt(index);
            }
        }
    }

    private String getContextInfo() {
        if (!this.m_contexts.isEmpty()) {
            StringBuilder builder = new StringBuilder("\n### Context Info Start ###\n");
            int i = 1;
            for (ISnapshotWriter.IWriteStorableContext next : this.m_contexts.values()) {
                builder.append("[").append(i).append("] ").append(next.getClass().getName()).append("\n");
                next.addDiagnosticInfo(builder);
                ++i;
            }
            builder.append("### Context Info End ###");
            return builder.toString();
        }
        return "";
    }

    @Override
    public void write(ISnapshotWriter.IStorable element, ISnapshotWriter.IWriteStorableContext context) throws IOException {
        if (element == null) {
            this.writeInt(0);
        } else {
            if (context != null) {
                ISnapshotWriter.IWriteStorableContext previous = this.m_contexts.put(element, context);
                assert (previous == null) : "Context already added for: " + element.getClass().getName();
            }
            assert (element.persist(this.m_mode)) : "Must not be persisted [" + Integer.toHexString(element.hashCode()) + "] " + element.getClass().getName() + this.getContextInfo();
            if (element instanceof NamedElement) {
                NamedElement original = ((NamedElement)element).getOriginal();
                Integer id = this.m_namedElementToId.get(original);
                assert (id != null) : "Unknown element [" + Integer.toHexString(original.hashCode()) + "] " + original.getClass().getName() + ": " + String.valueOf(original) + this.getContextInfo();
                this.writeInt(id + 1);
            } else if (element instanceof ISnapshotDependency) {
                ISnapshotDependency dep = (ISnapshotDependency)element;
                ISnapshotDependency.IDependencyEndpoint from = dep.getFrom();
                assert (from instanceof NamedElement) : "'from' must be of type " + NamedElement.class.getName() + this.getContextInfo();
                NamedElement originalFrom = ((NamedElement)((Object)from)).getOriginal();
                assert (originalFrom != null && originalFrom instanceof ISnapshotDependency.IDependencyEndpoint) : "Unexpected class in method 'write': " + String.valueOf(originalFrom) + this.getContextInfo();
                Integer id = this.m_namedElementToId.get(originalFrom);
                assert (id != null) : "Unknown element [" + Integer.toHexString(originalFrom.hashCode()) + "] " + originalFrom.getClass().getName() + ": " + String.valueOf(originalFrom) + this.getContextInfo();
                this.writeInt(id + 1);
                this.writeInt(((ISnapshotDependency.IDependencyEndpoint)((Object)originalFrom)).getIndexOfOutgoingDependency(dep));
            } else {
                this.writeString(element.getClass().getName());
                element.store(this);
            }
            if (context != null) {
                ISnapshotWriter.IWriteStorableContext removed = this.m_contexts.remove(element);
                assert (removed == context) : "Context disappeared for: " + element.getClass().getName();
            }
        }
    }

    @Override
    public void writeAny(Any value) throws IOException {
        if (value == null) {
            this.writeByte((byte)48);
        } else {
            switch (value.getType()) {
                case STRING: {
                    this.writeByte((byte)83);
                    this.writeString(value.asString());
                    break;
                }
                case LONG: {
                    this.writeByte((byte)76);
                    this.writeLong(value.asLong());
                    break;
                }
                case LIST: {
                    this.writeByte((byte)91);
                    this.writeInt(value.asList().size());
                    for (Any item : value.asList()) {
                        this.writeAny(item);
                    }
                    break;
                }
            }
        }
    }

    @Override
    public void write(ISnapshotWriter.IStorable element) throws IOException {
        this.write(element, null);
    }

    private static /* synthetic */ boolean lambda$0(TFile f) {
        return true;
    }

    private static /* synthetic */ boolean lambda$1(TFile d) {
        return true;
    }

    private static /* synthetic */ boolean lambda$2(TFile f) {
        return f.getName().endsWith(".dat");
    }

    private static /* synthetic */ boolean lambda$3(TFile d) {
        return d.getName().endsWith(CoreFileType.SNAPSHOT.getDefaultExtension());
    }
}

