/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.snapshot;

import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.nio.charset.Charset;

public abstract class SnapshotProcessor
implements ISnapshotProcessor {
    protected static final short MANAGED_SNAPSHOT_VERSION = 3;
    protected static final short SNAPSHOT_FORMAT_VERSION = 26;
    private static final int MAGIC = 134619154;
    private static final Charset UTF8 = Charset.forName("UTF-8");
    protected static final String ROOTPATH_MAPPING_FILE = "RootMapping.properties";
    protected static final String SNAPSHOT_DATA_FILE = "snapshot.data";

    private static TFile getSnapshotFile(SoftwareSystem softwareSystem, String dataFileName) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'getSnapshotFile' must not be null";
        assert (dataFileName != null && dataFileName.length() > 0) : "Parameter 'dataFileName' of method 'getSnapshotFile' must not be empty";
        TFile hiddenDataDirectory = softwareSystem.getHiddenDataDirectory();
        TFile newDataFile = new TFile((File)hiddenDataDirectory, dataFileName + CoreFileType.SNAPSHOT.getDefaultExtension());
        return newDataFile;
    }

    public static final TFile getSnapshotFile(SoftwareSystem softwareSystem) {
        return SnapshotProcessor.getSnapshotFile(softwareSystem, "system");
    }

    protected TFile getNewSnapshotFile(SoftwareSystem softwareSystem) {
        return SnapshotProcessor.getSnapshotFile(softwareSystem, "system-new");
    }

    protected final int getMagicNumber() {
        return 134619154;
    }

    protected final Charset getCharacterSet() {
        return UTF8;
    }

    public static enum SnapshotMessageCause implements OperationResult.IMessageCause
    {
        MISSING_ELEMENT,
        INCONSISTENT_ROOTDIRECTORY_MAPPING,
        INVALID_SNAPSHOT_FILE_FORMAT,
        INCOMPATIBLE_SNAPSHOT_FILE_FORMAT,
        UPGRADE_NEEDED;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

