/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.report;

import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.report.IBasicReport;
import com.hello2morrow.sonargraph.core.model.report.IReport;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.TrueZipFacade;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.ResourceProviderRegistry;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileWriter;
import groovy.lang.Writable;
import groovy.text.GStringTemplateEngine;
import groovy.text.Template;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReportHtmlWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportHtmlWriter.class);
    private static final String STANDARD_HTML_TEMPLATE = "StandardHtmlReport";
    private static final String ISSUE_DETAIL_HTML_TEMPLATE = "IssueDetails";
    private static final String RESOLUTION_DETAIL_HTML_TEMPLATE = "ResolutionDetails";
    private static final String HTML_REPORT_PATH = "com/hello2morrow/sonargraph/core/persistence/report/html/";
    private static final String HTML_REPORT_STATIC_FILES = "com/hello2morrow/sonargraph/core/persistence/report/html/staticfiles/";
    private final IReport m_report;

    public ReportHtmlWriter(IReport report) {
        assert (report != null) : "Parameter 'report' of method 'ReportHtmlWriter' must not be null";
        this.m_report = report;
    }

    public void storeReportToFile(IWorkerContext context, TFile targetReportFile, int maxMetricValueRowCount, int maxNumberOfIssuesForHtmlReportSplit, int maxNumberOfIssuesPerTypeOnDetailPage, IBasicReport.Focus reportFocus, String diffReportName, OperationResult result) {
        URL detailTemplateUrl;
        TFile detailTargetFile;
        HashMap<String, Object> detailBinding;
        boolean truncated;
        int totalCount;
        assert (context != null) : "Parameter 'context' of method 'storeReportToFile' must not be null";
        assert (targetReportFile != null) : "Parameter 'targetReportFile' of method 'storeReportToFile' must not be null";
        assert (reportFocus != null) : "Parameter 'reportFocus' of method 'storeReportToFile' must not be null";
        assert (result != null) : "Parameter 'result' of method 'storeReportToFile' must not be null";
        if (reportFocus != IBasicReport.Focus.MODULE_LEVEL) {
            TFile targetDirectory = targetReportFile.getParentFile();
            try {
                ReportHtmlWriter.copyStaticResources(targetDirectory);
            }
            catch (Exception e1) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_COPY, (Throwable)e1, "Please ensure that the target directory '%s' is writable and no other process has a lock on any of the contained files!", new Object[]{targetDirectory.getAbsolutePath()});
                return;
            }
        }
        boolean splitIssuesSection = this.determineSplit(this.m_report, maxNumberOfIssuesForHtmlReportSplit, true);
        TreeMap<IIssueId, List<Issue>> sortedUnresolvedIssues = new TreeMap<IIssueId, List<Issue>>(new IssueIdComparator());
        HashMap issueIdToIssueFilenameMap = new HashMap();
        boolean splitResolutionSection = this.determineSplit(this.m_report, maxNumberOfIssuesForHtmlReportSplit, false);
        TreeMap<IIssueId, List<Resolution>> sortedResolutions = new TreeMap<IIssueId, List<Resolution>>(new IssueIdComparator());
        HashMap issueIdToResolutionFilenameMap = new HashMap();
        String mainReportName = FileUtility.getFileNameWithoutExtension((TFile)targetReportFile);
        if (splitIssuesSection) {
            Map<IIssueId, List<Issue>> unresolvedIssuesGroupedByIssueId = this.m_report.getUnresolvedIssues().stream().collect(Collectors.groupingBy(i -> i.getId()));
            sortedUnresolvedIssues.putAll(unresolvedIssuesGroupedByIssueId);
            issueIdToIssueFilenameMap.putAll(sortedUnresolvedIssues.keySet().stream().collect(Collectors.toMap(Function.identity(), i -> mainReportName + "_issue_" + FileUtility.removeInvalidCharactersFromFileName((String)i.getStandardName()) + CoreFileType.REPORT_HTML.getDefaultExtension())));
        }
        if (splitResolutionSection) {
            Map<IIssueId, List<Resolution>> resolutionsGroupedByIssueId = this.m_report.getResolutions().stream().collect(Collectors.groupingBy(r -> this.m_report.getIssueId((Resolution)r)));
            sortedResolutions.putAll(resolutionsGroupedByIssueId);
            issueIdToResolutionFilenameMap.putAll(sortedResolutions.keySet().stream().collect(Collectors.toMap(Function.identity(), i -> mainReportName + "_resolutionFor_" + FileUtility.removeInvalidCharactersFromFileName((String)i.getStandardName()) + CoreFileType.REPORT_HTML.getDefaultExtension())));
        }
        URL templateUrl = CoreResourceProviderAdapter.getInstance().getResourceUrl((ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.TEMPLATE, "com/hello2morrow/sonargraph/core/persistence/report/html/StandardHtmlReport");
        assert (templateUrl != null) : "standard HTML template not found";
        String diffReportValue = diffReportName == null ? null : diffReportName + CoreFileType.REPORT_HTML.getDefaultExtension();
        HashMap<String, Object> binding = new HashMap<String, Object>();
        binding.put("report", this.m_report);
        binding.put("diffReport", diffReportValue);
        binding.put("maxMetricValueRowCountPerMetric", maxMetricValueRowCount);
        binding.put("maxNumberOfIssuesForHtmlReportSplit", maxNumberOfIssuesForHtmlReportSplit);
        binding.put("maxNumberOfIssuesPerTypeOnDetailPage", maxNumberOfIssuesPerTypeOnDetailPage);
        binding.put("splitIssuesSection", splitIssuesSection);
        binding.put("unresolvedIssuesGroupedByIssueId", sortedUnresolvedIssues);
        binding.put("splitResolutionSection", splitResolutionSection);
        binding.put("resolutionsGroupedByIssueId", sortedResolutions);
        binding.put("issueIdToIssueFilenameMap", issueIdToIssueFilenameMap);
        binding.put("issueIdToResolutionFilenameMap", issueIdToResolutionFilenameMap);
        binding.put("reportWriter", this);
        this.generateHtmlFile(targetReportFile, templateUrl, binding, result);
        if (splitIssuesSection) {
            for (Map.Entry nextEntry : sortedUnresolvedIssues.entrySet()) {
                totalCount = ((List)nextEntry.getValue()).size();
                truncated = this.determineTruncation(totalCount, maxNumberOfIssuesPerTypeOnDetailPage);
                List issues = truncated ? ((List)nextEntry.getValue()).subList(0, maxNumberOfIssuesPerTypeOnDetailPage) : (List)nextEntry.getValue();
                detailBinding = new HashMap<String, Object>();
                detailBinding.put("report", this.m_report);
                detailBinding.put("diffReport", diffReportValue);
                detailBinding.put("truncated", truncated);
                detailBinding.put("totalCount", totalCount);
                detailBinding.put("issueId", nextEntry.getKey());
                detailBinding.put("issues", issues);
                detailTargetFile = new TFile((File)targetReportFile.getParentFile(), (String)issueIdToIssueFilenameMap.get(nextEntry.getKey()));
                detailTemplateUrl = CoreResourceProviderAdapter.getInstance().getResourceUrl((ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.TEMPLATE, "com/hello2morrow/sonargraph/core/persistence/report/html/IssueDetails");
                assert (templateUrl != null) : "standard HTML template not found";
                this.generateHtmlFile(detailTargetFile, detailTemplateUrl, detailBinding, result);
            }
        }
        if (splitResolutionSection) {
            for (Map.Entry nextEntry : sortedResolutions.entrySet()) {
                totalCount = ((List)nextEntry.getValue()).size();
                truncated = this.determineTruncation(totalCount, maxNumberOfIssuesPerTypeOnDetailPage);
                List resolutions = truncated ? ((List)nextEntry.getValue()).subList(0, maxNumberOfIssuesPerTypeOnDetailPage) : (List)nextEntry.getValue();
                detailBinding = new HashMap();
                detailBinding.put("report", this.m_report);
                detailBinding.put("diffReport", diffReportValue);
                detailBinding.put("truncated", truncated);
                detailBinding.put("totalCount", totalCount);
                detailBinding.put("issueId", nextEntry.getKey());
                detailBinding.put("resolutions", resolutions);
                detailTargetFile = new TFile((File)targetReportFile.getParentFile(), (String)issueIdToResolutionFilenameMap.get(nextEntry.getKey()));
                detailTemplateUrl = CoreResourceProviderAdapter.getInstance().getResourceUrl((ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.TEMPLATE, "com/hello2morrow/sonargraph/core/persistence/report/html/ResolutionDetails");
                assert (templateUrl != null) : "standard HTML template not found";
                this.generateHtmlFile(detailTargetFile, detailTemplateUrl, detailBinding, result);
            }
        }
    }

    private void generateHtmlFile(TFile targetFile, URL templateUrl, Map<String, Object> binding, OperationResult result) {
        assert (targetFile != null) : "Parameter 'targetFile' of method 'generateHtmlFile' must not be null";
        assert (templateUrl != null) : "Parameter 'templateUrl' of method 'generateHtmlFile' must not be null";
        assert (binding != null) : "Parameter 'binding' of method 'generateHtmlFile' must not be null";
        assert (result != null) : "Parameter 'result' of method 'generateHtmlFile' must not be null";
        long start = System.currentTimeMillis();
        try {
            GStringTemplateEngine engine = new GStringTemplateEngine(this.getClass().getClassLoader());
            Template template = engine.createTemplate(templateUrl);
            Writable writable = template.make(binding);
            try {
                Throwable throwable = null;
                Object var11_13 = null;
                try (BufferedWriter bufferedWriter = new BufferedWriter((Writer)new TFileWriter(targetFile));){
                    writable.writeTo((Writer)bufferedWriter);
                    LOGGER.debug("{} ms needed to write HTML file '" + targetFile.getName() + "'", (Object)(System.currentTimeMillis() - start));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)ex, "Failed to write HTML report.", new Object[0]);
            }
        }
        catch (Exception e) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)e, "Error processing HTML report template", new Object[0]);
        }
    }

    private boolean determineTruncation(int elementCount, int maxNumberOfElements) {
        assert (maxNumberOfElements != 0) : "Parameter 'maxNumberOfElements' must not be 0";
        return maxNumberOfElements > 0 && elementCount > maxNumberOfElements;
    }

    private boolean determineSplit(IReport report, int elementCountToSplitHtmlReport, boolean issuesSection) {
        assert (report != null) : "Parameter 'report' of method 'determineSplit' must not be null";
        assert (elementCountToSplitHtmlReport != 0) : "Parameter 'elementCountToSplitHtmlReport' must not be 0";
        if (elementCountToSplitHtmlReport < 0) {
            return false;
        }
        if (elementCountToSplitHtmlReport == 1) {
            if (issuesSection && report.getUnresolvedIssues().size() > 0) {
                return true;
            }
            if (!issuesSection && report.getResolutions().size() > 0) {
                return true;
            }
        }
        if (issuesSection) {
            return report.getUnresolvedIssues().size() > elementCountToSplitHtmlReport;
        }
        return report.getNumberOfResolutions() > elementCountToSplitHtmlReport;
    }

    public static void copyStaticResources(TFile targetDirectory) throws Exception {
        TFile normalizedTargetDir = targetDirectory.getNormalizedAbsoluteFile();
        StaticHtmlReportResource[] staticHtmlReportResourceArray = StaticHtmlReportResource.values();
        int n = staticHtmlReportResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object tableFilterDir;
            StaticHtmlReportResource resource = staticHtmlReportResourceArray[n2];
            URL url = CoreResourceProviderAdapter.getInstance().getResourceUrl(resource.getResourceType(), HTML_REPORT_STATIC_FILES + resource.getResourceName());
            TFile out = new TFile((File)normalizedTargetDir, resource.getResourceName() + resource.getResourceType().getExtension());
            if (out.exists()) {
                out.rm_r();
            }
            if (resource == StaticHtmlReportResource.TABLE_FILTER && (tableFilterDir = new TFile((File)normalizedTargetDir, resource.getResourceName())).exists()) {
                tableFilterDir.rm_r();
            }
            tableFilterDir = null;
            Object var9_10 = null;
            try (InputStream inputStream = url.openStream();){
                Files.copy(inputStream, Paths.get(out.getAbsolutePath(), new String[0]), new CopyOption[0]);
            }
            catch (Throwable throwable) {
                if (tableFilterDir == null) {
                    tableFilterDir = throwable;
                } else if (tableFilterDir != throwable) {
                    ((Throwable)tableFilterDir).addSuppressed(throwable);
                }
                throw tableFilterDir;
            }
            if (resource == StaticHtmlReportResource.TABLE_FILTER) {
                TFile targetDir = new TFile((File)normalizedTargetDir, resource.getResourceName());
                if (!targetDir.isDirectory()) {
                    targetDir.mkdir(true);
                }
                FileUtility.extractArchiveToDir((TFile)out, (TFile)normalizedTargetDir);
                TrueZipFacade.clear((TFile)out);
                try {
                    out.rm_r();
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to delete table filter archive '" + String.valueOf(out) + "'", (Throwable)ex);
                }
            }
            ++n2;
        }
    }

    String getSupportedSeveritiesAsString(IIssueId id) {
        assert (id != null) : "Parameter 'id' of method 'getSupportedSeveritiesAsString' must not be null";
        return id.getSupportedSeverities().stream().map(s -> s.getPresentationName()).collect(Collectors.joining(", "));
    }

    private static class IssueIdComparator
    implements Comparator<IIssueId> {
        private IssueIdComparator() {
        }

        @Override
        public int compare(IIssueId i1, IIssueId i2) {
            return i1.getPresentationName().compareTo(i2.getPresentationName());
        }
    }

    public static enum StaticHtmlReportResource {
        HEADER_GIF("header", (ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.IMAGE),
        CSS("hello2morrow", (ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.CSS),
        H2M_GIF("hello2morrow", (ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.IMAGE),
        SG_GIF("logo", (ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.IMAGE),
        SPACER_GIF("spacer", (ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.IMAGE),
        TABLE_FILTER("tablefilter", (ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.ZIP),
        FAV_ICON("favicon", (ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.PNG),
        SUCCESS("Success", (ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.IMAGE),
        ERROR("Error", (ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.IMAGE);

        private final String m_resourceName;
        private final ResourceProviderRegistry.IResourceType m_resourceType;

        private StaticHtmlReportResource(String resourceName, ResourceProviderRegistry.IResourceType resourceType) {
            this.m_resourceName = resourceName;
            this.m_resourceType = resourceType;
        }

        public String getResourceName() {
            return this.m_resourceName;
        }

        public ResourceProviderRegistry.IResourceType getResourceType() {
            return this.m_resourceType;
        }
    }
}

