/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.report;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.persistence.base.JaxbAccess;
import com.hello2morrow.sonargraph.core.persistence.report.AbstractExportMetaDataXmlAccess;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Version;
import com.hello2morrow.sonargraph.foundation.utilities.XmlUtility;
import com.hello2morrow.sonargraph.integration.access.persistence.JaxbAdapter;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlAccess;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlIdGenerator;
import com.hello2morrow.sonargraph.integration.access.persistence.report.ObjectFactory;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdExportMetaData;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdExportMetaDataRoot;
import de.schlichtherle.truezip.file.TFile;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;

public final class ExportMetaDataXmlWriter
extends AbstractExportMetaDataXmlAccess<JAXBElement<XsdExportMetaDataRoot>> {
    private final ObjectFactory m_objectFactory = new ObjectFactory();
    private final XmlIdGenerator m_idGenerator = new XmlIdGenerator();
    private final Version m_version;
    private final String m_systemPath;
    private final String m_systemId;
    private final Map<IMetricId, List<IMetricLevel>> m_metricIdToLevelMap;
    private final List<IssueCategory> m_issueCategories;
    private final List<IProviderId> m_issueProviders;
    private final List<IIssueId> m_issueIds;

    public ExportMetaDataXmlWriter(Version version, String systemPath, String systemId, Map<IMetricId, List<IMetricLevel>> metricIdToLevelMap, List<IssueCategory> issueCategories, List<IProviderId> issueProviders, List<IIssueId> issueIds) {
        assert (version != null) : "Parameter 'version' of method 'ExportMetaDataXmlWriter' must not be null";
        assert (systemPath != null && systemPath.length() > 0) : "Parameter 'systemPath' of method 'ExportMetaDataXmlWriter' must not be empty";
        assert (systemId != null && systemId.length() > 0) : "Parameter 'systemId' of method 'ExportMetaDataXmlWriter' must not be empty";
        assert (metricIdToLevelMap != null && metricIdToLevelMap.size() > 0) : "Parameter 'metricIdToLevelMap' of method 'ExportMetaDataXmlWriter' must not be empty";
        assert (issueCategories != null && issueCategories.size() > 0) : "Parameter 'issueCategories' of method 'ExportMetaDataXmlWriter' must not be empty";
        assert (issueProviders != null && !issueProviders.isEmpty()) : "Parameter 'issueProviders' of method 'ExportMetaDataXmlWriter' must not be empty";
        assert (issueIds != null && !issueIds.isEmpty()) : "Parameter 'issueIds' of method 'ExportMetaDataXmlWriter' must not be empty";
        this.m_version = version;
        this.m_systemPath = systemPath;
        this.m_systemId = systemId;
        this.m_metricIdToLevelMap = metricIdToLevelMap;
        this.m_issueCategories = issueCategories;
        this.m_issueProviders = issueProviders;
        this.m_issueIds = issueIds;
    }

    public void writeToFile(TFile targetFile, OperationResult result) {
        assert (targetFile != null) : "Parameter 'targetFile' of method 'save' must not be null";
        assert (result != null) : "Parameter 'result' of method 'save' must not be null";
        JAXBElement<XsdExportMetaDataRoot> xsdMetrics = this.createXmlObject();
        JaxbAdapter jaxbAdapter = XmlAccess.createExportMetaDataJaxbAdapter();
        try {
            JaxbAccess.save(jaxbAdapter, xsdMetrics, targetFile);
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)ex);
        }
    }

    private JAXBElement<XsdExportMetaDataRoot> createXmlObject() {
        XsdExportMetaDataRoot xsdExportMetaData = this.m_objectFactory.createXsdExportMetaDataRoot();
        xsdExportMetaData.setVersion(this.m_version.toString());
        xsdExportMetaData.setSystemPathUsedForExport(this.m_systemPath);
        xsdExportMetaData.setSystemId(this.m_systemId);
        xsdExportMetaData.setTimestamp(XmlUtility.createDateTimeObject((long)System.currentTimeMillis()));
        this.createXmlExportMetaData(this.m_idGenerator, this.m_objectFactory, this.m_metricIdToLevelMap, this.m_issueCategories, this.m_issueProviders, this.m_issueIds, (XsdExportMetaData)xsdExportMetaData);
        return this.m_objectFactory.createExportMetaData(xsdExportMetaData);
    }
}

