/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.treemap;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.treemap.ScriptMetricValueSource;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapLeafElement;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapValueSource;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class TreeMapProperties {
    public static final String RED_THRESHOLD_VALID_DESCRIPTION = "0 (dynamic) or a positive multiple of 2";
    public static final String RED_THRESHOLD_NOT_VALID = "Red threshold must be 0 or a positive multiple of 2";
    public static final int INVALID_RED_THRESHOLD = -1;
    public static final int DYNAMIC_RED_THRESHOLD = 0;
    private final Map<TreeMapLeafElement, List<TreeMapValueSource>> m_leafToAvailableSizeSources;
    private final Map<TreeMapLeafElement, List<TreeMapValueSource>> m_leafToAvailableColorSources;
    private final Map<TreeMapLeafElement, List<TreeMapValueSource>> m_leafToAvailableHeightSources;
    private String m_name = "";
    private String m_description = "";
    private TreeMapLeafElement m_leafElement;
    private TreeMapValueSource m_sizeSource;
    private TreeMapValueSource m_colorSource;
    private TreeMapValueSource m_heightSource;
    private int m_redThreshold = 0;

    public static ValidationResult isRedThresholdValid(int redThreshold) {
        ValidationResult result = new ValidationResult();
        if (redThreshold == 0 || redThreshold > 0 && redThreshold % 2 == 0) {
            return result;
        }
        result.addError(RED_THRESHOLD_NOT_VALID);
        return result;
    }

    public static ITextValidator getRedThresholdValidator() {
        return new ITextValidator(){

            @Override
            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                if (newInput != null) {
                    newInput = newInput.trim();
                }
                if (newInput.isEmpty()) {
                    result.addError(TreeMapProperties.RED_THRESHOLD_NOT_VALID);
                    return result;
                }
                try {
                    int number = Integer.parseInt(newInput);
                    result.addMessagesFrom(TreeMapProperties.isRedThresholdValid(number));
                }
                catch (NumberFormatException e) {
                    result.addError(TreeMapProperties.RED_THRESHOLD_NOT_VALID);
                    return result;
                }
                return result;
            }
        };
    }

    public TreeMapProperties(Map<TreeMapLeafElement, List<TreeMapValueSource>> leafToAvailableSizeSources, Map<TreeMapLeafElement, List<TreeMapValueSource>> leafToAvailableColorSources, Map<TreeMapLeafElement, List<TreeMapValueSource>> leafToAvailableHeightSources, TreeMapValueSource sizeSource, TreeMapValueSource colorSource, TreeMapValueSource heightSource, TreeMapLeafElement leafElement) {
        assert (leafToAvailableSizeSources != null && !leafToAvailableSizeSources.isEmpty()) : "Parameter 'leafToAvailableSizeSources' of method 'TreeMapProperties' must not be empty";
        assert (leafToAvailableColorSources != null && !leafToAvailableColorSources.isEmpty()) : "Parameter 'leafToAvailableColorSources' of method 'TreeMapProperties' must not be empty";
        assert (leafToAvailableHeightSources != null && !leafToAvailableHeightSources.isEmpty()) : "Parameter 'leafToAvailableHeightSources' of method 'TreeMapProperties' must not be empty";
        assert (sizeSource != null) : "Parameter 'sizeSource' of method 'TreeMapProperties' must not be null";
        assert (colorSource != null) : "Parameter 'colorSource' of method 'TreeMapProperties' must not be null";
        assert (leafElement != null) : "Parameter 'leafElement' of method 'TreeMapProperties' must not be null";
        assert (sizeSource != colorSource) : "Same sources";
        assert (sizeSource != heightSource) : "Same sources";
        List<TreeMapValueSource> availableSizeSources = leafToAvailableSizeSources.get((Object)leafElement);
        assert (availableSizeSources != null && !availableSizeSources.isEmpty()) : "'availableSizeSources' of method 'TreeMapProperties' must not be empty";
        assert (availableSizeSources.contains(sizeSource)) : "'sizeSource' not found: " + String.valueOf(sizeSource);
        List<TreeMapValueSource> availableColorOrHeightSources = leafToAvailableColorSources.get((Object)leafElement);
        assert (availableColorOrHeightSources != null && !availableColorOrHeightSources.isEmpty()) : "'availableColorSources' of method 'TreeMapProperties' must not be empty";
        assert (availableColorOrHeightSources.contains(colorSource)) : "'colorSource' not found: " + String.valueOf(sizeSource);
        this.m_leafToAvailableSizeSources = new LinkedHashMap<TreeMapLeafElement, List<TreeMapValueSource>>(leafToAvailableSizeSources);
        this.m_leafToAvailableColorSources = new LinkedHashMap<TreeMapLeafElement, List<TreeMapValueSource>>(leafToAvailableColorSources);
        this.m_leafToAvailableHeightSources = new LinkedHashMap<TreeMapLeafElement, List<TreeMapValueSource>>(leafToAvailableHeightSources);
        this.m_sizeSource = sizeSource;
        this.m_colorSource = colorSource;
        this.m_heightSource = heightSource;
        this.m_leafElement = leafElement;
        this.validateSizeAndHeightSources();
    }

    private void validateSizeAndHeightSources() {
        if (this.m_colorSource == this.m_heightSource) {
            this.m_colorSource.setError("Color and height source must be different.");
            this.m_heightSource.setError("Color and height source must be different.");
        } else {
            this.m_colorSource.setError(null);
            this.m_heightSource.setError(null);
        }
    }

    private static TreeMapValueSource getCopy(TreeMapValueSource valueSource, Map<TreeMapValueSource, TreeMapValueSource> sourceToCopy) {
        assert (valueSource != null) : "Parameter 'valueSource' of method 'getCopy' must not be null";
        assert (sourceToCopy != null) : "Parameter 'sourceToCopy' of method 'getCopy' must not be null";
        TreeMapValueSource copy = sourceToCopy.get(valueSource);
        if (copy == null) {
            copy = valueSource.copy();
            sourceToCopy.put(valueSource, copy);
        }
        return copy;
    }

    public TreeMapProperties(TreeMapProperties properties) {
        List<TreeMapValueSource> nextTargetValueSources;
        TreeMapValueSource nextCopy;
        TreeMapLeafElement nextLeafElement;
        assert (properties != null) : "Parameter 'properties' of method 'TreeMapProperties' must not be null";
        THashMap sourceToCopy = new THashMap();
        this.m_leafToAvailableSizeSources = new LinkedHashMap<TreeMapLeafElement, List<TreeMapValueSource>>(properties.m_leafToAvailableSizeSources.size());
        for (Map.Entry<TreeMapLeafElement, List<TreeMapValueSource>> nextEntry : properties.m_leafToAvailableSizeSources.entrySet()) {
            nextLeafElement = nextEntry.getKey();
            for (TreeMapValueSource nextValueSource : nextEntry.getValue()) {
                nextCopy = TreeMapProperties.getCopy(nextValueSource, (Map<TreeMapValueSource, TreeMapValueSource>)sourceToCopy);
                nextTargetValueSources = this.m_leafToAvailableSizeSources.get((Object)nextLeafElement);
                if (nextTargetValueSources == null) {
                    nextTargetValueSources = new ArrayList<TreeMapValueSource>(5);
                    this.m_leafToAvailableSizeSources.put(nextLeafElement, nextTargetValueSources);
                }
                nextTargetValueSources.add(nextCopy);
                if (properties.getSizeSource() != nextValueSource) continue;
                this.m_sizeSource = nextCopy;
            }
        }
        this.m_leafToAvailableColorSources = new LinkedHashMap<TreeMapLeafElement, List<TreeMapValueSource>>(properties.m_leafToAvailableColorSources.size());
        for (Map.Entry<TreeMapLeafElement, List<TreeMapValueSource>> nextEntry : properties.m_leafToAvailableColorSources.entrySet()) {
            nextLeafElement = nextEntry.getKey();
            for (TreeMapValueSource nextValueSource : nextEntry.getValue()) {
                nextCopy = TreeMapProperties.getCopy(nextValueSource, (Map<TreeMapValueSource, TreeMapValueSource>)sourceToCopy);
                nextTargetValueSources = this.m_leafToAvailableColorSources.get((Object)nextLeafElement);
                if (nextTargetValueSources == null) {
                    nextTargetValueSources = new ArrayList<TreeMapValueSource>(5);
                    this.m_leafToAvailableColorSources.put(nextLeafElement, nextTargetValueSources);
                }
                nextTargetValueSources.add(nextCopy);
                if (properties.getColorSource() != nextValueSource) continue;
                this.m_colorSource = nextCopy;
            }
        }
        this.m_leafToAvailableHeightSources = new LinkedHashMap<TreeMapLeafElement, List<TreeMapValueSource>>(properties.m_leafToAvailableHeightSources.size());
        for (Map.Entry<TreeMapLeafElement, List<TreeMapValueSource>> nextEntry : properties.m_leafToAvailableHeightSources.entrySet()) {
            nextLeafElement = nextEntry.getKey();
            for (TreeMapValueSource nextValueSource : nextEntry.getValue()) {
                nextCopy = TreeMapProperties.getCopy(nextValueSource, (Map<TreeMapValueSource, TreeMapValueSource>)sourceToCopy);
                nextTargetValueSources = this.m_leafToAvailableHeightSources.get((Object)nextLeafElement);
                if (nextTargetValueSources == null) {
                    nextTargetValueSources = new ArrayList<TreeMapValueSource>(5);
                    this.m_leafToAvailableHeightSources.put(nextLeafElement, nextTargetValueSources);
                }
                nextTargetValueSources.add(nextCopy);
                if (properties.getHeightSource() != nextValueSource) continue;
                this.m_heightSource = nextCopy;
            }
        }
        this.m_name = properties.m_name;
        this.m_description = properties.m_description;
        this.m_leafElement = properties.m_leafElement;
        this.m_redThreshold = properties.m_redThreshold;
        assert (this.m_sizeSource != null) : "'m_sizeSource' of method 'TreeMapProperties' must not be null";
        assert (this.m_colorSource != null) : "'m_colorSource' of method 'TreeMapProperties' must not be null";
        assert (this.m_heightSource != null) : "'m_heightSource' of method 'TreeMapProperties' must not be null";
        assert (this.m_sizeSource != this.m_colorSource) : "Same sources";
        assert (this.m_sizeSource != this.m_heightSource) : "Same sources";
        List<TreeMapValueSource> availableSizeSources = this.m_leafToAvailableSizeSources.get((Object)this.m_leafElement);
        assert (availableSizeSources != null && !availableSizeSources.isEmpty()) : "'availableSizeSources' of method 'TreeMapProperties' must not be empty";
        assert (availableSizeSources.contains(this.m_sizeSource)) : "'sizeSource' not found: " + String.valueOf(this.m_sizeSource);
        List<TreeMapValueSource> availableColorSources = this.m_leafToAvailableColorSources.get((Object)this.m_leafElement);
        assert (availableColorSources != null && !availableColorSources.isEmpty()) : "'availableColorSources' of method 'TreeMapProperties' must not be empty";
        assert (availableColorSources.contains(this.m_colorSource)) : "'colorSource' not found: " + String.valueOf(this.m_sizeSource);
        List<TreeMapValueSource> availableHeightSources = this.m_leafToAvailableHeightSources.get((Object)this.m_leafElement);
        assert (availableHeightSources != null && !availableHeightSources.isEmpty()) : "'availableHeightSources' of method 'TreeMapProperties' must not be empty";
        assert (availableHeightSources.contains(this.m_heightSource)) : "'colorSource' not found: " + String.valueOf(this.m_sizeSource);
        this.validateSizeAndHeightSources();
    }

    public List<TreeMapValueSource> getAvailableSizeSources() {
        return Collections.unmodifiableList(this.m_leafToAvailableSizeSources.get((Object)this.m_leafElement));
    }

    public List<TreeMapValueSource> getAvailableColorSources() {
        return Collections.unmodifiableList(this.m_leafToAvailableColorSources.get((Object)this.m_leafElement));
    }

    public List<TreeMapValueSource> getAvailableHeightSources() {
        return Collections.unmodifiableList(this.m_leafToAvailableHeightSources.get((Object)this.m_leafElement));
    }

    public void clearScriptMetricValueColorSources() {
        TreeMapValueSource nextValueSource;
        Iterator<TreeMapValueSource> nextIter;
        for (List<TreeMapValueSource> nextValueSources : this.m_leafToAvailableColorSources.values()) {
            nextIter = nextValueSources.iterator();
            while (nextIter.hasNext()) {
                nextValueSource = nextIter.next();
                if (!(nextValueSource instanceof ScriptMetricValueSource)) continue;
                nextIter.remove();
            }
        }
        for (List<TreeMapValueSource> nextValueSources : this.m_leafToAvailableHeightSources.values()) {
            nextIter = nextValueSources.iterator();
            while (nextIter.hasNext()) {
                nextValueSource = nextIter.next();
                if (!(nextValueSource instanceof ScriptMetricValueSource)) continue;
                nextIter.remove();
            }
        }
    }

    public void addScriptMetricValueColorSource(ScriptMetricValueSource valueSource) {
        assert (valueSource != null) : "Parameter 'valueSource' of method 'addScriptMetricValueColorSource' must not be null";
        List<TreeMapValueSource> colorValueSources = this.m_leafToAvailableColorSources.get((Object)valueSource.getLeafElement());
        assert (colorValueSources != null && !colorValueSources.isEmpty()) : "'colorValueSources' of method 'addScriptMetricValueColorSource' must not be empty";
        colorValueSources.add(valueSource);
        List<TreeMapValueSource> heightValueSources = this.m_leafToAvailableHeightSources.get((Object)valueSource.getLeafElement());
        assert (heightValueSources != null && !heightValueSources.isEmpty()) : "'heightValueSources' of method 'addScriptMetricValueColorSource' must not be empty";
        heightValueSources.add(valueSource);
    }

    public void setName(String name) {
        assert (name != null) : "Parameter 'name' of method 'setName' must not be null";
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setDescription(String description) {
        assert (description != null) : "Parameter 'description' of method 'setDescription' must not be null";
        this.m_description = description;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setLeafElement(TreeMapLeafElement element) {
        assert (element != null) : "Parameter 'element' of method 'setLeafElement' must not be null";
        List<TreeMapValueSource> sizeSources = this.m_leafToAvailableSizeSources.get((Object)element);
        assert (sizeSources != null && !sizeSources.isEmpty()) : "'sizeSources' of method 'setLeafElement' must not be empty";
        List<TreeMapValueSource> colorSources = this.m_leafToAvailableColorSources.get((Object)element);
        assert (colorSources != null && !colorSources.isEmpty()) : "'colorSources' of method 'setLeafElement' must not be empty";
        List<TreeMapValueSource> heightSources = this.m_leafToAvailableHeightSources.get((Object)element);
        assert (heightSources != null && !heightSources.isEmpty()) : "'heightSources' of method 'setLeafElement' must not be empty";
        this.m_leafElement = element;
        TreeMapValueSource sizeSource = null;
        for (TreeMapValueSource nextValueSource : this.getAvailableSizeSources()) {
            if (nextValueSource != this.m_sizeSource) continue;
            sizeSource = nextValueSource;
            break;
        }
        TreeMapValueSource colorSource = null;
        for (TreeMapValueSource nextValueSource : this.getAvailableColorSources()) {
            if (nextValueSource != this.m_colorSource) continue;
            colorSource = nextValueSource;
            break;
        }
        TreeMapValueSource heightSource = null;
        for (TreeMapValueSource nextValueSource : this.getAvailableHeightSources()) {
            if (nextValueSource != this.m_heightSource) continue;
            heightSource = nextValueSource;
            break;
        }
        this.m_sizeSource = sizeSource != null ? sizeSource : sizeSources.get(0);
        this.m_colorSource = colorSource != null ? colorSource : colorSources.get(0);
        this.m_heightSource = heightSource != null ? heightSource : heightSources.get(0);
        this.validateSizeAndHeightSources();
    }

    public TreeMapLeafElement getLeafElement() {
        return this.m_leafElement;
    }

    public void setSizeSource(TreeMapValueSource sizeSource) {
        assert (sizeSource != null) : "Parameter 'sizeSource' of method 'setSizeSource' must not be null";
        assert (this.m_leafToAvailableSizeSources.get((Object)this.m_leafElement).contains(sizeSource)) : "Not available: " + String.valueOf(sizeSource);
        this.m_sizeSource = sizeSource;
    }

    public TreeMapValueSource getSizeSource() {
        return this.m_sizeSource;
    }

    public void setColorSource(TreeMapValueSource colorSource) {
        assert (colorSource != null) : "Parameter 'colorSource' of method 'setColorSource' must not be null";
        assert (this.m_leafToAvailableColorSources.get((Object)this.m_leafElement).contains(colorSource)) : "Not available: " + String.valueOf(colorSource);
        this.m_colorSource = colorSource;
        this.validateSizeAndHeightSources();
    }

    public TreeMapValueSource getColorSource() {
        return this.m_colorSource;
    }

    public void setHeightSource(TreeMapValueSource heightSource) {
        assert (heightSource != null) : "Parameter 'heightSource' of method 'setHeightSource' must not be null";
        assert (this.m_leafToAvailableHeightSources.get((Object)this.m_leafElement).contains(heightSource)) : "Not available: " + String.valueOf(heightSource);
        this.m_heightSource = heightSource;
        this.validateSizeAndHeightSources();
    }

    public TreeMapValueSource getHeightSource() {
        return this.m_heightSource;
    }

    public void setRedThreshold(int redThreshold) {
        assert (redThreshold >= -1) : "Unexpected red threshold: " + redThreshold;
        this.m_redThreshold = redThreshold;
    }

    public int getRedThreshold() {
        return this.m_redThreshold;
    }

    public ValidationResult isValid() {
        ValidationResult result = new ValidationResult();
        result.addMessagesFrom(this.m_sizeSource.isValid());
        result.addMessagesFrom(this.m_colorSource.isValid());
        result.addMessagesFrom(this.m_heightSource.isValid());
        result.addMessagesFrom(TreeMapProperties.isRedThresholdValid(this.m_redThreshold));
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_name.hashCode();
        result = 31 * result + this.m_description.hashCode();
        result = 31 * result + this.m_leafElement.hashCode();
        result = 31 * result + this.m_sizeSource.hashCode();
        result = 31 * result + this.m_colorSource.hashCode();
        result = 31 * result + this.m_heightSource.hashCode();
        result = 31 * result + this.m_redThreshold;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TreeMapProperties other = (TreeMapProperties)obj;
        return this.m_name.equals(other.m_name) && this.m_description.equals(other.m_description) && this.m_leafElement.equals((Object)other.m_leafElement) && this.m_sizeSource.equals(other.m_sizeSource) && this.m_colorSource.equals(other.m_colorSource) && this.m_heightSource.equals(other.m_heightSource) && this.m_redThreshold == other.m_redThreshold;
    }

    public String toString() {
        return "'" + this.m_name + "'" + (String)(this.m_description.isEmpty() ? "" : " (" + this.m_description + ")") + " Leaf element:" + String.valueOf((Object)this.m_leafElement) + ", size source:" + String.valueOf(this.m_sizeSource) + ", color source:" + String.valueOf(this.m_colorSource) + ", height source:" + String.valueOf(this.m_heightSource) + ", red threshold:" + this.m_redThreshold;
    }
}

