/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.transaction;

import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public final class AnalyzerExecutionInfo {
    private final Mode m_mode;
    private final Set<AnalyzerGroup> m_groups;
    private static final AnalyzerExecutionInfo ALL = new AnalyzerExecutionInfo(Mode.ALL, Collections.emptySet());
    private static final AnalyzerExecutionInfo NONE = new AnalyzerExecutionInfo(Mode.NONE, Collections.emptySet());

    private AnalyzerExecutionInfo(Mode mode, Set<AnalyzerGroup> groups) {
        assert (mode != null) : "Parameter 'mode' of method 'AnalyzerExecutionInfo' must not be null";
        assert (groups != null) : "Parameter 'groups' of method 'AnalyzerExecutionInfo' must not be null";
        this.m_groups = groups;
        this.m_mode = mode;
    }

    public Mode getMode() {
        return this.m_mode;
    }

    public Set<AnalyzerGroup> getGroups() {
        return Collections.unmodifiableSet(this.m_groups);
    }

    public static AnalyzerExecutionInfo all() {
        return ALL;
    }

    public static AnalyzerExecutionInfo none() {
        return NONE;
    }

    public static AnalyzerExecutionInfo groups(Set<AnalyzerGroup> groups) {
        assert (groups != null && !groups.isEmpty()) : "Parameter 'groups' of method 'groups' must not be empty";
        return new AnalyzerExecutionInfo(Mode.GROUPS, new LinkedHashSet<AnalyzerGroup>(groups));
    }

    public static enum Mode {
        ALL,
        GROUPS,
        NONE;

    }
}

