/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.ranking;

import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.ranking.IssueRank;

public final class IssueRankRecord {
    private final Issue m_scoredElement;
    private float m_score;
    private float m_importance;
    private float m_importanceSeverity;
    private float m_importanceImpact;
    private float m_importanceIssueCategory;
    private float m_urgency;
    private float m_urgencyEaseOfFix;
    private float m_urgencySystemDiff;
    private float m_urgencyScm;
    private float m_urgencyScm30d;
    private float m_urgencyScm90d;
    private float m_urgencyScm365d;
    private String m_importanceAlgorithm;
    private String m_urgencyAlgorithm;
    private String m_importanceImpactAlgorithm;
    private String m_urgencyEaseOfFixAlgorithm;
    private String m_urgencyScmAlgorithm;
    private String m_urgencyScm30Algorithm;
    private String m_urgencyScm90Algorithm;
    private String m_urgencyScm365Algorithm;
    private String m_scoreAlgorithm;

    public IssueRankRecord(Issue scoredElement) {
        assert (scoredElement != null) : "Parameter 'scoredElement' of method 'ScoreBuilder' must not be null";
        this.m_scoredElement = scoredElement;
    }

    public IssueRank createElement(NamedElement parent) {
        IssueRank issueRank = new IssueRank(parent, this.m_scoredElement, this.m_score, this.m_importanceSeverity, this.m_importanceIssueCategory, this.m_importanceImpact, this.m_importance, this.m_urgencyEaseOfFix, this.m_urgencySystemDiff, this.m_urgencyScm30d, this.m_urgencyScm90d, this.m_urgencyScm365d, this.m_urgencyScm, this.m_urgency);
        issueRank.setScoreAlgorithm(this.m_scoreAlgorithm);
        issueRank.setImportanceAlgorithm(this.m_importanceAlgorithm);
        issueRank.setUrgencyAlgorithm(this.m_urgencyAlgorithm);
        issueRank.setImportanceImpactAlgorithm(this.m_importanceImpactAlgorithm);
        issueRank.setUrgencyEaseOfFixAlgorithm(this.m_urgencyEaseOfFixAlgorithm);
        if (this.m_urgencyScm30Algorithm != null) {
            issueRank.setUrgencyScm30Algorithm(this.m_urgencyScm30Algorithm);
        }
        if (this.m_urgencyScm90Algorithm != null) {
            issueRank.setUrgencyScm90Algorithm(this.m_urgencyScm90Algorithm);
        }
        if (this.m_urgencyScm365Algorithm != null) {
            issueRank.setUrgencyScm365Algorithm(this.m_urgencyScm365Algorithm);
        }
        issueRank.setUrgencyScmAlgorithm(this.m_urgencyScmAlgorithm);
        return issueRank;
    }

    public void setUrgency(float urgency) {
        this.m_urgency = urgency;
    }

    public void setImportanceSeverity(float score) {
        this.m_importanceSeverity = score;
    }

    public void setImportance(float importance) {
        this.m_importance = importance;
    }

    public void setScore(float score) {
        this.m_score = score;
    }

    public void setScoreAlgorithm(String algorithm) {
        assert (algorithm != null && algorithm.length() > 0) : "Parameter 'algorithm' of method 'setScoreAlgorithm' must not be empty";
        this.m_scoreAlgorithm = algorithm;
    }

    public void setImportanceIssueType(float importanceIssueType) {
        this.m_importanceIssueCategory = importanceIssueType;
    }

    public void setImportanceImpact(float importanceImpact) {
        this.m_importanceImpact = importanceImpact;
    }

    public void setUrgencyEaseOfFix(float urgencyEaseOfFix) {
        this.m_urgencyEaseOfFix = urgencyEaseOfFix;
    }

    public void setUrgencySystemDiff(float urgencySystemDiff) {
        this.m_urgencySystemDiff = urgencySystemDiff;
    }

    public void setUrgencyScm(float urgencyScm) {
        this.m_urgencyScm = urgencyScm;
    }

    public void setUrgencyScm30d(float urgencyScm30d) {
        this.m_urgencyScm30d = urgencyScm30d;
    }

    public void setUrgencyScm90d(float urgencyScm90d) {
        this.m_urgencyScm90d = urgencyScm90d;
    }

    public void setUrgencyScm365d(float urgencyScm365d) {
        this.m_urgencyScm365d = urgencyScm365d;
    }

    public float getScore() {
        return this.m_score;
    }

    public void setImportanceAlgorithm(String algorithm) {
        assert (algorithm != null && algorithm.length() > 0) : "Parameter 'algorithm' of method 'setImportanceAlgorithm' must not be empty";
        this.m_importanceAlgorithm = algorithm;
    }

    public void setUrgencyAlgorithm(String algorithm) {
        assert (algorithm != null && algorithm.length() > 0) : "Parameter 'algorithm' of method 'setUrgencyAlgorithm' must not be empty";
        this.m_urgencyAlgorithm = algorithm;
    }

    public void setImportanceImpactAlgorithm(String algorithm) {
        assert (algorithm != null) : "Parameter 'algorithm' of method 'setImportanceImpactAlgorithm' must not be null";
        this.m_importanceImpactAlgorithm = algorithm;
    }

    public void setUrgencyEaseOfFixAlgorithm(String algorithm) {
        assert (algorithm != null && algorithm.length() > 0) : "Parameter 'algorithm' of method 'setUrgencyEaseOfFixAlgorithm' must not be empty";
        this.m_urgencyEaseOfFixAlgorithm = algorithm;
    }

    public void setUrgencyScmAlgorithm(String algorithm) {
        assert (algorithm != null && algorithm.length() > 0) : "Parameter 'algorithm' of method 'setUrgencyScmAlgorithm' must not be empty";
        this.m_urgencyScmAlgorithm = algorithm;
    }

    public void setUrgencyScm30Algorithm(String algorithm) {
        assert (algorithm != null && algorithm.length() > 0) : "Parameter 'algorithm' of method 'setUrgencyScm30Algorithm' must not be empty";
        this.m_urgencyScm30Algorithm = algorithm;
    }

    public void setUrgencyScm90Algorithm(String algorithm) {
        assert (algorithm != null && algorithm.length() > 0) : "Parameter 'algorithm' of method 'setUrgencyScm90Algorithm' must not be empty";
        this.m_urgencyScm90Algorithm = algorithm;
    }

    public void setUrgencyScm365Algorithm(String algorithm) {
        assert (algorithm != null && algorithm.length() > 0) : "Parameter 'algorithm' of method 'setUrgencyScm365Algorithm' must not be empty";
        this.m_urgencyScm365Algorithm = algorithm;
    }
}

