/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.ranking;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.ranking.Rank;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;

public final class IssueRank
extends Rank<Issue> {
    private final float m_importanceSeverity;
    private final float m_importanceImpact;
    private final float m_importanceIssueCategory;
    private final float m_urgencySystemDiff;
    private final float m_urgencyEaseOfFix;
    private final float m_urgencyScm30;
    private final float m_urgencyScm90;
    private final float m_urgencyScm365;
    private final float m_urgencyScm;
    private String m_importanceImpactAlgorithm;
    private String m_urgencyIssueAlgorithm;
    private String m_urgencyScmAlgorithm;
    private String m_urgencyScm30Algorithm;
    private String m_urgencyScm90Algorithm;
    private String m_urgencyScm365Algorithm;

    public IssueRank(NamedElement parent, Issue scoredElement, float score, float importanceSeverity, float importanceIssueCategory, float importanceImpact, float importance, float urgencyEaseOfFix, float urgencySystemDiff, float urgencyScm30d, float urgencyScm90d, float urgencyScm365d, float urgencyScm, float urgency) {
        super(parent, scoredElement, score, importance, urgency);
        this.m_importanceSeverity = importanceSeverity;
        this.m_importanceIssueCategory = importanceIssueCategory;
        this.m_importanceImpact = importanceImpact;
        this.m_urgencyEaseOfFix = urgencyEaseOfFix;
        this.m_urgencySystemDiff = urgencySystemDiff;
        this.m_urgencyScm30 = urgencyScm30d;
        this.m_urgencyScm90 = urgencyScm90d;
        this.m_urgencyScm365 = urgencyScm365d;
        this.m_urgencyScm = urgencyScm;
    }

    @Override
    public String getFullyQualifiedNamePart() {
        Element rankedElement = ((Issue)this.getRankedElement()).getAffectedElement();
        if (rankedElement instanceof NamedElement) {
            return super.getFullyQualifiedNamePart() + DESCRIPTOR_NAME_PARTS_SEPARATOR + ((NamedElement)rankedElement).getFullyQualifiedName();
        }
        return super.getFullyQualifiedNamePart();
    }

    @Property
    public float getImportanceSeverity() {
        return this.m_importanceSeverity;
    }

    @Property
    public String getImportanceImpact() {
        return this.m_importanceImpactAlgorithm;
    }

    public float getImportanceImpactValue() {
        return this.m_importanceImpact;
    }

    @Property
    public float getImportanceIssueCategory() {
        return this.m_importanceIssueCategory;
    }

    public float getUrgencyEaseOfFixValue() {
        return this.m_urgencyEaseOfFix;
    }

    @Property
    public String getUrgencyEaseOfFix() {
        return this.m_urgencyIssueAlgorithm;
    }

    @Property
    public float getUrgencySystemDiff() {
        return this.m_urgencySystemDiff;
    }

    @Property
    public String getUrgencyScm30Days() {
        return this.m_urgencyScm30Algorithm;
    }

    public float getUrgencyScm30DaysValue() {
        return this.m_urgencyScm30;
    }

    @Property
    public String getUrgencyScm90Days() {
        return this.m_urgencyScm90Algorithm;
    }

    public float getUrgencyScm90DaysValue() {
        return this.m_urgencyScm90;
    }

    @Property
    public String getUrgencyScm365Days() {
        return this.m_urgencyScm365Algorithm;
    }

    public float getUrgencyScm365DaysValue() {
        return this.m_urgencyScm365;
    }

    @Property
    public String getUrgencyOverallScm() {
        return this.m_urgencyScmAlgorithm;
    }

    public float getUrgencyOverallScmValue() {
        return this.m_urgencyScm;
    }

    public void setImportanceImpactAlgorithm(String issueImportanceImpactAlgorithm) {
        assert (issueImportanceImpactAlgorithm != null) : "Parameter 'issueImportanceImpactAlgorithm' of method 'setImportanceImpactAlgorithm' must not be null";
        this.m_importanceImpactAlgorithm = issueImportanceImpactAlgorithm;
    }

    public void setUrgencyEaseOfFixAlgorithm(String urgencyEaseOfFixAlgorithm) {
        assert (urgencyEaseOfFixAlgorithm != null) : "Parameter 'urgencyEaseOfFixAlgorithm' of method 'setUrgencyEaseOfFixAlgorithm' must not be null";
        this.m_urgencyIssueAlgorithm = urgencyEaseOfFixAlgorithm;
    }

    public void setUrgencyScmAlgorithm(String urgencyScmAlgorithm) {
        assert (urgencyScmAlgorithm != null) : "Parameter 'urgencyScmAlgorithm' of method 'setUrgencyScmAlgorithm' must not be null";
        this.m_urgencyScmAlgorithm = urgencyScmAlgorithm;
    }

    public void setUrgencyScm30Algorithm(String urgencyScm30Algorithm) {
        assert (urgencyScm30Algorithm != null) : "Parameter 'urgencyScm30Algorithm' of method 'setUrgencyScm30Algorithm' must not be null";
        this.m_urgencyScm30Algorithm = urgencyScm30Algorithm;
    }

    public void setUrgencyScm90Algorithm(String urgencyScm90Algorithm) {
        assert (urgencyScm90Algorithm != null) : "Parameter 'urgencyScm90Algorithm' of method 'setUrgencyScm90Algorithm' must not be null";
        this.m_urgencyScm90Algorithm = urgencyScm90Algorithm;
    }

    public void setUrgencyScm365Algorithm(String urgencyScm365Algorithm) {
        assert (urgencyScm365Algorithm != null) : "Parameter 'urgencyScm365Algorithm' of method 'setUrgencyScm365Algorithm' must not be null";
        this.m_urgencyScm365Algorithm = urgencyScm365Algorithm;
    }

    @Override
    public String toString() {
        Issue scoredElement = (Issue)this.getRankedElement();
        StringBuilder builder = new StringBuilder(scoredElement.getId().getPresentationName());
        builder.append(" (").append(scoredElement.getAffectedElement().getShortName()).append(")");
        builder.append(", ").append(scoredElement.getDescription());
        builder.append(", rank=").append(NumberUtility.format((Number)Float.valueOf(this.getScoreValue())));
        builder.append(", calculated with: sqrt(importance\u00b2 + urgency\u00b2); ");
        builder.append("importance=").append(NumberUtility.format((Number)Float.valueOf(this.getImportanceValue()))).append(", ");
        builder.append("urgency=").append(NumberUtility.format((Number)Float.valueOf(this.getUrgencyValue())));
        builder.append("; importance = ");
        builder.append("severity [").append(NumberUtility.format((Number)Float.valueOf(this.getImportanceSeverity())));
        builder.append("] * type [").append(NumberUtility.format((Number)Float.valueOf(this.getImportanceIssueCategory())));
        builder.append("] * issue importance [").append(NumberUtility.format((Number)Float.valueOf(this.getImportanceImpactValue()))).append("]");
        return builder.toString();
    }
}

