/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.diff.resolution;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringType;
import com.hello2morrow.sonargraph.core.model.refactoring.StatusInfo;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.SystemDiffUtility;
import com.hello2morrow.sonargraph.core.model.system.diff.resolution.TaskDefinitionDiff;
import com.hello2morrow.sonargraph.integration.access.model.IRefactoring;

public abstract class RefactoringDefinitionDiff<B extends IRefactoring, C extends RefactoringDefinition>
extends TaskDefinitionDiff<B, C> {
    private final RefactoringType m_refactoringType;

    public RefactoringDefinitionDiff(NamedElement parent, RefactoringType type, B baseline, C current, IDiffElement.Change change) {
        super(parent, baseline, current, change);
        assert (type != null) : "Parameter 'type' of method 'RefactoringDefinitionDiff' must not be null";
        this.m_refactoringType = type;
    }

    public RefactoringDefinitionDiff(NamedElement parent, RefactoringType type, B baseline, C current, IDiffElement.Change change, String changeDetails) {
        super(parent, baseline, current, change, changeDetails);
        assert (type != null) : "Parameter 'type' of method 'RefactoringDefinitionDiff' must not be null";
        this.m_refactoringType = type;
    }

    @Override
    public abstract String getImageResourceName();

    public final RefactoringType getRefactoringType() {
        return this.m_refactoringType;
    }

    @Override
    public String getDefinition() {
        String information;
        String presentationName;
        if (this.getCurrent() != null) {
            presentationName = ((RefactoringDefinition)this.getCurrent()).getPresentationName(true);
            information = ((RefactoringDefinition)this.getCurrent()).getInformation();
        } else {
            presentationName = this.getRefactoringType().getPresentationName();
            information = ((IRefactoring)this.getBaseline()).getInformation();
        }
        String infoString = information != null && !information.isEmpty() ? " '" + information + "'" : "";
        String baselinePostFix = this.getCurrent() == null ? " [Baseline]" : "";
        return presentationName + infoString + baselinePostFix;
    }

    public StatusInfo.Status getStatus() {
        if (this.getCurrent() != null) {
            return ((RefactoringDefinition)this.getCurrent()).getStatus();
        }
        return SystemDiffUtility.convertBaselineRefactoringStatus(((IRefactoring)this.getBaseline()).getStatus());
    }
}

