/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.diff;

import com.hello2morrow.sonargraph.core.model.element.ISoftwareSystemDefinitionElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.IModifiablePathListener;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFile;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.foundation.utilities.Iso8601DateFormat;
import de.schlichtherle.truezip.file.TFile;
import java.util.Date;

public final class Baseline
extends ModifiableFile
implements ISoftwareSystemDefinitionElement {
    private final IInfoProvider m_infoProvider;
    private final String m_description;
    private final Date m_creationDate;

    public Baseline(NamedElement parent, TFile file, IModifiablePathListener listener, IInfoProvider infoProvider, Date creationDate, String description) {
        super(parent, file, listener);
        assert (infoProvider != null) : "Parameter 'infoProvider' of method 'Baseline' must not be null";
        assert (description != null) : "Parameter 'description' of method 'Baseline' must not be null";
        assert (creationDate != null) : "Parameter 'creationDate' of method 'Baseline' must not be null";
        this.m_infoProvider = infoProvider;
        this.m_description = description;
        this.m_creationDate = creationDate;
    }

    @Override
    public IFileType getFileType() {
        return CoreFileType.BASELINE;
    }

    @Override
    public String getImageResourceName() {
        return "Baseline";
    }

    @Override
    @Property
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public String getInformation() {
        return this.m_infoProvider.getInformation(this.getFile());
    }

    @Property
    public String creationDate() {
        return Iso8601DateFormat.formatDateAndTime((Date)this.m_creationDate);
    }

    public static interface IInfoProvider {
        public String getInformation(TFile var1);
    }
}

