/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.path.IExternalContainer;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.NamespaceFragment;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.LogicalModuleNamespaces;
import com.hello2morrow.sonargraph.core.model.system.LogicalSystemNamespaces;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class NamespaceUtility {
    private NamespaceUtility() {
    }

    private static LogicalNamespace getLogicalNamespace(LogicalNamespace.ISourceNamespace namespaceFragment, boolean inSystemScope) {
        assert (namespaceFragment != null) : "Parameter 'namespaceFragment' of method 'getLogicalNamespace' must not be null";
        if (inSystemScope) {
            return namespaceFragment.getSystemNamespace();
        }
        return namespaceFragment.getModuleNamespace();
    }

    public static LogicalProgrammingElement getLogicalProgrammingElement(ProgrammingElement programmingElement, boolean inSystemScope) {
        List<LogicalProgrammingElement> logicalProgrammingElementsPath;
        assert (programmingElement != null) : "Parameter 'programmingElement' of method 'getLogicalProgrammingElement' must not be null";
        LogicalNamespace.ISourceNamespace namespaceFragment = programmingElement.getParent(NamespaceFragment.class, new Class[0]);
        LogicalNamespace logicalNamespace = null;
        if (namespaceFragment != null) {
            logicalNamespace = NamespaceUtility.getLogicalNamespace(namespaceFragment, inSystemScope);
        } else {
            SoftwareSystem softwareSystem = programmingElement.getParent(SoftwareSystem.class, new Class[0]);
            Module module = programmingElement.getParent(Module.class, new Class[0]);
            logicalNamespace = inSystemScope ? (module != null ? softwareSystem.getUniqueExistingChild(LogicalSystemNamespaces.class).getInternalGlobalLogicalNamespace(programmingElement.getLanguage()) : softwareSystem.getUniqueExistingChild(LogicalSystemNamespaces.class).getExternalGlobalLogicalNamespace(programmingElement.getLanguage())) : (module != null ? softwareSystem.getUniqueExistingChild(LogicalModuleNamespaces.class).getInternalGlobalLogicalNamespace(module) : softwareSystem.getUniqueExistingChild(LogicalModuleNamespaces.class).getExternalGlobalLogicalNamespace(programmingElement.getLanguage(), programmingElement.getParent(IExternalContainer.class, new Class[0])));
        }
        if (logicalNamespace != null && !(logicalProgrammingElementsPath = logicalNamespace.getPath(programmingElement)).isEmpty()) {
            return logicalProgrammingElementsPath.get(logicalProgrammingElementsPath.size() - 1);
        }
        return null;
    }

    public static LogicalProgrammingElementInfo getLogicalProgrammingElementInfo(ProgrammingElement programmingElement, boolean inSystemScope) {
        List<LogicalProgrammingElement> logicalProgrammingElementsPath;
        assert (programmingElement != null) : "Parameter 'programmingElement' of method 'getLogicalProgrammingElement' must not be null";
        Language language = programmingElement.getLanguage();
        assert (language != null) : "Parameter 'language' of method 'getLogicalProgrammingElementInfo' must not be null";
        LogicalNamespace.ISourceNamespace namespaceFragment = programmingElement.getParent(LogicalNamespace.ISourceNamespace.class, new Class[0]);
        LogicalNamespace logicalNamespace = null;
        if (namespaceFragment != null) {
            logicalNamespace = NamespaceUtility.getLogicalNamespace(namespaceFragment, inSystemScope);
        } else {
            SoftwareSystem softwareSystem = programmingElement.getParent(SoftwareSystem.class, new Class[0]);
            Module module = programmingElement.getParent(Module.class, new Class[0]);
            if (inSystemScope) {
                logicalNamespace = module != null ? softwareSystem.getUniqueExistingChild(LogicalSystemNamespaces.class).getInternalGlobalLogicalNamespace(language) : softwareSystem.getUniqueExistingChild(LogicalSystemNamespaces.class).getExternalGlobalLogicalNamespace(language);
            } else if (module != null) {
                logicalNamespace = softwareSystem.getUniqueExistingChild(LogicalModuleNamespaces.class).getInternalGlobalLogicalNamespace(module);
            } else {
                IExternalContainer externalContainer = programmingElement.getParent(IExternalContainer.class, new Class[0]);
                logicalNamespace = softwareSystem.getUniqueExistingChild(LogicalModuleNamespaces.class).getExternalGlobalLogicalNamespace(language, externalContainer);
            }
        }
        if (logicalNamespace != null && !(logicalProgrammingElementsPath = logicalNamespace.getPath(programmingElement)).isEmpty()) {
            return new LogicalProgrammingElementInfo(logicalNamespace, logicalProgrammingElementsPath);
        }
        return null;
    }

    public static final class LogicalProgrammingElementInfo {
        private final LogicalNamespace m_logicalNamespace;
        private final List<LogicalProgrammingElement> m_logicalProgrammingElementsPath;

        LogicalProgrammingElementInfo(LogicalNamespace logicalNamespace, List<LogicalProgrammingElement> logicalProgrammingElementsPath) {
            assert (logicalNamespace != null) : "Parameter 'logicalNamespace' of method 'LogicalProgrammingElementInfo' must not be null";
            assert (logicalProgrammingElementsPath != null && !logicalProgrammingElementsPath.isEmpty()) : "Parameter 'logicalProgrammingElementsPath' of method 'LogicalProgrammingElementInfo' must not be empty";
            this.m_logicalNamespace = logicalNamespace;
            this.m_logicalProgrammingElementsPath = new ArrayList<LogicalProgrammingElement>(logicalProgrammingElementsPath);
        }

        public LogicalNamespace getLogicalNamespace() {
            return this.m_logicalNamespace;
        }

        public List<LogicalProgrammingElement> getLogicalProgrammingElementsPath() {
            return Collections.unmodifiableList(this.m_logicalProgrammingElementsPath);
        }

        public LogicalProgrammingElement getLeafLogicalProgrammingElement() {
            return this.m_logicalProgrammingElementsPath.get(this.m_logicalProgrammingElementsPath.size() - 1);
        }
    }
}

