/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.script;

import com.hello2morrow.sonargraph.core.model.common.AutoCompletionProposal;
import java.util.Objects;

public final class ScriptAutoCompletionProposal
extends AutoCompletionProposal {
    private final Type m_type;

    public ScriptAutoCompletionProposal(String presentationProposal, String proposal, int replacementOffset, int replacementLength, int offsetIncrement, Type type) {
        super(presentationProposal, proposal, replacementOffset, replacementLength, offsetIncrement);
        assert (type != null) : "Parameter 'type' of method 'ArchitectureAutoCompletionProposal' must not be null";
        this.m_type = type;
    }

    @Override
    public String getImageResourceName() {
        switch (this.m_type) {
            case VARIABLE: {
                return "Variable";
            }
            case FIELD: {
                return "FieldPublic";
            }
            case METHOD: {
                return "MethodPublic";
            }
        }
        assert (false) : "Unhandled type: " + String.valueOf((Object)this.m_type);
        return "";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(new Object[]{this.m_type});
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        ScriptAutoCompletionProposal other = (ScriptAutoCompletionProposal)obj;
        return this.m_type == other.m_type;
    }

    @Override
    public String toString() {
        return super.toString() + " <" + String.valueOf((Object)this.m_type) + ">";
    }

    public static enum Type {
        VARIABLE,
        FIELD,
        METHOD;

    }
}

