/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.script;

import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class ParameterType
extends Enum<ParameterType>
implements IStandardEnumeration {
    public static final /* enum */ ParameterType BOOLEAN = new ParameterType(Boolean.FALSE, Boolean.TRUE, Boolean.FALSE);
    public static final /* enum */ ParameterType STRING = new ParameterType("", new Object[0]);
    public static final /* enum */ ParameterType INTEGER = new ParameterType(0, new Object[0]);
    private final Object m_defaultValue;
    private final Set<Object> m_possibleValues;
    private static final /* synthetic */ ParameterType[] ENUM$VALUES;

    static {
        ENUM$VALUES = new ParameterType[]{BOOLEAN, STRING, INTEGER};
    }

    private ParameterType(Object defaultValue, Object ... possibleValues) {
        assert (defaultValue != null) : "Parameter 'defaultValue' of method 'ParameterType' must not be null";
        this.m_defaultValue = defaultValue;
        if (possibleValues.length == 0) {
            this.m_possibleValues = Collections.emptySet();
        } else {
            this.m_possibleValues = new LinkedHashSet<Object>(possibleValues.length);
            Object[] objectArray = possibleValues;
            int n2 = possibleValues.length;
            int n3 = 0;
            while (n3 < n2) {
                Object next = objectArray[n3];
                boolean added = this.m_possibleValues.add(next);
                assert (added) : "Already added: " + String.valueOf(next);
                ++n3;
            }
        }
    }

    public Object getDefaultValue() {
        return this.m_defaultValue;
    }

    public Set<Object> getPossibleValues() {
        return this.m_possibleValues;
    }

    public List<String> splitPossibleValues(String input) {
        assert (input != null) : "Parameter 'input' of method 'splitPossibleValues' must not be null";
        return StringUtility.splitAndTrim((String)input, (String)" ");
    }

    public String getPossibleValuesAsString() {
        if (this.m_possibleValues.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object next : this.m_possibleValues) {
            sb.append(next.toString());
            sb.append(" ");
        }
        sb.delete(sb.length() - " ".length(), sb.length());
        sb.trimToSize();
        return sb.toString();
    }

    public boolean isConversionIntoTargetTypePossible(String value) {
        assert (value != null) : "Parameter 'value' of method 'checkValue' must not be null";
        switch (this) {
            case BOOLEAN: {
                value = value.toLowerCase();
                return "true".equals(value) || "false".equals(value);
            }
            case INTEGER: {
                try {
                    Integer.parseInt(value);
                    return true;
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
            }
        }
        return true;
    }

    public Object convertIntoTargetType(String value) {
        assert (value != null) : "Parameter 'value' of method 'checkValue' must not be null";
        switch (this) {
            case BOOLEAN: {
                value = value.toLowerCase();
                if ("true".equals(value) || "false".equals(value)) {
                    return Boolean.valueOf(value);
                }
                return null;
            }
            case INTEGER: {
                try {
                    Integer integer = Integer.valueOf(value);
                    return integer;
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
            case STRING: {
                return value;
            }
        }
        return null;
    }

    public String getStandardName() {
        return StringUtility.convertConstantNameToStandardName((String)this.name());
    }

    public String getPresentationName() {
        return StringUtility.convertConstantNameToPresentationName((String)this.name());
    }

    public static ParameterType fromStandardName(String standardName) throws IllegalArgumentException {
        assert (standardName != null) : "'standardName' must not be null";
        assert (standardName.length() > 0) : "'standardName' must not be empty";
        String name = StringUtility.convertStandardNameToConstantName((String)standardName);
        return ParameterType.valueOf(name);
    }

    public static ParameterType[] values() {
        ParameterType[] parameterTypeArray = ENUM$VALUES;
        int n = parameterTypeArray.length;
        ParameterType[] parameterTypeArray2 = new ParameterType[n];
        System.arraycopy(ENUM$VALUES, 0, parameterTypeArray2, 0, n);
        return parameterTypeArray2;
    }

    public static ParameterType valueOf(String string) {
        return Enum.valueOf(ParameterType.class, string);
    }
}

