/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.script;

import com.hello2morrow.sonargraph.core.model.script.ParameterDefinition;
import com.hello2morrow.sonargraph.core.model.script.ParameterType;

public final class IntegerParameterDefinition
extends ParameterDefinition<Integer> {
    public IntegerParameterDefinition(Builder builder) {
        super(builder);
    }

    @Override
    public Class<?> getParameterClass() {
        return Integer.class;
    }

    @Override
    public ParameterType getType() {
        return ParameterType.INTEGER;
    }

    @Override
    public Integer parse(String value) {
        return Parser.parse(value);
    }

    public static final class Builder
    extends ParameterDefinition.Builder<Integer> {
        public Builder(String name) {
            super(name, (Integer)ParameterType.INTEGER.getDefaultValue());
        }

        public IntegerParameterDefinition build() {
            return new IntegerParameterDefinition(this);
        }

        @Override
        protected Integer parse(String value) {
            assert (value != null) : "Parameter 'value' of method 'parse' must not be null";
            return Parser.parse(value);
        }
    }

    public static class Parser {
        public static Integer parse(String value) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                return 0;
            }
        }
    }
}

