/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.representation;

import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.core.model.representation.FocusMode;
import com.hello2morrow.sonargraph.core.model.representation.NodeAndEdgeRepresentation;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationElementGroup;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationViewData;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public class RepresentationNavigationStateWrapper {
    private final INavigationState m_navigationState;
    private final Collection<NamedElement> m_mainPathElements;
    private final Collection<NamedElement> m_additionalElements;
    private final Collection<NamedElement> m_originalInput;
    private final Collection<NamedElement> m_selection;
    private final Collection<Pair<NamedElement, NamedElement>> m_endPointSelection;
    private final Set<CoreParserDependencyType> m_dependencyTypesForEdges;
    private final FocusMode m_focusMode;
    private final PresentationMode m_presentationMode;
    private final EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> m_properties;
    private final double m_zoomLevel;

    public static final boolean isProcessable(INavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'isProcessable' must not be null";
        return state.hasConstant(RepresentationViewData.FOCUS_MODE);
    }

    public RepresentationNavigationStateWrapper(INavigationState state, IElementResolver elementResolver) {
        assert (state != null) : "Parameter 'state' of method 'InternalDrawableSlaveViewState' must not be null";
        this.m_mainPathElements = state.getElements(RepresentationElementGroup.MAIN_NODES, NamedElement.class, elementResolver);
        this.m_additionalElements = state.getElements(RepresentationElementGroup.ADDITIONAL_ELEMENTS, NamedElement.class, elementResolver);
        this.m_originalInput = state.getElements(RepresentationElementGroup.ORIGINAL_INPUT, NamedElement.class, elementResolver);
        this.m_focusMode = state.hasConstant(RepresentationViewData.FOCUS_MODE) ? (FocusMode)((Object)state.getConstant(RepresentationViewData.FOCUS_MODE)) : FocusMode.IN_AND_OUT;
        Set constants = state.getConstants(RepresentationViewData.PROPERTIES);
        this.m_properties = constants.isEmpty() ? EnumSet.noneOf(NodeAndEdgeRepresentation.RepresentationProperty.class) : EnumSet.copyOf(constants);
        this.m_presentationMode = state.hasConstant(RepresentationViewData.PRESENTATION_MODE) ? (PresentationMode)((Object)state.getConstant(RepresentationViewData.PRESENTATION_MODE)) : PresentationMode.MIXED;
        this.m_dependencyTypesForEdges = new HashSet(state.getConstants(RepresentationViewData.DEPENDENCY_TYPES_FOR_EDGES));
        this.m_selection = state.getElements(RepresentationElementGroup.SELECTION, NamedElement.class, elementResolver);
        this.m_endPointSelection = state.getDependenciesEndpoints(RepresentationElementGroup.ENDPOINTS_SELECTION, elementResolver);
        Double zoomLevel = state.getDouble(RepresentationViewData.ZOOM_LEVEL);
        this.m_zoomLevel = zoomLevel != null ? zoomLevel : 1.0;
        this.m_navigationState = state;
    }

    public final Collection<NamedElement> getMainNodes() {
        return this.m_mainPathElements;
    }

    public final Collection<NamedElement> getAdditionalElements() {
        return this.m_additionalElements;
    }

    public final Collection<NamedElement> getOriginalInput() {
        return this.m_originalInput;
    }

    public final Set<CoreParserDependencyType> getDependencyTypesForEdges() {
        return this.m_dependencyTypesForEdges;
    }

    public final FocusMode getFocusMode() {
        return this.m_focusMode;
    }

    public final PresentationMode getPresentationMode() {
        return this.m_presentationMode;
    }

    public final EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> getProperties() {
        return this.m_properties;
    }

    public final Collection<NamedElement> getSelection() {
        return this.m_selection;
    }

    public final Collection<Pair<NamedElement, NamedElement>> getEndPointSelection() {
        return this.m_endPointSelection;
    }

    public final double getZoomLevel() {
        return this.m_zoomLevel;
    }

    protected final INavigationState getINavigationState() {
        return this.m_navigationState;
    }
}

