/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.path.scm;

import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.path.scm.CouplingLink;
import com.hello2morrow.sonargraph.core.model.path.scm.ISourceNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SourceNode
implements ISourceNode {
    private final List<CouplingLink> m_links = new ArrayList<CouplingLink>();
    private SourceFile m_source;
    private int m_id;

    public SourceNode() {
    }

    public SourceNode(SourceFile source, int id) {
        assert (source != null) : "Parameter 'source' of method 'SourceNode' must not be null";
        this.m_source = source;
        this.m_id = id;
    }

    @Override
    public SourceFile getSourceFile() {
        return this.m_source;
    }

    public void addLink(CouplingLink link) {
        this.m_links.add(link);
    }

    @Override
    public int getId() {
        return this.m_id;
    }

    public int getLinkCount() {
        return this.m_links.size();
    }

    public List<CouplingLink> getLinks() {
        return Collections.unmodifiableList(this.m_links);
    }

    public String toString() {
        return this.m_source.getIdentifyingPath() + ":" + this.m_id + "(" + this.m_links.size() + " links)";
    }
}

