/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.metrics;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IValueList;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.IValueListWithValue;
import com.hello2morrow.sonargraph.core.model.metrics.IntValue;
import com.hello2morrow.sonargraph.core.model.metrics.ValueList;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectReader;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectWriter;
import com.hello2morrow.sonargraph.foundation.persistence.IPersistable;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import java.io.IOException;
import java.util.function.IntBinaryOperator;

public final class IntegerValueList
extends ValueList
implements IValueListWithValue {
    private static final String VALUE = "value";
    private static final String ROOT_ELEMENT = "rootElement";
    private static final IntBinaryOperator DEFAULT_OP = (a, b) -> a + b;
    private NamedElement m_rootElement;
    private Integer m_value;
    private final IntBinaryOperator m_op;

    public IntegerValueList(NamedElement parent) {
        super(parent);
        this.m_op = DEFAULT_OP;
    }

    @Override
    public void writeAttributes(IObjectWriter writer) throws IOException {
        super.writeAttributes(writer);
        writer.writeObjectReference(ROOT_ELEMENT, (IPersistable)this.m_rootElement);
        if (this.m_value != null) {
            writer.writeInt(VALUE, this.m_value.intValue());
        }
    }

    @Override
    public void readAttributes(IObjectReader reader) throws IOException, RestoreException {
        super.readAttributes(reader);
        reader.readObjectReference(ROOT_ELEMENT, NamedElement.class, e -> {
            NamedElement namedElement = this.m_rootElement = e;
        });
        this.m_value = reader.readInt(VALUE);
    }

    public IntegerValueList(NamedElement parent, IMetricDescriptor metricDescriptor, NamedElement rootElement, boolean initializeWithZero, IntBinaryOperator op) {
        super(parent, metricDescriptor);
        assert (rootElement != null) : "Parameter 'rootElement' of method 'IntegerValueList' must not be null";
        this.m_rootElement = rootElement;
        this.m_op = op;
        if (initializeWithZero) {
            this.m_value = 0;
        }
    }

    public IntegerValueList(NamedElement parent, IMetricDescriptor metricDescriptor, NamedElement rootElement, boolean initializeWithZero) {
        this(parent, metricDescriptor, rootElement, initializeWithZero, DEFAULT_OP);
    }

    public IntegerValueList(NamedElement parent, IMetricDescriptor metricDescriptor, NamedElement rootElement) {
        this(parent, metricDescriptor, rootElement, false);
    }

    @Override
    public NamedElement getAssociatedElement() {
        return this.m_rootElement;
    }

    @Override
    public boolean isValid() {
        return this.m_value != null && this.m_rootElement.isValid() && super.isValid();
    }

    @Override
    public Number getValue() {
        return this.m_value;
    }

    @Override
    public IMetricDescriptor getMetricDescriptor() {
        IValueList parent = this.getParent(IValueList.class, new Class[0]);
        return parent != null ? parent.getListItemMetricDescriptor() : null;
    }

    @Override
    public void addValue(NamedElement element, Number value) {
        assert (element != null) : "Parameter 'element' of method 'addValue' must not be null";
        assert (value != null) : "Parameter 'value' of method 'addValue' must not be null";
        IntValue val = new IntValue(this, element, value.intValue());
        this.addChild(val);
        this.m_value = this.m_value == null ? Integer.valueOf(value.intValue()) : Integer.valueOf(this.m_op.applyAsInt(this.m_value, value.intValue()));
    }

    @Override
    public String getImageResourceName() {
        return this.m_rootElement.getImageResourceName();
    }
}

