/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.metrics;

import com.hello2morrow.sonargraph.core.model.analysis.IMetric;
import com.hello2morrow.sonargraph.core.model.analysis.IValueList;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.metrics.AbstractMetric;
import com.hello2morrow.sonargraph.core.model.metrics.IValueListWithValue;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;

public abstract class AggregatedMetric
extends AbstractMetric {
    private final AbstractMetric m_baseMetric;
    private final boolean m_recursive;

    public AggregatedMetric(NamedElement parent, IMetricLevel level, AbstractMetric baseMetric, boolean recursive) {
        super(parent, baseMetric.getMetricId(), level);
        this.m_baseMetric = baseMetric;
        this.m_recursive = recursive;
    }

    protected final IMetric getBaseMetric() {
        return this.m_baseMetric;
    }

    protected abstract IValueListWithValue createAggregator(NamedElement var1, NamedElement var2);

    @Override
    protected final NamedElementVisitor createCollector(IWorkerContext workerContext, IValueList collectionRoot) {
        return new ValueCollector(workerContext, this.getLevel(), collectionRoot.getElement());
    }

    private class ValueCollector
    extends NamedElementVisitor
    implements External.IVisitor {
        private final IWorkerContext m_workerContext;
        private final NamedElement m_collectionRoot;
        private final IMetricLevel m_level;

        private ValueCollector(IWorkerContext workerContext, IMetricLevel level, NamedElement collectionRoot) {
            this.m_workerContext = workerContext;
            this.m_collectionRoot = collectionRoot;
            this.m_level = level;
        }

        @Override
        public void visitNamedElement(NamedElement element) {
            assert (element != null) : "Parameter 'element' of method 'visitNamedElement' must not be null";
            if (!element.isExcluded()) {
                boolean countAsWorkItem = true;
                if (!element.getRefactoringState().hasBeenDeleted()) {
                    if (this.m_level.getAssociatedClass().isAssignableFrom(element.getClass())) {
                        IValueListWithValue aggregator = AggregatedMetric.this.createAggregator(this.m_collectionRoot, element);
                        AggregatedMetric.this.m_baseMetric.internalCollect(this.m_workerContext, element, aggregator);
                        this.m_collectionRoot.addChild(aggregator.getElement());
                        countAsWorkItem = false;
                        if (AggregatedMetric.this.m_recursive && !this.m_workerContext.hasBeenCanceled()) {
                            this.visitChildrenOf(element);
                        }
                    } else {
                        this.visitChildrenOf(element);
                    }
                }
                if (element instanceof IComponent && countAsWorkItem) {
                    this.m_workerContext.workItemCompleted();
                }
            }
        }

        @Override
        public void visitExternal(External element) {
        }
    }
}

