/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.metrics;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IHasMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetric;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValueContainer;
import com.hello2morrow.sonargraph.core.model.analysis.IValueList;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.Collection;
import java.util.stream.Collectors;

public abstract class AbstractMetric
extends NamedElement
implements IMetric,
IHasMetricDescriptor {
    private final IMetricId m_id;
    private final IMetricLevel m_level;

    protected AbstractMetric(NamedElement parent, IMetricId id, IMetricLevel level) {
        super(parent);
        assert (id != null) : "Parameter 'id' of method 'AbstractMetric' must not be null";
        assert (level != null) : "Parameter 'level' of method 'AbstractMetric' must not be null";
        this.m_id = id;
        this.m_level = level;
    }

    @Override
    public final NamedElement getNamedElement() {
        return this;
    }

    @Override
    public final String getFullyQualifiedNamePart() {
        return Integer.toString(this.hashCode());
    }

    @Override
    public final IMetricLevel getLevel() {
        return this.m_level;
    }

    @Override
    public final IMetricId getMetricId() {
        return this.m_id;
    }

    @Override
    public final String getShortName() {
        return this.m_id.getPresentationName();
    }

    @Override
    public final String getDescription() {
        return this.m_id.getDescription();
    }

    @Property
    public final String getCategories() {
        return StringUtility.concat((Collection)this.m_id.getCategories().stream().map(c -> c.getPresentationName()).collect(Collectors.toList()), (String)", ");
    }

    @Override
    public final String getImageResourceName() {
        return "Metric";
    }

    @Override
    public final IMetricDescriptor getMetricDescriptor() {
        return this;
    }

    @Override
    public final String getName() {
        return String.format("%s (%s)", this.m_id.getPresentationName(), this.getLevel().getPresentationName());
    }

    @Override
    public final IAnalyzerId getProvidingAnalyzerId() {
        return this.getLevel() == CoreMetricLevel.SYSTEM ? CoreAnalyzerId.SIZE_METRICS : null;
    }

    @Override
    public final Language getLanguage() {
        MetricProvider provider = this.getParent(MetricProvider.class, new Class[0]);
        assert (provider != null) : "'provider' of method 'getLanguage' must not be null";
        return provider.getLanguage();
    }

    @Override
    public final boolean isFloat() {
        return this.m_id.isFloat();
    }

    protected abstract NamedElementVisitor createCollector(IWorkerContext var1, IValueList var2);

    final void internalCollect(IWorkerContext workerContext, NamedElement root, IValueList collectionRoot) {
        assert (root != null) : "Parameter 'root' of method 'internalCollect' must not be null";
        root.accept(this.createCollector(workerContext, collectionRoot));
    }

    protected final IValueList collect(IWorkerContext workerContext, NamedElement root, IValueList collectionRoot) {
        assert (workerContext != null) : "'mapper' must not be null";
        assert (root != null) : "'root' must not be null";
        assert (collectionRoot != null) : "'collection' must not be null";
        WorkerContextInitializer initializer = new WorkerContextInitializer(workerContext);
        workerContext.setNumberOfSteps(1);
        root.accept(initializer);
        this.internalCollect(workerContext, root, collectionRoot);
        workerContext.endStep();
        return collectionRoot;
    }

    @Override
    public final void processValues(NamedElement root, IMetricValueContainer.IMetricValueProcessor proc) {
        this.collectValues((IWorkerContext)DefaultWorkerContext.INSTANCE, root).processValues(root, proc);
    }

    @Override
    public final IMetricDescriptor getValueMetricDescriptor() {
        return this;
    }

    private final class WorkerContextInitializer
    extends NamedElementVisitor
    implements SoftwareSystem.IVisitor,
    Module.IVisitor,
    External.IVisitor {
        private final IWorkerContext m_workerContext;

        private WorkerContextInitializer(IWorkerContext workerContext) {
            this.m_workerContext = workerContext;
        }

        @Override
        public void visitModule(Module element) {
            this.m_workerContext.beginBlockOfWork(element.getNumberOfComponents());
        }

        @Override
        public void visitSoftwareSystem(SoftwareSystem element) {
            this.m_workerContext.beginBlockOfWork(element.getNumberOfComponents());
        }

        @Override
        public void visitNamedElement(NamedElement element) {
            if (element instanceof IComponent) {
                this.m_workerContext.beginBlockOfWork(1);
            } else {
                int numberOfComponents = element.getChildrenRecursively(IComponent.class, ProgrammingElement.class).size();
                if (numberOfComponents > 0) {
                    this.m_workerContext.beginBlockOfWork(numberOfComponents);
                }
            }
        }

        @Override
        public void visitExternal(External element) {
        }
    }
}

