/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.history;

import com.hello2morrow.sonargraph.core.foundation.common.history.HistoryTable;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.history.IUndoRedoEntry;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import java.util.Collection;
import java.util.EnumSet;

public final class GlobalHistory
extends HistoryTable<Entry> {
    public String toString() {
        return String.format("GlobalHistoryTable [size=%d, undo size=%d, redo size=%d]", this.getSize(), this.getUndoEntriesSize(), this.getRedoEntriesSize());
    }

    public int getNumberOfStoredTransactions() {
        long currentTransactionId = Long.MIN_VALUE;
        int numberOfTransactions = 0;
        for (Entry nextEntry : this.getEntries()) {
            if (nextEntry.getTransactionId() != currentTransactionId) {
                ++numberOfTransactions;
            }
            currentTransactionId = nextEntry.getTransactionId();
        }
        return numberOfTransactions;
    }

    public void removeTransactions(Collection<Long> transactionIds) {
        assert (transactionIds != null) : "Parameter 'transactionIds' of method 'removeTransactions' must not be null";
        if (transactionIds.size() == 0) {
            return;
        }
        for (Entry next : this.getEntries()) {
            if (!transactionIds.contains(next.getTransactionId())) continue;
            this.removeEntry(next);
        }
    }

    public static final class Entry
    implements HistoryTable.ITableEntry,
    IUndoRedoEntry {
        private final String m_fileId;
        private final String m_path;
        private final String m_identifyingPath;
        private final String m_commandName;
        private final Class<? extends IModifiableFile> m_clazz;
        private final long m_transactionId;
        private final EnumSet<Modification> m_modifications;
        private INavigationState m_navigationState;

        public Entry(IModifiableFile file, String commandName, long transactionId, EnumSet<Modification> modifications) {
            assert (file != null) : "Parameter 'file' of method 'Entry' must not be null";
            assert (commandName != null && commandName.length() > 0) : "Parameter 'commandName' of method 'Entry' must not be empty";
            assert (modifications != null) : "Parameter 'modifications' of method 'Entry' must not be null";
            this.m_fileId = file.getFileId();
            this.m_identifyingPath = file.getIdentifyingPath();
            this.m_path = file.getAbsolutePath();
            this.m_clazz = file.getClass();
            this.m_commandName = commandName;
            this.m_transactionId = transactionId;
            this.m_modifications = modifications;
        }

        private Entry(String fileId, String identifyingPath, String path, Class<? extends IModifiableFile> clazz, String commandName, long transactionId, EnumSet<Modification> modifications) {
            this.m_fileId = fileId;
            this.m_identifyingPath = identifyingPath;
            this.m_path = path;
            this.m_clazz = clazz;
            this.m_commandName = commandName;
            this.m_transactionId = transactionId;
            this.m_modifications = modifications;
        }

        public String getFileId() {
            return this.m_fileId;
        }

        public String getPath() {
            return this.m_path;
        }

        @Override
        public String getIdentifyingPath() {
            return this.m_identifyingPath;
        }

        @Override
        public String getCommandName() {
            return this.m_commandName;
        }

        @Override
        public Class<? extends IModifiableFile> getClazz() {
            return this.m_clazz;
        }

        @Override
        public long getTransactionId() {
            return this.m_transactionId;
        }

        public EnumSet<Modification> getModifications() {
            return EnumSet.copyOf(this.m_modifications);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Entry [m_transactionId=");
            builder.append(this.m_transactionId);
            builder.append(", m_commandName=");
            builder.append(this.m_commandName);
            builder.append(", m_name=");
            builder.append(this.m_identifyingPath);
            builder.append(", m_path=");
            builder.append(this.m_path);
            builder.append(", m_fileId=");
            builder.append(this.m_fileId);
            builder.append(", m_clazz=");
            builder.append(this.m_clazz);
            builder.append(", m_modifications=");
            builder.append(this.m_modifications);
            builder.append("]");
            return builder.toString();
        }

        public Entry copy() {
            return new Entry(this.m_fileId, this.m_identifyingPath, this.m_path, this.m_clazz, this.m_commandName, this.m_transactionId, EnumSet.copyOf(this.m_modifications));
        }

        public void setNavigationState(INavigationState navigationState) {
            this.m_navigationState = navigationState;
        }

        public INavigationState getNavigationState() {
            return this.m_navigationState;
        }
    }
}

