/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.graphview;

import com.hello2morrow.sonargraph.core.model.dependenciesview.DependenciesViewDependencyAdapter;
import com.hello2morrow.sonargraph.core.model.element.IDependency;
import com.hello2morrow.sonargraph.core.model.element.ImageDecoratorInfo;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewElement;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewNode;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class GraphViewNodeWithUnderlyingElement
extends GraphViewNode {
    private final NamedElement m_underlying;

    public GraphViewNodeWithUnderlyingElement(GraphViewElement parent, int level, NamedElement underlying) {
        super(parent, level);
        assert (underlying != null) : "Parameter 'underlying' of method 'GraphViewNonCyclicNode' must not be null";
        this.m_underlying = underlying;
    }

    @Override
    public final NamedElement getNamedElement() {
        return this.m_underlying;
    }

    @Override
    public final String getShortName() {
        return this.m_underlying.getShortName();
    }

    @Override
    public String getName() {
        return this.m_underlying.getName();
    }

    @Override
    public final NamedElement getUnderlyingObject() {
        return this.getNamedElement();
    }

    @Override
    public List<NamedElement> getAdaptedTo() {
        return Collections.singletonList(this.m_underlying);
    }

    @Override
    public final String getPresentationKind() {
        return this.m_underlying.getPresentationKind();
    }

    @Override
    public final String getImageResourceName() {
        return this.m_underlying.getImageResourceName();
    }

    @Override
    public final ImageDecoratorInfo getImageResourceDecoratorInfo() {
        return this.m_underlying.getImageResourceDecoratorInfo();
    }

    @Override
    public final boolean isExpandable() {
        return false;
    }

    @Override
    protected final List<IDependency> getDependencyAdapters(GraphViewNode to) {
        assert (to != null) : "Parameter 'to' of method 'getDependencyAdapters' must not be null";
        GraphViewNode.GraphViewDependency out = this.getOutgoingDependency(to);
        return out == null ? Collections.emptyList() : Collections.singletonList(new DependenciesViewDependencyAdapter(this.m_underlying, (NamedElement)out.getTo().getUnderlyingObject(), new ArrayList<ParserDependency>(out.getParserDependencies())));
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitGraphNodeWithUnderlyingElement(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitGraphNodeWithUnderlyingElement(GraphViewNodeWithUnderlyingElement var1);
    }
}

