/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableToArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ComponentStructureNode;
import com.hello2morrow.sonargraph.core.model.explorationview.IPhysicalLazyExpandableNode;
import com.hello2morrow.sonargraph.core.model.explorationview.IProvidesLinesOfCode;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;

public final class ComponentNode
extends AssignableToArtifactNode
implements IPhysicalLazyExpandableNode,
IProvidesLinesOfCode {
    public ComponentNode(ArchitecturalViewElement parent, PresentationMode presentationMode, boolean isReadOnly, IComponent component) {
        super(parent, presentationMode, isReadOnly, component);
    }

    public void addUnderlyingElement(IComponent component) {
        assert (component != null) : "Parameter 'component' of method 'addUnderlyingElement' must not be null";
        super.addUnderlyingElement(component.getNamedElement());
    }

    @Override
    public final ArchitecturalViewNode getArchitecturalViewNode() {
        return this;
    }

    @Override
    public int getLinesOfCode() {
        int loc;
        if (this.isExternal()) {
            return -1;
        }
        int linesOfCode = 0;
        for (ComponentStructureNode componentStructureNode : this.getChildren(ComponentStructureNode.class)) {
            loc = componentStructureNode.getLinesOfCode();
            if (loc == -1) continue;
            linesOfCode += loc;
        }
        for (NamedElement namedElement : this.getUnderlyingElements()) {
            if (!(namedElement instanceof SourceFile) || (loc = ((SourceFile)namedElement).getLinesOfCode()) == -1) continue;
            linesOfCode += loc;
        }
        return linesOfCode;
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitComponentNode(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitComponentNode(ComponentNode var1);
    }
}

