/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.author;

import com.hello2morrow.sonargraph.core.model.author.Author;
import gnu.trove.set.hash.THashSet;
import java.util.Collections;
import java.util.Set;

public final class AuthorsInfo {
    private final Author[] m_authors30;
    private final Author[] m_authors90;
    private final Author[] m_authors365;
    private final Author[] m_authors2y;
    private final Author[] m_authors5y;

    public AuthorsInfo(Author[] authors30, Author[] authors90, Author[] authors365, Author[] authors2y, Author[] authors5y) {
        assert (authors30 != null) : "Parameter 'authors30' of method 'AuthorsInfo' must not be null";
        assert (authors90 != null) : "Parameter 'authors90' of method 'AuthorsInfo' must not be null";
        assert (authors365 != null) : "Parameter 'authors365' of method 'AuthorsInfo' must not be null";
        this.m_authors30 = authors30;
        this.m_authors90 = authors90;
        this.m_authors365 = authors365;
        this.m_authors2y = authors2y;
        this.m_authors5y = authors5y;
    }

    public Author[] getAuthors30() {
        return this.m_authors30;
    }

    public Author[] getAuthors90() {
        return this.m_authors90;
    }

    public Author[] getAuthors365() {
        return this.m_authors365;
    }

    public Author[] getAuthors2y() {
        return this.m_authors2y;
    }

    public Author[] getAuthors5y() {
        return this.m_authors5y;
    }

    public static String getAuthorsAsString(Author[] authors) {
        if (authors == null || authors.length == 0) {
            return "";
        }
        if (authors.length == 1) {
            return authors[0].getName();
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < authors.length) {
            result.append(authors[i].getName());
            if (i < authors.length - 1) {
                result.append(", ");
            }
            ++i;
        }
        return result.toString();
    }

    public static Set<Author> convertArrayToSet(Author[] authors) {
        if (authors == null || authors.length == 0) {
            return Collections.emptySet();
        }
        if (authors.length == 1) {
            return Collections.singleton(authors[0]);
        }
        THashSet result = new THashSet(authors.length);
        int i = 0;
        while (i < authors.length) {
            result.add(authors[i]);
            ++i;
        }
        return result;
    }

    public static Set<String> convertArrayToSetOfStrings(Author[] authors) {
        if (authors == null || authors.length == 0) {
            return Collections.emptySet();
        }
        THashSet result = new THashSet(authors.length);
        int i = 0;
        while (i < authors.length) {
            result.add(authors[i].getName());
            ++i;
        }
        return result;
    }
}

