/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecture;

import com.hello2morrow.sonargraph.core.model.architecture.IAssignableAttributeRetriever;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableAttributeRetrieverProvider;
import com.hello2morrow.sonargraph.foundation.utilities.CustomPattern;
import java.util.regex.PatternSyntaxException;

public final class ParsedPatternInfo {
    private final String m_originalPattern;
    private final boolean m_isStrong;
    private final boolean m_isOptional;
    private String m_pattern;
    private IAssignableAttributeRetriever m_retriever;
    private String[] m_params;
    private String m_errorMessage;
    private CustomPattern m_compiledPattern;

    private ParsedPatternInfo(String originalPattern, boolean isStrong, boolean isOptional) {
        assert (originalPattern != null) : "Parameter 'originalPattern' of method 'ParsedPatternInfo' must not be null";
        this.m_originalPattern = originalPattern;
        this.m_isStrong = isStrong;
        this.m_isOptional = isOptional;
    }

    public boolean isValid() {
        return this.m_errorMessage == null;
    }

    public String getOriginalPattern() {
        return this.m_originalPattern;
    }

    public boolean isStrong() {
        return this.m_isStrong;
    }

    public boolean isOptional() {
        return this.m_isOptional;
    }

    public void setErrorMessage(String msg) {
        assert (msg != null && msg.length() > 0) : "Parameter 'msg' of method 'setErrorMessage' must not be empty";
        this.m_errorMessage = msg;
    }

    public String getErrorMessage() {
        return this.m_errorMessage;
    }

    public void setRetriever(IAssignableAttributeRetriever retriever) {
        assert (retriever != null) : "Parameter 'retriever' of method 'setRetriever' must not be null";
        this.m_retriever = retriever;
    }

    public IAssignableAttributeRetriever getRetriever() {
        return this.m_retriever;
    }

    public void setPattern(String pattern) {
        this.m_pattern = pattern;
    }

    public String getPattern() {
        return this.m_pattern;
    }

    public void setParams(String[] params) {
        this.m_params = params;
    }

    public String[] getParams() {
        return this.m_params;
    }

    public CustomPattern getCompiledPattern() {
        return this.m_compiledPattern;
    }

    public void setCompiledPattern(CustomPattern compiledPattern) {
        this.m_compiledPattern = compiledPattern;
    }

    public static ParsedPatternInfo parsePattern(String originalPattern, boolean isStrong, boolean isOptional, IAssignableAttributeRetrieverProvider provider) {
        assert (originalPattern != null) : "Parameter 'originalPattern' of method 'parsePattern' must not be null";
        assert (provider != null) : "Parameter 'provider' of method 'parsePattern' must not be null";
        ParsedPatternInfo info = new ParsedPatternInfo(originalPattern, isStrong, isOptional);
        String[] parts = originalPattern.split(": ");
        String pattern = parts[parts.length - 1].trim();
        if (pattern.length() == 0) {
            info.setErrorMessage("Empty patterns are not allowed");
            return info;
        }
        info.setPattern(pattern);
        IAssignableAttributeRetriever retriever = null;
        if (parts.length > 1) {
            String name = parts[0].trim();
            if (name.length() == 0) {
                info.setErrorMessage("Retriever name before ':' cannot be empty");
                return info;
            }
            retriever = provider.getAttributeRetriever(name);
            if (retriever == null) {
                info.setErrorMessage("Unknown retriever name: ");
                return info;
            }
            info.setRetriever(retriever);
            int paramCount = parts.length - 2;
            if (paramCount != retriever.getNumberOfParameters()) {
                info.setErrorMessage(String.format("Retriever '%s' expects %d parameters", name, retriever.getNumberOfParameters()));
                return info;
            }
            if (paramCount > 0) {
                String[] params = new String[paramCount];
                int i = 1;
                while (i <= paramCount) {
                    params[i - 1] = parts[i].trim();
                    ++i;
                }
                info.setParams(params);
            }
        }
        if (retriever == null) {
            retriever = provider.getAttributeRetriever(provider.getDefaultRetrieverName());
            info.setRetriever(retriever);
        }
        assert (retriever != null) : "'retriever' of method 'parsePattern' must not be null";
        try {
            CustomPattern compiledPattern = CustomPattern.compileWildcardPattern((String)pattern, (String)retriever.getBreakCharacters(), (boolean)false, (boolean)true);
            info.setCompiledPattern(compiledPattern);
        }
        catch (PatternSyntaxException e) {
            info.setErrorMessage("Syntax error in pattern '" + pattern + "'");
        }
        return info;
    }
}

