/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecture;

import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureElementCloner;
import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.architecture.ConnectionScheme;
import com.hello2morrow.sonargraph.core.model.architecture.ConnectionSchemeConnection;
import com.hello2morrow.sonargraph.core.model.architecture.Connector;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableFilter;
import com.hello2morrow.sonargraph.core.model.architecture.Identifier;
import com.hello2morrow.sonargraph.core.model.architecture.Interface;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.foundation.utilities.CustomPattern;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ArtifactTemplate
extends Artifact {
    private final Map<String, Artifact> m_generatedArtifacts = new HashMap<String, Artifact>();
    private final ArrayList<IAssignableFilter> m_includePatterns;
    private final ArrayList<IAssignableFilter> m_excludePatterns;
    private String m_artifactNameProgramm;
    private Artifact m_templateArtifact;
    private int m_nameVariableCount = 0;
    private ConnectionScheme m_defaultConnectionScheme;
    private IAssignableFilter m_pattern = null;
    private boolean m_mustHavePattern = false;

    public ArtifactTemplate(NamedElement parent, String name, FilePath definingFile, int line, String className) {
        super(parent, name, definingFile, line, className);
        this.m_includePatterns = new ArrayList();
        this.m_excludePatterns = new ArrayList();
    }

    public ArtifactTemplate(NamedElement parent, ArtifactTemplate other) {
        super(parent, other);
        this.m_includePatterns = other.m_includePatterns;
        this.m_excludePatterns = other.m_excludePatterns;
        this.m_artifactNameProgramm = other.m_artifactNameProgramm;
        this.m_defaultConnectionScheme = other.m_defaultConnectionScheme;
    }

    @Override
    public String getPresentationName(boolean shortName) {
        return "(" + super.getPresentationName(shortName) + ")";
    }

    public void setTemplateArtifact(Artifact templateArtifact) {
        this.m_templateArtifact = templateArtifact;
    }

    public Artifact getTemplateArtifact() {
        return this.m_templateArtifact;
    }

    public ConnectionScheme getDefaultConnectionScheme() {
        return this.m_defaultConnectionScheme;
    }

    public void setDefaultConnectionScheme(ConnectionScheme defaultConnectionScheme) {
        this.m_defaultConnectionScheme = defaultConnectionScheme;
    }

    public void addPattern(IAssignableFilter filter) {
        assert (filter != null) : "Parameter 'filter' of method 'addPattern' must not be null";
        int nameComponentCount = StringUtility.countChar((char)'(', (String)filter.getOriginalPattern());
        this.m_includePatterns.add(filter);
        this.m_nameVariableCount = Math.max(this.m_nameVariableCount, nameComponentCount);
        this.m_mustHavePattern = this.m_mustHavePattern || nameComponentCount == 0;
    }

    public boolean checkForPattern() {
        if (this.m_mustHavePattern) {
            return this.m_pattern != null;
        }
        return true;
    }

    public void addExcludePattern(IAssignableFilter pattern) {
        assert (pattern != null) : "Parameter 'pattern' of method 'addExludePattern' must not be null";
        this.m_excludePatterns.add(pattern);
    }

    public void setArtifactNameProgram(String program) {
        assert (program != null) : "Parameter 'program' of method 'setArtifactNameProgram' must not be null";
        this.m_artifactNameProgramm = program;
    }

    @Override
    public void clear() {
        this.m_generatedArtifacts.values().forEach(NamedElement::remove);
        this.m_generatedArtifacts.clear();
        this.getInterfaces().forEach(Interface::reset);
        this.getConnectors().forEach(Connector::reset);
        super.clear();
    }

    @Override
    public void assignComponent(IAssignableToArtifact component) {
        assert (false) : "Should never be called on a template";
    }

    private Artifact getTargetArtifact(String extractedName) {
        assert (extractedName != null && extractedName.length() > 0) : "Parameter 'extractedName' of method 'assignComponent' must not be empty";
        Artifact targetArtifact = this.m_generatedArtifacts.get(extractedName);
        if (targetArtifact == null) {
            THashMap predefinedClones = new THashMap();
            this.m_templateArtifact.getChildrenRecursively(Connector.class, new Class[0]).forEach(arg_0 -> this.lambda$3((Map)predefinedClones, arg_0));
            targetArtifact = ArchitectureElementCloner.clone(this.m_templateArtifact, Artifact.class, (Map<NamedElement, NamedElement>)predefinedClones);
            targetArtifact.setName(extractedName);
            targetArtifact.setParent(this);
            this.m_generatedArtifacts.put(extractedName, targetArtifact);
            this.addChild(targetArtifact);
        }
        return targetArtifact;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String computeExtractedName(String[] matchList) {
        assert (matchList != null && matchList.length > 0) : "Parameter 'matchList' of method 'computeExtractedName' must not be empty";
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        int i = 0;
        while (i < this.m_artifactNameProgramm.length()) {
            char c = this.m_artifactNameProgramm.charAt(i);
            if (Character.isDigit(c)) {
                int varIndex = c - 49;
                if (varIndex < 0) return "";
                if (matchList.length > varIndex) {
                    stack.push(matchList[varIndex]);
                } else {
                    stack.push("");
                }
            } else if (c == 'c') {
                String name = (String)stack.pop();
                name = StringUtility.capitalize((String)name);
                stack.push(name);
            } else if (c == '+') {
                String second = (String)stack.pop();
                String first = (String)stack.pop();
                stack.push(first + second);
            } else {
                int endIndex = this.m_artifactNameProgramm.indexOf(c, i + 1);
                if (c != '\"' && c != '\'' || endIndex <= i) return "";
                stack.push(this.m_artifactNameProgramm.substring(i + 1, endIndex));
                i = endIndex;
            }
            ++i;
        }
        return (String)stack.pop();
    }

    @Override
    public Artifact.Match offerComponent(IAssignableToArtifact element) {
        String extractedName;
        String[] matchList = CustomPattern.NO_MATCH;
        Artifact.Match match = null;
        boolean matched = false;
        for (IAssignableFilter p2 : this.m_includePatterns) {
            if (!p2.matches((IWorkerContext)DefaultWorkerContext.INSTANCE, element)) continue;
            matched = true;
            matchList = p2.getLastCaptureGroups();
            break;
        }
        if (matched && matchList.length == 0 && this.m_pattern != null && this.m_pattern.matches((IWorkerContext)DefaultWorkerContext.INSTANCE, element)) {
            matchList = this.m_pattern.getLastCaptureGroups();
        }
        if (matchList.length > 0 && (extractedName = this.computeExtractedName(matchList)).length() > 0 && !this.m_excludePatterns.stream().anyMatch(p -> p.matches((IWorkerContext)DefaultWorkerContext.INSTANCE, element))) {
            Artifact targetArtifact = this.getTargetArtifact(extractedName);
            match = targetArtifact.offerComponent(element);
        }
        return match;
    }

    @Override
    public void assignmentFinished() {
        Artifact nested;
        String name;
        super.assignmentFinished();
        List<Artifact> children = this.getChildren(Artifact.class);
        Interface defaultInterface = this.getArchitectureElement("default", Interface.class);
        Connector defaultConnector = this.getArchitectureElement("default", Connector.class);
        children.forEach(c -> defaultInterface.addExportedInterface(c.getArchitectureElement("default", Interface.class)));
        children.forEach(c -> defaultConnector.addIncludedConnector(c.getArchitectureElement("default", Connector.class)));
        for (Interface iface : this.getInterfaces()) {
            if (iface == defaultInterface) continue;
            name = iface.getShortName();
            for (Artifact artifact : children) {
                Interface exported = artifact.getArchitectureElement(name, Interface.class);
                if (exported != null) {
                    iface.addExportedInterface(exported);
                    continue;
                }
                nested = artifact.getArchitectureElement(name, Artifact.class);
                if (nested == null || !nested.isExposed()) continue;
                iface.addExportedInterface(nested.getArchitectureElement("default", Interface.class));
            }
        }
        for (Connector conn : this.getConnectors()) {
            if (conn == defaultConnector) continue;
            name = conn.getShortName();
            for (Artifact artifact : children) {
                Connector included = artifact.getArchitectureElement(name, Connector.class);
                if (included != null) {
                    conn.addIncludedConnector(included);
                    continue;
                }
                nested = artifact.getArchitectureElement(name, Artifact.class);
                if (nested == null) continue;
                conn.addIncludedConnector(nested.getArchitectureElement("default", Connector.class));
            }
        }
        if (this.m_defaultConnectionScheme != null) {
            for (Artifact from : this.m_generatedArtifacts.values()) {
                for (Artifact to : this.m_generatedArtifacts.values()) {
                    if (from == to) continue;
                    this.connectGeneratedArtifacts(from, to);
                }
            }
        }
    }

    private void connectGeneratedArtifacts(Artifact from, Artifact to) {
        for (ConnectionSchemeConnection conn : this.m_defaultConnectionScheme.getConnections()) {
            Connector fromConn = (Connector)from.findConnectorOrInterface(conn.getFrom(), Connector.class);
            if (fromConn == null) continue;
            for (Identifier toIdent : conn.getTo()) {
                Interface toInterface = (Interface)to.findConnectorOrInterface(toIdent.shiftLeft(), Interface.class);
                if (toInterface == null) continue;
                fromConn.connectTo(toInterface, false, false);
            }
        }
    }

    @Override
    public boolean processRequiredReferences(Set<Artifact> unrequiredCollector) {
        boolean wasRemoved = super.processRequiredReferences(unrequiredCollector);
        if (!wasRemoved) {
            for (Artifact hidden : this.m_templateArtifact.getChildrenRecursively(Artifact.class, new Class[0])) {
                hidden.processRequiredReferences(unrequiredCollector);
            }
        }
        return wasRemoved;
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        assert (visitor != null) : "Parameter 'visitor' of method 'accept' must not be null";
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitArtifactTemplate(this);
        } else {
            super.accept(visitor);
        }
    }

    public int getNameComponentCount() {
        return this.m_nameVariableCount;
    }

    @Property
    public boolean isTemplate() {
        return true;
    }

    @Override
    public void finishModification() {
        this.m_includePatterns.trimToSize();
        this.m_excludePatterns.trimToSize();
        super.finishModification();
    }

    public void setPattern(IAssignableFilter filter) {
        this.m_pattern = filter;
        int nameComponentCount = StringUtility.countChar((char)'(', (String)filter.getOriginalPattern());
        this.m_nameVariableCount = Math.max(this.m_nameVariableCount, nameComponentCount);
    }

    public IAssignableFilter getPattern() {
        return this.m_pattern;
    }

    private /* synthetic */ void lambda$3(Map map, Connector c) {
        c.getConnectedInterfaces().stream().filter(iface -> !iface.hasAsParent(this.m_templateArtifact, false)).forEach(iface -> {
            Interface interface_ = map.put(iface, iface);
        });
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitArtifactTemplate(ArtifactTemplate var1);
    }
}

