/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecture;

import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.architecture.ArtifactClass;
import com.hello2morrow.sonargraph.core.model.architecture.ArtifactTemplate;
import com.hello2morrow.sonargraph.core.model.architecture.ConnectionScheme;
import com.hello2morrow.sonargraph.core.model.architecture.Connector;
import com.hello2morrow.sonargraph.core.model.architecture.Interface;
import com.hello2morrow.sonargraph.core.model.architecture.RequiredConnection;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Map;

public class ArchitectureElementCloner
extends NamedElementVisitor
implements Artifact.IVisitor,
Interface.IVisitor,
Connector.IVisitor,
ConnectionScheme.IVisitor,
ArtifactClass.IVisitor,
ArchitectureFile.IVisitor,
ArtifactTemplate.IVisitor {
    private final Map<NamedElement, NamedElement> m_cloneMap = new THashMap();
    private final Deque<NamedElement> m_parentStack = new ArrayDeque<NamedElement>();

    public ArchitectureElementCloner(Map<NamedElement, NamedElement> predefinedClones) {
        this.m_cloneMap.putAll(predefinedClones);
    }

    @Override
    public void visitArtifactClass(ArtifactClass element) {
        ArtifactClass clone = new ArtifactClass(this.m_parentStack.peek(), element);
        this.processClone(element, clone);
    }

    @Override
    public void visitConnectionScheme(ConnectionScheme element) {
        ConnectionScheme clone = new ConnectionScheme(this.m_parentStack.peek(), element);
        this.processClone(element, clone);
    }

    @Override
    public void visitConnector(Connector element) {
        Connector clone = new Connector(this.m_parentStack.peek(), element);
        this.processClone(element, clone);
    }

    @Override
    public void visitInterface(Interface element) {
        Interface clone = new Interface(this.m_parentStack.peek(), element);
        this.processClone(element, clone);
    }

    @Override
    public void visitArtifact(Artifact element) {
        Artifact clone = new Artifact(this.m_parentStack.peek(), element);
        this.processClone(element, clone);
    }

    @Override
    public void visitArtifactTemplate(ArtifactTemplate element) {
        ArtifactTemplate clone = new ArtifactTemplate(this.m_parentStack.peek(), element);
        this.processClone(element, clone);
    }

    @Override
    public void visitArchitectureFile(ArchitectureFile element) {
        ArchitectureFile clone = new ArchitectureFile(null, element);
        this.processClone(element, clone);
    }

    private void processClone(NamedElement element, NamedElement clone) {
        NamedElement parent = clone.getParent();
        this.m_cloneMap.put(element, clone);
        if (parent != null) {
            parent.addChild(clone);
        }
        this.m_parentStack.push(clone);
        this.visitChildrenOf(element);
        this.m_parentStack.pop();
        if (this.m_parentStack.isEmpty()) {
            element.accept(new ClonerPhase2());
        }
    }

    public static <T extends NamedElement> T clone(NamedElement element, Class<T> cls) {
        return ArchitectureElementCloner.clone(element, cls, Collections.emptyMap());
    }

    public static <T extends NamedElement> T clone(NamedElement element, Class<T> cls, Map<NamedElement, NamedElement> predefinedClones) {
        assert (element != null) : "Parameter 'element' of method 'clone' must not be null";
        assert (cls != null) : "Parameter 'cls' of method 'clone' must not be null";
        assert (predefinedClones != null) : "Parameter 'predefinedClones' of method 'clone' must not be null";
        ArchitectureElementCloner cloner = new ArchitectureElementCloner(predefinedClones);
        element.accept(cloner);
        return (T)cloner.m_cloneMap.get(element);
    }

    private class ClonerPhase2
    extends NamedElementVisitor
    implements Interface.IVisitor,
    Connector.IVisitor,
    ArtifactTemplate.IVisitor,
    ArchitectureFile.IVisitor {
        private ClonerPhase2() {
        }

        @Override
        public void visitArtifactTemplate(ArtifactTemplate element) {
            ArtifactTemplate clone = (ArtifactTemplate)ArchitectureElementCloner.this.m_cloneMap.get(element);
            Artifact templateArtifact = element.getTemplateArtifact();
            Artifact clonedtemplateArtifact = ArchitectureElementCloner.clone(templateArtifact, Artifact.class);
            clone.setTemplateArtifact(clonedtemplateArtifact);
            this.visitChildrenOf(element);
        }

        @Override
        public void visitConnector(Connector element) {
            Connector clone = (Connector)ArchitectureElementCloner.this.m_cloneMap.get(element);
            assert (clone != null) : "'clone' of method 'visitConnector' must not be null";
            clone.finishCloning(element, ArchitectureElementCloner.this.m_cloneMap);
        }

        @Override
        public void visitInterface(Interface element) {
            Interface clone = (Interface)ArchitectureElementCloner.this.m_cloneMap.get(element);
            assert (clone != null) : "'clone' of method 'visitInterface' must not be null";
            clone.finishCloning(element, ArchitectureElementCloner.this.m_cloneMap);
        }

        @Override
        public void visitArchitectureFile(ArchitectureFile element) {
            ArchitectureFile clone = (ArchitectureFile)ArchitectureElementCloner.this.m_cloneMap.get(element);
            for (RequiredConnection c : element.getRequiredConnections()) {
                RequiredConnection clonedConnection = new RequiredConnection((Artifact)ArchitectureElementCloner.this.m_cloneMap.get(c.getContext()), c.getPosition(), (Connector)ArchitectureElementCloner.this.m_cloneMap.get(c.getConnector()), c.getTarget(), c.isTransitively(), c.isDeprecated());
                clone.addRequiredConnection(clonedConnection);
            }
            this.visitChildrenOf(element);
        }
    }
}

