/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.treemap;

import com.hello2morrow.sonargraph.core.foundation.common.treemap.IDataEntry;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public abstract class TreeMapNode<E, D> {
    public static final DecimalFormat FORMAT = (DecimalFormat)DecimalFormat.getInstance(Locale.getDefault());
    protected static final int NON_RECURSIVE_INDEX = -1;
    private E m_associatedElement;
    private D m_associatedData;
    private int m_relativeX;
    private int m_relativeY;
    private int m_width;
    private int m_height;

    static {
        FORMAT.setRoundingMode(RoundingMode.HALF_UP);
        FORMAT.setMaximumFractionDigits(2);
    }

    TreeMapNode() {
    }

    final void setAssociatedElement(E associatedElement) {
        this.m_associatedElement = associatedElement;
    }

    public final E getAssociatedElement() {
        return this.m_associatedElement;
    }

    public final void setAssociatedData(D data) {
        this.m_associatedData = data;
    }

    public final D getAssociatedData() {
        return this.m_associatedData;
    }

    public abstract String getKind();

    public abstract String getName();

    public abstract float getSize();

    public abstract boolean isLeaf();

    public final int getRelativeX() {
        return this.m_relativeX;
    }

    public final int getRelativeY() {
        return this.m_relativeY;
    }

    public final int getAbsoluteX() {
        return this.getX();
    }

    public final int getX() {
        TreeMapNode<E, D> parent = this.getParent();
        return parent != null ? parent.getX() + this.m_relativeX : this.m_relativeX;
    }

    public final int getAbsoluteY() {
        return this.getY();
    }

    public final int getY() {
        TreeMapNode<E, D> parent = this.getParent();
        return parent != null ? parent.getY() + this.m_relativeY : this.m_relativeY;
    }

    public final int getWidth() {
        return this.m_width;
    }

    public final int getHeight() {
        return this.m_height;
    }

    final void setLocation(int x, int y) {
        assert (x >= 0) : "'x' must not be negative";
        assert (y >= 0) : "'y' must not be negative";
        this.m_relativeX = x;
        this.m_relativeY = y;
    }

    final void setDimensions(int width, int height) {
        assert (width > 0) : "'width' must be greater than 0";
        assert (height > 0) : "'height' must be greater than 0";
        this.m_width = width;
        this.m_height = height;
    }

    final boolean hasDimensions() {
        return this.m_width > 0 && this.m_height > 0;
    }

    public abstract int getLevel();

    public abstract TreeMapNode<E, D> getParent();

    public abstract List<TreeMapNode<E, D>> getParents();

    protected abstract void addChild(TreeMapNode<E, D> var1);

    public abstract boolean hasChildren();

    public abstract List<TreeMapNode<E, D>> getChildren();

    abstract boolean matches(IDataEntry[] var1, int var2);

    void finishModification() {
    }

    public final void accept(IVisitor<E, D> visitor) {
        assert (visitor != null) : "Parameter 'visitor' of method 'accept' must not be null";
        if (visitor.visitNode(this)) {
            this.getChildren().forEach(c -> c.accept(visitor));
        }
    }

    public final String getInformation() {
        D associatedData;
        StringBuilder builder = new StringBuilder();
        List<TreeMapNode<E, D>> parents = this.getParents();
        if (!parents.isEmpty()) {
            Collections.reverse(parents);
            for (TreeMapNode<E, D> nextParent : parents) {
                builder.append("[Parent] ").append("<").append(nextParent.getLevel()).append("> ").append(nextParent.getKind()).append(": ").append(nextParent.getName()).append("\n");
            }
        }
        builder.append(this.isLeaf() ? "[Leaf] " : "[Non-leaf] ").append("<").append(this.getLevel()).append("> ").append(this.getKind()).append(": ").append(this.getName()).append("\n");
        builder.append("Size: ").append(FORMAT.format(this.getSize()));
        builder.append("\nRelative X,Y: ").append(FORMAT.format(this.getRelativeX())).append(",").append(FORMAT.format(this.getRelativeY()));
        builder.append("\nWidth|Height: ").append(FORMAT.format(this.m_width)).append("|").append(FORMAT.format(this.m_height));
        builder.append("\nAbsolute X,Y: ").append(FORMAT.format(this.getX())).append(",").append(FORMAT.format(this.getY()));
        E associatedElement = this.getAssociatedElement();
        if (associatedElement != null) {
            builder.append("\n[Associated element] ").append(associatedElement);
        }
        if ((associatedData = this.getAssociatedData()) != null) {
            builder.append("\n[Associated data] ").append(associatedData);
        }
        return builder.toString();
    }

    public final String toString() {
        return "[" + this.getClass().getSimpleName() + "] <" + this.getLevel() + "> " + this.getKind() + " '" + this.getName() + "' Size:" + FORMAT.format(this.getSize()) + " [Pos:" + this.getRelativeX() + "," + this.getRelativeY() + " W|H:" + FORMAT.format(this.m_width) + "|" + FORMAT.format(this.m_height) + "] (" + Integer.toHexString(this.hashCode()) + ")";
    }

    public static interface IVisitor<E, D> {
        public boolean visitNode(TreeMapNode<E, D> var1);
    }
}

