/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.treemap;

import com.hello2morrow.sonargraph.core.foundation.common.treemap.AttributeReference;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.SubdivisionNode;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.TreeMapNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class NonLeafNode<E, D>
extends SubdivisionNode<E, D> {
    private final List<TreeMapNode<E, D>> m_children = new ArrayList<TreeMapNode<E, D>>(500);
    private final int m_level;

    NonLeafNode(TreeMapNode<E, D> parent, AttributeReference attrRef, String value) {
        super(parent, attrRef, value);
        this.m_level = parent.getLevel() + 1;
    }

    @Override
    public int getLevel() {
        return this.m_level;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    protected void addChild(TreeMapNode<E, D> node) {
        assert (node != null) : "Parameter 'node' of method 'addChild' must not be null";
        this.m_children.add(node);
    }

    @Override
    public boolean hasChildren() {
        return !this.m_children.isEmpty();
    }

    @Override
    public List<TreeMapNode<E, D>> getChildren() {
        return Collections.unmodifiableList(this.m_children);
    }

    @Override
    void finishModification() {
        ((ArrayList)this.m_children).trimToSize();
    }
}

