/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.history;

import com.hello2morrow.sonargraph.core.foundation.common.history.HistoryTable;
import com.hello2morrow.sonargraph.core.foundation.common.history.IFileHistoryEntry;
import java.util.List;
import java.util.Optional;

public class ModifiableFileHistory
extends HistoryTable<FileHistoryEntry>
implements HistoryTable.IHistoryEntryChangedListener {
    private final String m_id;
    private final String m_name;
    private FileHistoryEntry m_lastSavedStateEntry;

    public ModifiableFileHistory(String name, String id) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'ModifiableFileHistory' must not be empty";
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'ModifiableFileHistory' must not be empty";
        this.m_name = name;
        this.m_id = id;
    }

    public String toString() {
        return String.format("History for '%s' [%s], size of undo queue: %d, size of redo queue: %d", this.m_name, this.m_id, this.getUndoEntriesSize(), this.getRedoEntriesSize());
    }

    public String getModifiableFileId() {
        return this.m_id;
    }

    public FileHistoryEntry createEntry(long transactionId, String commandName, String identifyingPath) {
        assert (commandName != null && commandName.length() > 0) : "Parameter 'commandName' of method 'createEntry' must not be empty";
        return new FileHistoryEntry(this, commandName, transactionId, identifyingPath);
    }

    @Override
    public void entryChanged(HistoryTable.ITableEntry entry) {
        assert (entry != null) : "Parameter 'entry' of method 'entryChanged' must not be null";
        assert (entry instanceof IFileHistoryEntry) : "Unexpected class: " + entry.getClass().getName();
        IFileHistoryEntry fileEntry = (IFileHistoryEntry)entry;
        if (fileEntry.needsSave()) {
            return;
        }
        for (FileHistoryEntry next : this.getEntries()) {
            if (next == entry) continue;
            next.setNeedsSave(true, false);
        }
    }

    @Override
    public boolean isUndoPossible() {
        return this.getUndoEntriesSize() > 1;
    }

    public FileHistoryEntry undoIt() {
        assert (this.isUndoPossible()) : "No undo possible";
        List undoEntries = this.getModifiableUndoEntries();
        FileHistoryEntry toBeRestored = this.getNextEntryForUndo();
        this.getModifiableRedoEntries().add(0, (FileHistoryEntry)undoEntries.remove(undoEntries.size() - 1));
        return toBeRestored;
    }

    public FileHistoryEntry redoIt() {
        return (FileHistoryEntry)super.redo().get(0);
    }

    @Override
    public FileHistoryEntry getNextEntryForUndo() {
        return (FileHistoryEntry)this.getUndoEntries().get(this.getUndoEntries().size() - 2);
    }

    public FileHistoryEntry removeEntry(long transactionId) {
        FileHistoryEntry removed = null;
        for (FileHistoryEntry next : this.getEntries()) {
            if (transactionId != next.getTransactionId()) continue;
            removed = next;
            this.removeEntry(next);
            break;
        }
        return removed;
    }

    public FileHistoryEntry getLastSavedEntry() {
        Optional<FileHistoryEntry> match = this.getEntries().stream().filter(f -> !f.needsSave()).findFirst();
        assert (!match.isPresent() || this.m_lastSavedStateEntry == null) : "There must either be a last saved entry available in the undo/redo queues or a m_lastSavedStateEntry, but not both";
        if (!match.isPresent()) {
            assert (this.m_lastSavedStateEntry != null) : "If there is no entry left in the undo/redo queues with needsSave==false, there must be a m_lastSavedStateEntry available";
            return this.m_lastSavedStateEntry;
        }
        return match.get();
    }

    public void setExplicitlyAddedLastSavedEntry(FileHistoryEntry entry) {
        assert (entry != null) : "Parameter 'entry' of method 'setLastSavedEntry' must not be null";
        this.m_lastSavedStateEntry = entry;
    }

    public FileHistoryEntry invalidateExplicitlyAddedLastSavedEntry() {
        FileHistoryEntry entry = this.m_lastSavedStateEntry;
        this.m_lastSavedStateEntry = null;
        return entry;
    }

    public static class FileHistoryEntry
    implements IFileHistoryEntry {
        private static final int REVERT_TX_ID = -1;
        private final HistoryTable.IHistoryEntryChangedListener m_changeListener;
        private final String m_commandName;
        private final long m_transactionId;
        private final String m_identifyingPath;
        private String m_path;
        private Boolean m_needsSave;

        protected FileHistoryEntry(HistoryTable.IHistoryEntryChangedListener listener, String commandName, long transactionId, String identifyingPath) {
            assert (listener != null) : "Parameter 'listener' of method 'FileHistoryEntry' must not be null";
            assert (commandName != null && commandName.length() > 0) : "Parameter 'commandName' of method 'FileHistoryEntry' must not be empty";
            assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'FileHistoryEntry' must not be empty";
            this.m_changeListener = listener;
            this.m_commandName = commandName;
            this.m_transactionId = transactionId;
            this.m_identifyingPath = identifyingPath;
        }

        protected FileHistoryEntry(String commandName, String identifyingPath) {
            assert (commandName != null && commandName.length() > 0) : "Parameter 'commandName' of method 'FileHistoryEntry' must not be empty";
            assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'FileHistoryEntry' must not be empty";
            this.m_changeListener = null;
            this.m_commandName = commandName;
            this.m_identifyingPath = identifyingPath;
            this.m_transactionId = -1L;
        }

        @Override
        public final void setNeedsSave(boolean needsSave, boolean notifyListener) {
            if (this.m_needsSave == null || this.m_needsSave != needsSave) {
                this.m_needsSave = needsSave;
                if (notifyListener && this.m_changeListener != null) {
                    this.m_changeListener.entryChanged(this);
                }
            }
        }

        @Override
        public final boolean needsSave() {
            assert (this.m_needsSave != null) : "needsSave has not been set!";
            return this.m_needsSave;
        }

        @Override
        public final void setPath(String path) {
            this.m_path = path;
        }

        @Override
        public final String getPath() {
            return this.m_path;
        }

        @Override
        public final String getIdentifyingPath() {
            return this.m_identifyingPath;
        }

        @Override
        public final String getCommandName() {
            return this.m_commandName;
        }

        @Override
        public final long getTransactionId() {
            return this.m_transactionId;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName()).append(", ").append(this.m_commandName).append(", ").append(this.m_transactionId).append(", '").append(this.m_identifyingPath).append("'");
            if (this.m_needsSave != null) {
                if (this.m_needsSave.booleanValue()) {
                    builder.append(", needs-save = true");
                } else {
                    builder.append(", needs-save = false");
                }
            } else {
                builder.append(", needs-save state not determined");
            }
            if (this.m_path != null) {
                builder.append(", path = '").append(this.m_path).append("'");
            } else {
                builder.append(", no path set");
            }
            return builder.toString();
        }
    }
}

