/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.graph;

final class MinimizerPolyLogBarnesHut {
    private static final float[] REPULSION_FORCE_FACTORS = new float[]{0.95f, 0.9f, 0.85f, 0.8f, 0.75f, 0.8f, 0.85f, 0.9f, 0.95f, 1.0f, 1.1f, 1.2f, 1.3f, 1.4f, 1.5f, 1.4f, 1.3f, 1.2f, 1.1f, 1.0f};
    private static final float DEFAULT_ATTR_EXPONENT = 3.0f;
    private static final float DEFAULT_GRAVITATION_FACTOR = 0.001f;
    private final int m_numberOfNodes;
    private final float[][] m_pos;
    private final float[][] m_attr;
    private final float[] m_baryCenter = new float[3];
    private final float m_attrExponent;
    private final float m_gravitationFactor;
    private float[][] m_attrValues;
    private int[][] m_attrIndexes;
    private float m_repulsionFactor = 1.0f;
    private OctTree m_octTree;

    MinimizerPolyLogBarnesHut(int numberOfNodes, float[][] attr, float[][] pos, float gravitationFactor, float attrExponent) {
        assert (numberOfNodes > 1) : "'numberOfNodes' must be greater than 1";
        this.m_numberOfNodes = numberOfNodes;
        this.m_attr = attr;
        this.m_pos = pos;
        this.m_attrExponent = attrExponent;
        this.m_gravitationFactor = gravitationFactor;
    }

    MinimizerPolyLogBarnesHut(int nodeNr, float[][] attr, float[][] pos) {
        this(nodeNr, attr, pos, 0.001f, 3.0f);
    }

    public void minimizeEnergy(int iterations) {
        assert (iterations > 1) : "'iterations' must be greater than 1";
        this.computeRepuFactor();
        float finalRepuFactor = this.m_repulsionFactor;
        this.attrMatrixToAttrList();
        this.buildOctTree();
        float[] oldPos = new float[3];
        float[] bestDir = new float[3];
        int step = 1;
        while (step <= iterations) {
            this.computeBaryCenter();
            this.buildOctTree();
            this.m_repulsionFactor = step / REPULSION_FORCE_FACTORS.length < (iterations - 20) / REPULSION_FORCE_FACTORS.length ? finalRepuFactor * (float)Math.pow(REPULSION_FORCE_FACTORS[step % REPULSION_FORCE_FACTORS.length], this.m_attrExponent) : finalRepuFactor;
            int i = 0;
            while (i < this.m_numberOfNodes) {
                float curEnergy;
                float oldEnergy = this.getEnergy(i);
                this.getDirection(i, bestDir);
                oldPos[0] = this.m_pos[i][0];
                oldPos[1] = this.m_pos[i][1];
                oldPos[2] = this.m_pos[i][2];
                float bestEnergy = oldEnergy;
                int bestMultiple = 0;
                bestDir[0] = bestDir[0] / 32.0f;
                bestDir[1] = bestDir[1] / 32.0f;
                bestDir[2] = bestDir[2] / 32.0f;
                int multiple = 32;
                while (multiple >= 1 && (bestMultiple == 0 || bestMultiple / 2 == multiple)) {
                    this.m_pos[i][0] = oldPos[0] + bestDir[0] * (float)multiple;
                    this.m_pos[i][1] = oldPos[1] + bestDir[1] * (float)multiple;
                    this.m_pos[i][2] = oldPos[2] + bestDir[2] * (float)multiple;
                    curEnergy = this.getEnergy(i);
                    if (curEnergy < bestEnergy) {
                        bestEnergy = curEnergy;
                        bestMultiple = multiple;
                    }
                    multiple /= 2;
                }
                multiple = 64;
                while (multiple <= 128 && bestMultiple == multiple / 2) {
                    this.m_pos[i][0] = oldPos[0] + bestDir[0] * (float)multiple;
                    this.m_pos[i][1] = oldPos[1] + bestDir[1] * (float)multiple;
                    this.m_pos[i][2] = oldPos[2] + bestDir[2] * (float)multiple;
                    curEnergy = this.getEnergy(i);
                    if (curEnergy < bestEnergy) {
                        bestEnergy = curEnergy;
                        bestMultiple = multiple;
                    }
                    multiple *= 2;
                }
                this.m_pos[i][0] = oldPos[0] + bestDir[0] * (float)bestMultiple;
                this.m_pos[i][1] = oldPos[1] + bestDir[1] * (float)bestMultiple;
                this.m_pos[i][2] = oldPos[2] + bestDir[2] * (float)bestMultiple;
                if (bestMultiple > 0) {
                    this.m_octTree.moveNode(oldPos, this.m_pos[i], 1.0f);
                }
                ++i;
            }
            ++step;
        }
    }

    private float getDist(float[] pos1, float[] pos2) {
        float xDiff = pos1[0] - pos2[0];
        float yDiff = pos1[1] - pos2[1];
        float zDiff = pos1[2] - pos2[2];
        return (float)Math.sqrt(xDiff * xDiff + yDiff * yDiff + zDiff * zDiff);
    }

    private float getDistToBaryCenter(int i) {
        float xDiff = this.m_pos[i][0] - this.m_baryCenter[0];
        float yDiff = this.m_pos[i][1] - this.m_baryCenter[1];
        float zDiff = this.m_pos[i][2] - this.m_baryCenter[2];
        return (float)Math.sqrt(xDiff * xDiff + yDiff * yDiff + zDiff * zDiff);
    }

    private float getRepulsionEnergy(int index, OctTree tree) {
        if (tree == null || tree.m_index == index) {
            return 0.0f;
        }
        float dist = this.getDist(this.m_pos[index], tree.m_position);
        if (tree.m_index < 0 && dist < tree.width()) {
            float energy = 0.0f;
            int i = 0;
            while (i < tree.m_children.length) {
                energy += this.getRepulsionEnergy(index, tree.m_children[i]);
                ++i;
            }
            return energy;
        }
        return -this.m_repulsionFactor * tree.m_weight * (float)Math.log(dist);
    }

    private float getEnergy(int index) {
        float energy = this.getRepulsionEnergy(index, this.m_octTree);
        int i = 0;
        while (i < this.m_attrIndexes[index].length) {
            if (this.m_attrIndexes[index][i] != index) {
                float dist = this.getDist(this.m_pos[this.m_attrIndexes[index][i]], this.m_pos[index]);
                energy = (float)((double)energy + (double)this.m_attrValues[index][i] * Math.pow(dist, this.m_attrExponent) / (double)this.m_attrExponent);
            }
            ++i;
        }
        float dist = this.getDistToBaryCenter(index);
        return energy += this.m_gravitationFactor * this.m_repulsionFactor * (float)(this.m_numberOfNodes - 1) * 0.5f * dist * dist;
    }

    private float addRepulsionDir(int index, OctTree tree, float[] dir) {
        if (tree == null || tree.m_index == index) {
            return 0.0f;
        }
        float dist = this.getDist(this.m_pos[index], tree.m_position);
        if (tree.m_index < 0 && dist < tree.width()) {
            float dir2 = 0.0f;
            int i = 0;
            while (i < tree.m_children.length) {
                dir2 += this.addRepulsionDir(index, tree.m_children[i], dir);
                ++i;
            }
            return dir2;
        }
        if ((double)dist != 0.0) {
            float tmp = -this.m_repulsionFactor * tree.m_weight / (dist * dist);
            int j = 0;
            while (j < 3) {
                int n = j;
                dir[n] = dir[n] + (tree.m_position[j] - this.m_pos[index][j]) * tmp;
                ++j;
            }
            return -tmp;
        }
        return 0.0f;
    }

    private void getDirection(int index, float[] dir) {
        dir[0] = 0.0f;
        dir[1] = 0.0f;
        dir[2] = 0.0f;
        float dir2 = this.addRepulsionDir(index, this.m_octTree, dir);
        int i = 0;
        while (i < this.m_attrIndexes[index].length) {
            if (this.m_attrIndexes[index][i] != index) {
                float dist = this.getDist(this.m_pos[this.m_attrIndexes[index][i]], this.m_pos[index]);
                float tmp = this.m_attrValues[index][i] * (float)Math.pow(dist, this.m_attrExponent - 2.0f);
                dir2 += tmp * (this.m_attrExponent - 1.0f);
                int j = 0;
                while (j < 3) {
                    int n = j;
                    dir[n] = dir[n] + (this.m_pos[this.m_attrIndexes[index][i]][j] - this.m_pos[index][j]) * tmp;
                    ++j;
                }
            }
            ++i;
        }
        dir2 += this.m_gravitationFactor * this.m_repulsionFactor * (float)(this.m_numberOfNodes - 1);
        int j = 0;
        while (j < 3) {
            int n = j;
            dir[n] = dir[n] + this.m_gravitationFactor * this.m_repulsionFactor * (float)(this.m_numberOfNodes - 1) * (this.m_baryCenter[j] - this.m_pos[index][j]);
            ++j;
        }
        dir[0] = dir[0] / dir2;
        dir[1] = dir[1] / dir2;
        dir[2] = dir[2] / dir2;
        float length = (float)Math.sqrt(dir[0] * dir[0] + dir[1] * dir[1] + dir[2] * dir[2]);
        if (length > this.m_octTree.width() / 8.0f) {
            dir[0] = dir[0] / (length /= this.m_octTree.width() / 8.0f);
            dir[1] = dir[1] / length;
            dir[2] = dir[2] / length;
        }
    }

    private void buildOctTree() {
        float[] minPos = new float[]{Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE};
        float[] maxPos = new float[]{Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE};
        int i = 0;
        while (i < this.m_numberOfNodes) {
            int j = 0;
            while (j < 3) {
                if (this.m_pos[i][j] < minPos[j]) {
                    minPos[j] = this.m_pos[i][j];
                }
                if (this.m_pos[i][j] > maxPos[j]) {
                    maxPos[j] = this.m_pos[i][j];
                }
                ++j;
            }
            ++i;
        }
        this.m_octTree = new OctTree(0, this.m_pos[0], 1.0f, minPos, maxPos);
        i = 1;
        while (i < this.m_numberOfNodes) {
            this.m_octTree.addNode(i, this.m_pos[i], 1.0f, 0);
            ++i;
        }
    }

    private void computeRepuFactor() {
        this.m_repulsionFactor = 0.0f;
        int i = 1;
        while (i < this.m_numberOfNodes) {
            int j = 0;
            while (j < i) {
                this.m_repulsionFactor += this.m_attr[i][j];
                ++j;
            }
            ++i;
        }
        this.m_repulsionFactor /= (float)(this.m_numberOfNodes * (this.m_numberOfNodes - 1) / 2);
        if (this.m_repulsionFactor == 0.0f) {
            this.m_repulsionFactor = 1.0f;
        }
    }

    private void computeBaryCenter() {
        this.m_baryCenter[0] = 0.0f;
        this.m_baryCenter[1] = 0.0f;
        this.m_baryCenter[2] = 0.0f;
        int i = 0;
        while (i < this.m_numberOfNodes) {
            this.m_baryCenter[0] = this.m_baryCenter[0] + this.m_pos[i][0];
            this.m_baryCenter[1] = this.m_baryCenter[1] + this.m_pos[i][1];
            this.m_baryCenter[2] = this.m_baryCenter[2] + this.m_pos[i][2];
            ++i;
        }
        this.m_baryCenter[0] = this.m_baryCenter[0] / (float)this.m_numberOfNodes;
        this.m_baryCenter[1] = this.m_baryCenter[1] / (float)this.m_numberOfNodes;
        this.m_baryCenter[2] = this.m_baryCenter[2] / (float)this.m_numberOfNodes;
    }

    private void attrMatrixToAttrList() {
        this.m_attrIndexes = new int[this.m_numberOfNodes][];
        this.m_attrValues = new float[this.m_numberOfNodes][];
        int i = 0;
        while (i < this.m_numberOfNodes) {
            int attrCounter = 0;
            int j = 0;
            while (j < this.m_numberOfNodes) {
                if (this.m_attr[i][j] > 0.0f) {
                    ++attrCounter;
                }
                ++j;
            }
            this.m_attrIndexes[i] = new int[attrCounter];
            this.m_attrValues[i] = new float[attrCounter];
            attrCounter = 0;
            j = 0;
            while (j < this.m_numberOfNodes) {
                if (this.m_attr[i][j] > 0.0f) {
                    this.m_attrIndexes[i][attrCounter] = j;
                    this.m_attrValues[i][attrCounter] = this.m_attr[i][j];
                    ++attrCounter;
                }
                ++j;
            }
            ++i;
        }
    }

    private static final class OctTree {
        private static final int MAX_DEPTH = 20;
        private final OctTree[] m_children = new OctTree[8];
        private final float[] m_position;
        private int m_index;
        private float m_weight;
        private final float[] m_minPos;
        private final float[] m_maxPos;

        OctTree(int index, float[] position, float weight, float[] minPos, float[] maxPos) {
            this.m_index = index;
            this.m_position = new float[]{position[0], position[1], position[2]};
            this.m_weight = weight;
            this.m_minPos = minPos;
            this.m_maxPos = maxPos;
        }

        private void addNodeInternal(int nodeIndex, float[] nodePos, float nodeWeight, int depth) {
            int childIndex = 0;
            int i = 0;
            while (i < 3) {
                if (nodePos[i] > (this.m_minPos[i] + this.m_maxPos[i]) / 2.0f) {
                    childIndex += 1 << i;
                }
                ++i;
            }
            if (this.m_children[childIndex] == null) {
                float[] newMinPos = new float[3];
                float[] newMaxPos = new float[3];
                int i2 = 0;
                while (i2 < 3) {
                    if ((childIndex & 1 << i2) == 0) {
                        newMinPos[i2] = this.m_minPos[i2];
                        newMaxPos[i2] = (this.m_minPos[i2] + this.m_maxPos[i2]) / 2.0f;
                    } else {
                        newMinPos[i2] = (this.m_minPos[i2] + this.m_maxPos[i2]) / 2.0f;
                        newMaxPos[i2] = this.m_maxPos[i2];
                    }
                    ++i2;
                }
                this.m_children[childIndex] = new OctTree(nodeIndex, nodePos, nodeWeight, newMinPos, newMaxPos);
            } else {
                this.m_children[childIndex].addNode(nodeIndex, nodePos, nodeWeight, depth + 1);
            }
        }

        void addNode(int nodeIndex, float[] nodePos, float nodeWeight, int depth) {
            if (nodeWeight == 0.0f) {
                return;
            }
            if (depth > 20) {
                return;
            }
            if (this.m_index >= 0) {
                this.addNodeInternal(this.m_index, this.m_position, this.m_weight, depth);
                this.m_index = -1;
            }
            int i = 0;
            while (i < 3) {
                this.m_position[i] = (this.m_position[i] * this.m_weight + nodePos[i] * nodeWeight) / (this.m_weight + nodeWeight);
                ++i;
            }
            this.m_weight += nodeWeight;
            this.addNodeInternal(nodeIndex, nodePos, nodeWeight, depth);
        }

        void moveNode(float[] oldPos, float[] newPos, float nodeWeight) {
            int i = 0;
            while (i < 3) {
                int n = i;
                this.m_position[n] = this.m_position[n] + (newPos[i] - oldPos[i]) * (nodeWeight / this.m_weight);
                ++i;
            }
            int childIndex = 0;
            int i2 = 0;
            while (i2 < 3) {
                if (oldPos[i2] > (this.m_minPos[i2] + this.m_maxPos[i2]) / 2.0f) {
                    childIndex += 1 << i2;
                }
                ++i2;
            }
            if (this.m_children[childIndex] != null) {
                this.m_children[childIndex].moveNode(oldPos, newPos, nodeWeight);
            }
        }

        float width() {
            float width = 0.0f;
            int i = 0;
            while (i < 3) {
                if (this.m_maxPos[i] - this.m_minPos[i] > width) {
                    width = this.m_maxPos[i] - this.m_minPos[i];
                }
                ++i;
            }
            return width;
        }
    }
}

