/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.graph;

import com.hello2morrow.sonargraph.core.foundation.common.graph.ICycleAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

class FeedbackArcSetCycleAdapter<T extends INode<?>>
implements ICycleAnalyzerAdapter {
    private final Map<T, Integer> m_nodeToGroup = new THashMap();
    private final Map<Integer, List<T>> m_groupIndexToCyclicNodes = new THashMap();
    private final Set<T> m_cyclicNodes = new THashSet();
    private final Collection<? extends INode<?>> m_nodes;

    FeedbackArcSetCycleAdapter(Collection<? extends INode<?>> nodes) {
        assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'FeedbackArcSetCycleAdapter' must not be empty";
        this.m_nodes = nodes;
    }

    final Collection<List<T>> getCycles() {
        return Collections.unmodifiableCollection(this.m_groupIndexToCyclicNodes.values());
    }

    final Set<T> getCyclicNodes() {
        return Collections.unmodifiableSet(this.m_cyclicNodes);
    }

    @Override
    public final Collection<? extends INode<?>> getNodes() {
        return this.m_nodes;
    }

    @Override
    public final boolean calculateLevels() {
        return false;
    }

    @Override
    public final boolean isCyclic(INode<?> node) {
        assert (node != null) : "Parameter 'node' of method 'isCyclic' must not be null";
        return this.m_cyclicNodes.contains(node);
    }

    @Override
    public void setGroupIndex(INode<?> node, int groupIndex, boolean isCyclic) {
        assert (node != null) : "Parameter 'node' of method 'setCycleGroup' must not be null";
        this.m_nodeToGroup.put(node, groupIndex);
        if (isCyclic) {
            this.m_cyclicNodes.add(node);
            List<T> cyclicNodes = this.m_groupIndexToCyclicNodes.get(groupIndex);
            if (cyclicNodes == null) {
                cyclicNodes = new ArrayList<T>();
                this.m_groupIndexToCyclicNodes.put(groupIndex, cyclicNodes);
            }
            cyclicNodes.add(node);
        }
    }

    @Override
    public final int getGroupIndex(INode<?> node) {
        assert (node != null) : "Parameter 'node' of method 'getCycleGroup' must not be null";
        Integer groupIndex = this.m_nodeToGroup.get(node);
        return groupIndex != null ? groupIndex : -1;
    }

    final int getNumberOfCyclicNodes() {
        return this.m_cyclicNodes.size();
    }

    final int getCyclicity() {
        int cyclicity = 0;
        for (List<T> nextCyclicNodes : this.m_groupIndexToCyclicNodes.values()) {
            cyclicity += nextCyclicNodes.size() * nextCyclicNodes.size();
        }
        return cyclicity;
    }

    @Override
    public final void setLevel(INode<?> node, int level) {
    }
}

