/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.graph;

import com.hello2morrow.sonargraph.core.foundation.common.graph.CycleAnalyzer;
import com.hello2morrow.sonargraph.core.foundation.common.graph.FeedbackArcSetCycleAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.graph.FeedbackArcSetCycleDetector;
import com.hello2morrow.sonargraph.core.foundation.common.graph.FeedbackArcSetFirstCycleDetectionCycleAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.graph.FeedbackArcSetInfo;
import com.hello2morrow.sonargraph.core.foundation.common.graph.FeedbackArcSetNode;
import com.hello2morrow.sonargraph.core.foundation.common.graph.FeedbackArcSetNonProgressCompositeWorkerContext;
import com.hello2morrow.sonargraph.core.foundation.common.graph.IFeedbackArcSetAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.foundation.activity.CancellableWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FASComputer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FASComputer.class);

    private FASComputer() {
    }

    private static void calculateAdditionalInformation(Set<FeedbackArcSetNode> cyclicNodes, List<FeedbackArcSetNode.Edge> removalCandidateEdges, FeedbackArcSetInfo info, IWorkerContext workerContext) {
        assert (cyclicNodes != null && !cyclicNodes.isEmpty()) : "Parameter 'cyclicNodes' of method 'calculateAdditionalInformation' must not be empty";
        assert (removalCandidateEdges != null) : "Parameter 'removalCandidateEdges' of method 'calculateAdditionalInformation' must not be null";
        assert (info != null) : "Parameter 'info' of method 'calculateAdditionalInformation' must not be null";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'calculateAdditionalInformation' must not be null";
        THashMap removedEdgeToCyclicity = new THashMap(removalCandidateEdges.size());
        THashMap removedEdgeToCyclicNodes = new THashMap(removalCandidateEdges.size());
        THashMap removedEdgeToSumOfWeight = new THashMap(removalCandidateEdges.size());
        LinkedHashSet<INode.IEdge> overdefinedEdges = new LinkedHashSet<INode.IEdge>();
        workerContext.working("Calculating cyclicity, cylic node reduction and over-definition", true);
        workerContext.beginBlockOfWork(removalCandidateEdges.size() * 2);
        for (FeedbackArcSetNode.Edge nextOutgoingEdge : removalCandidateEdges) {
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            nextOutgoingEdge.getFrom().addOutgoingEdge(nextOutgoingEdge);
            workerContext.workItemCompleted();
        }
        int sumOfParserDependencies = 0;
        boolean isCycleAlreadyBroken = false;
        for (FeedbackArcSetNode.Edge nextOutgoingEdge : removalCandidateEdges) {
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            int weightOfCurrentEdge = nextOutgoingEdge.getWeightOfUnderlyingEdge();
            removedEdgeToSumOfWeight.put(nextOutgoingEdge.getUnderlyingEdge(), sumOfParserDependencies += weightOfCurrentEdge);
            nextOutgoingEdge.getFrom().removeOutgoingEdge(nextOutgoingEdge);
            int remainingCyclicity = FASComputer.calculateCyclicity(nextOutgoingEdge.getUnderlyingEdge(), cyclicNodes, (Map<INode.IEdge, Integer>)removedEdgeToCyclicity, (Map<INode.IEdge, Integer>)removedEdgeToCyclicNodes, workerContext);
            if (isCycleAlreadyBroken) {
                overdefinedEdges.add(nextOutgoingEdge.getUnderlyingEdge());
            }
            isCycleAlreadyBroken = isCycleAlreadyBroken || remainingCyclicity == 0;
            workerContext.workItemCompleted();
        }
        workerContext.endStep();
        info.setCyclicityPerEdge((Map<INode.IEdge, Integer>)removedEdgeToCyclicity);
        info.setCyclicNodesPerEdge((Map<INode.IEdge, Integer>)removedEdgeToCyclicNodes);
        info.setSumOfWeightPerEdge((Map<INode.IEdge, Integer>)removedEdgeToSumOfWeight);
        info.setOverdefinedEdges(overdefinedEdges);
    }

    private static StartData createStartData(Collection<? extends INode<?>> cyclicNodes, IWorkerContext workerContext) {
        assert (cyclicNodes != null && !cyclicNodes.isEmpty()) : "Parameter 'cyclicNodes' of method 'createStartData' must not be empty";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createStartData' must not be null";
        THashMap nodeToFasNode = new THashMap(cyclicNodes.size());
        for (INode<?> iNode : cyclicNodes) {
            if (workerContext.hasBeenCanceled()) {
                return null;
            }
            nodeToFasNode.put(iNode, new FeedbackArcSetNode(iNode));
        }
        for (Map.Entry entry : nodeToFasNode.entrySet()) {
            if (workerContext.hasBeenCanceled()) {
                return null;
            }
            INode nextFromNode = (INode)entry.getKey();
            FeedbackArcSetNode nextFromFeedbackArcSetNode = (FeedbackArcSetNode)entry.getValue();
            for (INode.IEdge nextOutgoingEdge : nextFromNode.getOutgoingEdges()) {
                if (workerContext.hasBeenCanceled()) {
                    return null;
                }
                INode<?> nextToNode = nextOutgoingEdge.getTo();
                if (nextFromNode == nextToNode || !cyclicNodes.contains(nextToNode)) continue;
                FeedbackArcSetNode nextToFeedbackArcSetNode = (FeedbackArcSetNode)nodeToFasNode.get(nextToNode);
                assert (nextToFeedbackArcSetNode != null) : "Parameter 'nextToFeedbackArcSetNode' of method 'createStartData' must not be null";
                nextFromFeedbackArcSetNode.addOutgoingEdge(nextToFeedbackArcSetNode, nextOutgoingEdge, nextOutgoingEdge.getWeight());
            }
        }
        THashSet tHashSet = new THashSet(nodeToFasNode.values());
        return new StartData((Set<FeedbackArcSetNode>)tHashSet, Collections.emptySet(), (Set<FeedbackArcSetNode>)tHashSet, Collections.singletonList(tHashSet));
    }

    private static StartData createStartData(Collection<? extends INode<?>> cyclicNodes, List<FeedbackArcSetNode.Edge> removalCandidateEdges, FeedbackArcSetInfo info, IWorkerContext workerContext, IFeedbackArcSetAdapter adapter) {
        assert (cyclicNodes != null && !cyclicNodes.isEmpty()) : "Parameter 'cyclicNodes' of method 'createStartData' must not be empty";
        assert (removalCandidateEdges != null) : "Parameter 'removalCandidateEdges' of method 'createStartData' must not be null";
        assert (info != null) : "Parameter 'info' of method 'createStartData' must not be null";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createStartData' must not be null";
        assert (adapter != null) : "Parameter 'adapter' of method 'createStartData' must not be null";
        THashMap nodeToFasNode = new THashMap(cyclicNodes.size());
        for (INode<?> nextNode : cyclicNodes) {
            if (workerContext.hasBeenCanceled()) {
                return null;
            }
            nodeToFasNode.put(nextNode, new FeedbackArcSetNode(nextNode));
        }
        ArrayList<FeedbackArcSetNode.Edge> edgesToRemove = new ArrayList<FeedbackArcSetNode.Edge>();
        ArrayList<FeedbackArcSetNode.Edge> edgesToKeepIfPossible = new ArrayList<FeedbackArcSetNode.Edge>();
        int totalEdges = 0;
        int totalWeight = 0;
        int maxWeight = 0;
        for (Map.Entry nextEntry : nodeToFasNode.entrySet()) {
            if (workerContext.hasBeenCanceled()) {
                return null;
            }
            Iterator nextFromNode = (INode)nextEntry.getKey();
            FeedbackArcSetNode nextFromFeedbackArcSetNode = (FeedbackArcSetNode)nextEntry.getValue();
            for (INode.IEdge nextOutgoingEdge : nextFromNode.getOutgoingEdges()) {
                int nextWeight;
                if (workerContext.hasBeenCanceled()) {
                    return null;
                }
                INode<?> nextToNode = nextOutgoingEdge.getTo();
                if (nextFromNode == nextToNode || !cyclicNodes.contains(nextToNode)) continue;
                FeedbackArcSetNode nextToFeedbackArcSetNode = (FeedbackArcSetNode)nodeToFasNode.get(nextToNode);
                assert (nextToFeedbackArcSetNode != null) : "Parameter 'nextToFeedbackArcSetNode' of method 'createStartData' must not be null";
                int nextWeightToSet = nextWeight = nextOutgoingEdge.getWeight();
                IFeedbackArcSetAdapter.EdgeHint nextHint = adapter.getHint(nextOutgoingEdge);
                switch (nextHint) {
                    case KEEP_IF_POSSIBLE: {
                        break;
                    }
                    case REMOVE: {
                        nextWeightToSet = -1;
                        break;
                    }
                    case NONE: {
                        break;
                    }
                    default: {
                        assert (false) : "Unhandled hint: " + String.valueOf((Object)nextHint);
                        break;
                    }
                }
                maxWeight = Math.max(nextWeightToSet, maxWeight);
                FeedbackArcSetNode.Edge added = nextFromFeedbackArcSetNode.addOutgoingEdge(nextToFeedbackArcSetNode, nextOutgoingEdge, nextWeightToSet);
                switch (nextHint) {
                    case KEEP_IF_POSSIBLE: {
                        edgesToKeepIfPossible.add(added);
                        break;
                    }
                    case REMOVE: {
                        edgesToRemove.add(added);
                        break;
                    }
                    case NONE: {
                        break;
                    }
                    default: {
                        assert (false) : "Unhandled hint: " + String.valueOf((Object)nextHint);
                        break;
                    }
                }
                ++totalEdges;
                totalWeight += nextWeight;
            }
        }
        if (!edgesToKeepIfPossible.isEmpty()) {
            int setWeightForEdgesToKeep = maxWeight + 1;
            for (FeedbackArcSetNode.Edge nextEdgeToKeep : edgesToKeepIfPossible) {
                nextEdgeToKeep.setWeight(setWeightForEdgesToKeep);
            }
        }
        info.setOutgoingEdgesOfCyclicNodes(totalEdges);
        info.setWeightOfOutgoingEdgesOfCyclicNodes(totalWeight);
        LinkedHashSet<FeedbackArcSetNode> sortedFasNodes = new LinkedHashSet<FeedbackArcSetNode>(nodeToFasNode.values().stream().sorted(Comparator.comparingInt(FeedbackArcSetNode::getTotalWeightOfUnderlyingOutgoingEdges)).collect(Collectors.toList()));
        assert (sortedFasNodes.size() == cyclicNodes.size()) : "Number of FAS nodes must match number of cyclic input nodes";
        if (!edgesToRemove.isEmpty()) {
            LOGGER.debug("Explicitly remove " + edgesToRemove.size() + " edge(s)");
            for (FeedbackArcSetNode.Edge nextOutgoingEdge : edgesToRemove) {
                assert (nextOutgoingEdge.getWeight() == -1) : "Unexpected weight: " + nextOutgoingEdge.getFrom().getName() + " -> " + nextOutgoingEdge.getTo().getName() + " [weight: " + nextOutgoingEdge.getWeight() + "]";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Explicitly remove edge: " + nextOutgoingEdge.getFrom().getName() + " -> " + nextOutgoingEdge.getTo().getName() + " [weight: " + nextOutgoingEdge.getWeightOfUnderlyingEdge() + "]");
                }
                nextOutgoingEdge.getFrom().removeOutgoingEdge(nextOutgoingEdge);
                removalCandidateEdges.add(nextOutgoingEdge);
            }
        }
        LinkedHashSet<INode.IEdge> underlyingEdgesToKeepIfPossible = new LinkedHashSet<INode.IEdge>(edgesToKeepIfPossible.size());
        if (!edgesToKeepIfPossible.isEmpty()) {
            LOGGER.debug(edgesToKeepIfPossible.size() + " edge(s) should be kept if possible");
            for (FeedbackArcSetNode.Edge nextOutgoingEdge : edgesToKeepIfPossible) {
                LOGGER.debug("Keep edge if possible: " + nextOutgoingEdge.getFrom().getName() + " -> " + nextOutgoingEdge.getTo().getName() + " [weight: " + nextOutgoingEdge.getWeightOfUnderlyingEdge() + "]");
                underlyingEdgesToKeepIfPossible.add(nextOutgoingEdge.getUnderlyingEdge());
            }
        }
        StrictPair<Set<FeedbackArcSetNode>, List<Set<FeedbackArcSetNode>>> cyclicNodesAndCycles = FASComputer.getCyclicNodesAndCycles(sortedFasNodes, workerContext);
        return new StartData(sortedFasNodes, underlyingEdgesToKeepIfPossible, (Set)cyclicNodesAndCycles.getFirst(), (List)cyclicNodesAndCycles.getSecond());
    }

    private static StrictPair<Set<FeedbackArcSetNode>, List<Set<FeedbackArcSetNode>>> getCyclicNodesAndCycles(Set<FeedbackArcSetNode> nodes, IWorkerContext workerContext) {
        assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'getCycles' must not be empty";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'getCyclicNodesAndCycles' must not be null";
        FeedbackArcSetCycleAdapter cycleAdapter = new FeedbackArcSetCycleAdapter(nodes);
        CycleAnalyzer.compute(cycleAdapter, new FeedbackArcSetNonProgressCompositeWorkerContext(workerContext));
        Collection cycles = cycleAdapter.getCycles();
        ArrayList cyclesAsSortedSets = new ArrayList(cycles.size());
        for (List nextCycle : cycles.stream().sorted(Comparator.comparingInt(List::size)).collect(Collectors.toList())) {
            cyclesAsSortedSets.add(new LinkedHashSet(nextCycle.stream().sorted(Comparator.comparingInt(FeedbackArcSetNode::getTotalWeightOfUnderlyingOutgoingEdges)).collect(Collectors.toList())));
        }
        return new StrictPair(cycleAdapter.getCyclicNodes(), cyclesAsSortedSets);
    }

    static boolean containsCyclicNodes(Set<FeedbackArcSetNode> nodes) {
        assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'getCycles' must not be empty";
        CancellableWorkerContext workerContext = new CancellableWorkerContext();
        FeedbackArcSetFirstCycleDetectionCycleAdapter cycleAdapter = new FeedbackArcSetFirstCycleDetectionCycleAdapter(nodes, workerContext);
        CycleAnalyzer.compute(cycleAdapter, (IWorkerContext)workerContext);
        return cycleAdapter.getNumberOfCyclicNodes() > 0;
    }

    private static int calculateCyclicity(INode.IEdge edge, Set<FeedbackArcSetNode> nodes, Map<INode.IEdge, Integer> edgeToCyclicity, Map<INode.IEdge, Integer> edgeToCyclicNodes, IWorkerContext workerContext) {
        assert (edge != null) : "Parameter 'edge' of method 'calculateCyclicity' must not be null";
        assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'getCyclicNodes' must not be empty";
        assert (edgeToCyclicity != null) : "Parameter 'edgeToCyclicity' of method 'calculateCyclicity' must not be null";
        assert (edgeToCyclicNodes != null) : "Parameter 'edgeToCyclicNodes' of method 'calculateCyclicity' must not be null";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'calculateCyclicity' must not be null";
        FeedbackArcSetCycleAdapter cycleAdapter = new FeedbackArcSetCycleAdapter(nodes);
        CycleAnalyzer.compute(cycleAdapter, new FeedbackArcSetNonProgressCompositeWorkerContext(workerContext));
        int cyclicity = cycleAdapter.getCyclicity();
        edgeToCyclicity.put(edge, cyclicity);
        edgeToCyclicNodes.put(edge, cycleAdapter.getNumberOfCyclicNodes());
        return cyclicity;
    }

    private static void reduceWeight(StartData startData, List<FeedbackArcSetNode.Edge> removalCandidateEdges, IWorkerContext workerContext) {
        assert (removalCandidateEdges != null) : "Parameter 'removalCandidateEdges' of method 'reduceWeight' must not be null";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'reduceWeight' must not be null";
        Set currentCyclicNodes = startData.getInitialCyclicNodes();
        assert (currentCyclicNodes != null && !currentCyclicNodes.isEmpty()) : "Parameter 'currentCyclicNodes' of method 'reduceWeight' must not be empty";
        List currentCycles = startData.getInitialCycles();
        assert (currentCycles != null && !currentCycles.isEmpty()) : "Parameter 'currentCycles' of method 'reduceWeight' must not be empty";
        int iteration = 1;
        do {
            int nextWeight;
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            List<Object> edgesOfCyclicNodes = new ArrayList();
            int minWeight = Integer.MAX_VALUE;
            Set<FeedbackArcSetNode> nextCycle = currentCycles.get(0);
            for (FeedbackArcSetNode nextCyclicNode : nextCycle) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                for (FeedbackArcSetNode.Edge edge : nextCyclicNode.getOutgoingEdges()) {
                    nextWeight = edge.getWeight();
                    if (nextWeight == -1 || !nextCycle.contains(edge.getTo())) continue;
                    minWeight = Math.min(minWeight, nextWeight);
                    edgesOfCyclicNodes.add(edge);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Reduce weight of " + edgesOfCyclicNodes.size() + " edges from cycle with " + nextCycle.size() + " nodes (min weight: " + minWeight + ", iteration: " + iteration + ")");
            }
            int removedOutgoingEdges = 0;
            boolean cycleAlreadyBroken = false;
            edgesOfCyclicNodes = edgesOfCyclicNodes.stream().sorted(Comparator.comparingInt(FeedbackArcSetNode.Edge::getWeight).thenComparing(FeedbackArcSetNode.Edge::getNameOfUnderlyingFrom).thenComparing(FeedbackArcSetNode.Edge::getNameOfUnderlyingTo)).collect(Collectors.toList());
            for (FeedbackArcSetNode.Edge edge : edgesOfCyclicNodes) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                nextWeight = edge.getWeight();
                assert (nextWeight != 0) : "Weight of edge to reduce is already 0: " + edge.getFrom().getName() + " -> " + edge.getTo().getName();
                int newWeight = Math.max(nextWeight - minWeight, 0);
                edge.setWeight(newWeight);
                if (newWeight != 0 || cycleAlreadyBroken) continue;
                edge.getFrom().removeOutgoingEdge(edge);
                removalCandidateEdges.add(edge);
                ++removedOutgoingEdges;
                if (FASComputer.containsCyclicNodes(nextCycle)) continue;
                cycleAlreadyBroken = true;
            }
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            StrictPair<Set<FeedbackArcSetNode>, List<Set<FeedbackArcSetNode>>> strictPair = FASComputer.getCyclicNodesAndCycles(currentCyclicNodes, workerContext);
            currentCyclicNodes = (Set)strictPair.getFirst();
            currentCycles = (List)strictPair.getSecond();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Reduce weight of " + edgesOfCyclicNodes.size() + " edges from cycle with " + nextCycle.size() + " nodes (min weight: " + minWeight + ", iteration: " + iteration + ") - done [removed edges: " + removedOutgoingEdges + "]");
            }
            ++iteration;
        } while (!currentCycles.isEmpty());
    }

    static final Set<INode.IEdge> compute(IWorkerContext workerContext, Collection<? extends INode<?>> cyclicNodes) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'compute' must not be null";
        assert (cyclicNodes != null && !cyclicNodes.isEmpty()) : "Parameter 'cyclicNodes' of method 'compute' must not be empty";
        StartData startData = FASComputer.createStartData(cyclicNodes, workerContext);
        if (workerContext.hasBeenCanceled()) {
            return Collections.emptySet();
        }
        assert (startData != null) : "'startData' of method 'FeedbackArcSetComputer' must not be null";
        assert (!startData.getInitialCyclicNodes().isEmpty());
        List<FeedbackArcSetNode.Edge> removalCandidateEdges = new ArrayList<FeedbackArcSetNode.Edge>();
        FASComputer.reduceWeight(startData, removalCandidateEdges, workerContext);
        if (workerContext.hasBeenCanceled()) {
            return Collections.emptySet();
        }
        removalCandidateEdges = removalCandidateEdges.stream().sorted(Comparator.comparingInt(FeedbackArcSetNode.Edge::getWeightOfUnderlyingEdge).thenComparing(FeedbackArcSetNode.Edge::getNameOfUnderlyingFrom).thenComparing(FeedbackArcSetNode.Edge::getNameOfUnderlyingTo)).collect(Collectors.toList());
        FeedbackArcSetCycleDetector cycleDetector = new FeedbackArcSetCycleDetector(startData.getInitialFasNodes(), workerContext);
        THashSet feedbackArcSet = new THashSet();
        Iterator<FeedbackArcSetNode.Edge> removedOutgoingEdgesIterator = removalCandidateEdges.iterator();
        while (removedOutgoingEdgesIterator.hasNext()) {
            if (workerContext.hasBeenCanceled()) {
                return Collections.emptySet();
            }
            FeedbackArcSetNode.Edge nextOutgoingEdge = removedOutgoingEdgesIterator.next();
            assert (nextOutgoingEdge.getWeight() != -1);
            nextOutgoingEdge.getFrom().addOutgoingEdge(nextOutgoingEdge);
            if (cycleDetector.hasCycles()) {
                nextOutgoingEdge.getFrom().removeOutgoingEdge(nextOutgoingEdge);
                feedbackArcSet.add(nextOutgoingEdge.getUnderlyingEdge());
                continue;
            }
            removedOutgoingEdgesIterator.remove();
        }
        return feedbackArcSet;
    }

    static void compute(IWorkerContext workerContext, IFeedbackArcSetAdapter adapter, FeedbackArcSetInfo info, Collection<? extends INode<?>> cyclicInputNodes) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'compute' must not be null";
        assert (adapter != null) : "Parameter 'adapter' of method 'compute' must not be null";
        assert (info != null) : "Parameter 'info' of method 'compute' must not be null";
        assert (cyclicInputNodes != null && cyclicInputNodes.size() >= 2) : "Parameter 'cyclicInputNodes' of method 'compute' must at least contain 2 nodes";
        workerContext.working("Compute feedback arc set", true);
        LOGGER.debug("Compute FAS for " + cyclicInputNodes.size() + " cyclic nodes");
        List<FeedbackArcSetNode.Edge> removalCandidateEdges = new ArrayList<FeedbackArcSetNode.Edge>();
        StartData startData = FASComputer.createStartData(cyclicInputNodes, removalCandidateEdges, info, workerContext, adapter);
        workerContext.endStep();
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        assert (startData != null) : "'startData' of method 'FeedbackArcSetComputer' must not be null";
        if (!startData.getInitialCyclicNodes().isEmpty()) {
            workerContext.working("Weight reduction", false);
            LOGGER.debug("Weight reduction (phase 1 of FAS Algorithm)");
            FASComputer.reduceWeight(startData, removalCandidateEdges, workerContext);
            LOGGER.debug("Weight reduction (phase 1 of FAS Algorithm) - done");
        } else {
            LOGGER.debug("Skipping weight reduction (phase 1 of FAS Algorithm) - all cycles already broken due to explicitly removed edges");
        }
        workerContext.endStep();
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        workerContext.working("Re-adding removed edges", true);
        LOGGER.debug("Re-adding removed edges without re-introducing cycles (phase 2 of FAS Algorithm)");
        workerContext.beginBlockOfWork(removalCandidateEdges.size());
        removalCandidateEdges = removalCandidateEdges.stream().sorted(Comparator.comparingInt(FeedbackArcSetNode.Edge::getWeightOfUnderlyingEdge).thenComparing(FeedbackArcSetNode.Edge::getNameOfUnderlyingFrom).thenComparing(FeedbackArcSetNode.Edge::getNameOfUnderlyingTo)).collect(Collectors.toList());
        FeedbackArcSetCycleDetector cycleDetector = new FeedbackArcSetCycleDetector(startData.getInitialFasNodes(), workerContext);
        int totalWeightOfEdgesToBeRemoved = 0;
        LinkedHashSet<INode.IEdge> feedbackArcSet = new LinkedHashSet<INode.IEdge>();
        Iterator<FeedbackArcSetNode.Edge> removedOutgoingEdgesIterator = removalCandidateEdges.iterator();
        while (removedOutgoingEdgesIterator.hasNext()) {
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            FeedbackArcSetNode.Edge nextOutgoingEdge = removedOutgoingEdgesIterator.next();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Edge: " + nextOutgoingEdge.getFrom().getName() + " -> " + nextOutgoingEdge.getTo().getName() + " (" + nextOutgoingEdge.getWeightOfUnderlyingEdge() + ")");
            }
            if (nextOutgoingEdge.getWeight() == -1) {
                nextUnderlyingEdge = nextOutgoingEdge.getUnderlyingEdge();
                feedbackArcSet.add(nextUnderlyingEdge);
                totalWeightOfEdgesToBeRemoved += nextUnderlyingEdge.getWeight();
            } else {
                nextOutgoingEdge.getFrom().addOutgoingEdge(nextOutgoingEdge);
                if (cycleDetector.hasCycles()) {
                    nextOutgoingEdge.getFrom().removeOutgoingEdge(nextOutgoingEdge);
                    nextUnderlyingEdge = nextOutgoingEdge.getUnderlyingEdge();
                    feedbackArcSet.add(nextUnderlyingEdge);
                    totalWeightOfEdgesToBeRemoved += nextUnderlyingEdge.getWeight();
                } else {
                    removedOutgoingEdgesIterator.remove();
                }
            }
            workerContext.workItemCompleted();
        }
        workerContext.endStep();
        info.setWeightOfOutgoingEdgesToBeRemoved(totalWeightOfEdgesToBeRemoved);
        info.setOutgoingEdgesToBeRemoved(feedbackArcSet.size());
        LOGGER.debug("Re-adding removed edges without re-introducing cycles (phase 2 of FAS Algorithm) - done");
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        if (adapter.calculateAdditionalInformation()) {
            FASComputer.calculateAdditionalInformation(startData.getInitialFasNodes(), removalCandidateEdges, info, workerContext);
        }
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        Set<INode.IEdge> underlyingEdgesToKeepIfPossible = startData.getUnderlyingEdgesToKeepIfPossible();
        LinkedHashSet<INode.IEdge> notKeptEdges = new LinkedHashSet<INode.IEdge>(feedbackArcSet.stream().filter(e -> underlyingEdgesToKeepIfPossible.contains(e)).collect(Collectors.toList()));
        if (!notKeptEdges.isEmpty()) {
            LOGGER.debug(notKeptEdges.size() + " edge(s) could not be kept");
            if (LOGGER.isDebugEnabled()) {
                for (INode.IEdge nextOutgoingEdge : notKeptEdges) {
                    LOGGER.debug("Edge could not be kept: " + nextOutgoingEdge.getFrom().getName() + " -> " + nextOutgoingEdge.getTo().getName() + " [weight: " + nextOutgoingEdge.getWeight() + "]");
                }
            }
        }
        adapter.feedbackArcSet(info, feedbackArcSet, notKeptEdges);
        LOGGER.debug("Compute FAS for " + cyclicInputNodes.size() + " cyclic nodes - done: " + String.valueOf(info));
        if (LOGGER.isDebugEnabled()) {
            for (INode.IEdge next : feedbackArcSet) {
                LOGGER.debug("Edge to remove: " + next.getFrom().getName() + " -> " + next.getTo().getName() + " [weight: " + next.getWeight() + "]");
            }
        }
    }

    private static final class StartData {
        private final Set<FeedbackArcSetNode> m_initialFasNodes;
        private final Set<INode.IEdge> m_underlyingEdgesToKeepIfPossible;
        private final Set<FeedbackArcSetNode> m_initialCyclicNodes;
        private final List<Set<FeedbackArcSetNode>> m_initialCycles;

        StartData(Set<FeedbackArcSetNode> initialFasNodes, Set<INode.IEdge> underlyingEdgesToKeepIfPossible, Set<FeedbackArcSetNode> startCyclicNodes, List<Set<FeedbackArcSetNode>> startCycles) {
            assert (initialFasNodes != null && !initialFasNodes.isEmpty()) : "Parameter 'initialFasNodes' of method 'StartData' must not be empty";
            assert (underlyingEdgesToKeepIfPossible != null) : "Parameter 'underlyingEdgesToKeepIfPossible' of method 'StartData' must not be null";
            this.m_initialFasNodes = initialFasNodes;
            this.m_underlyingEdgesToKeepIfPossible = underlyingEdgesToKeepIfPossible;
            this.m_initialCyclicNodes = startCyclicNodes;
            this.m_initialCycles = startCycles;
        }

        Set<FeedbackArcSetNode> getInitialFasNodes() {
            return this.m_initialFasNodes;
        }

        Set<INode.IEdge> getUnderlyingEdgesToKeepIfPossible() {
            return this.m_underlyingEdgesToKeepIfPossible;
        }

        Set<FeedbackArcSetNode> getInitialCyclicNodes() {
            return this.m_initialCyclicNodes;
        }

        public List<Set<FeedbackArcSetNode>> getInitialCycles() {
            return this.m_initialCycles;
        }
    }
}

