/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.treemap;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.controller.system.base.IIssueParticipationProvider;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.IResolution;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionMode;
import com.hello2morrow.sonargraph.core.model.treemap.IssueCollectorValueSource;
import java.util.ArrayList;
import java.util.List;

final class ConfigurableIssueCollector
extends NamedElementVisitor
implements SourceFile.IVisitor,
ProgrammingElement.IVisitor {
    private final IssueCollectorValueSource m_valueSource;
    private final IIssueParticipationProvider m_participationProvider;
    private ArrayList<Issue> m_issues = new ArrayList();

    ConfigurableIssueCollector(IssueCollectorValueSource valueSource, IIssueParticipationProvider participationProvider) {
        assert (valueSource != null) : "Parameter 'valueSource' of method 'ConfigurableIssueCollector' must not be null";
        assert (participationProvider != null) : "Parameter 'participationProvider' of method 'ConfigurableIssueCollector' must not be null";
        this.m_valueSource = valueSource;
        this.m_participationProvider = participationProvider;
    }

    private boolean include(Issue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'include' must not be null";
        Severity severity = issue.getSeverity();
        if (!this.m_valueSource.containsSeverity(severity)) {
            return false;
        }
        IResolution resolution = issue.getResolution();
        if (resolution == null) {
            return this.m_valueSource.containsResolutionMode(ResolutionMode.NONE);
        }
        if (resolution.ignores()) {
            return this.m_valueSource.containsResolutionMode(ResolutionMode.IGNORE);
        }
        return this.m_valueSource.containsResolutionMode(ResolutionMode.TASK);
    }

    @Override
    public void visitNamedElement(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitNamedElement' must not be null";
        for (Issue next : element.getIssues()) {
            if (!this.include(next)) continue;
            this.m_issues.add(next);
        }
        super.visitNamedElement(element);
    }

    @Override
    public void visitSourceFile(SourceFile element) {
        assert (element != null) : "Parameter 'element' of method 'visitSourceFile' must not be null";
        for (Issue issue : this.m_participationProvider.getParticipatingInDuplicateCodeBlockIssues(element)) {
            if (!this.include(issue)) continue;
            this.m_issues.add(issue);
        }
        for (Issue issue : this.m_participationProvider.getParticipatingInCycleIssues(element)) {
            if (!this.include(issue)) continue;
            this.m_issues.add(issue);
        }
        this.visitNamedElement(element);
    }

    @Override
    public void visitProgrammingElement(ProgrammingElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitProgrammingElement' must not be null";
        for (ParserDependency dependency : element.getOutgoingDependencies(new IParserDependencyType[0])) {
            for (Issue next : dependency.getIssues()) {
                if (!this.include(next)) continue;
                this.m_issues.add(next);
            }
        }
        this.visitNamedElement(element);
    }

    List<Issue> consumeIssues() {
        ArrayList<Issue> issues = this.m_issues;
        this.m_issues = new ArrayList();
        issues.trimToSize();
        return issues;
    }
}

