/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.representation;

import com.hello2morrow.sonargraph.core.controller.system.representation.PotentialDependencyCollector;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.IStructureItem;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.representation.IRepresentationProvider;
import com.hello2morrow.sonargraph.core.model.representation.Representation;
import com.hello2morrow.sonargraph.core.model.system.StructureInfo;
import java.util.Collection;
import java.util.Set;

public class GraphAdditionalsCollector
extends PotentialDependencyCollector {
    private final Collection<NamedElement> m_stopElements;
    private final PresentationMode m_presentationMode;
    private final boolean m_isTypeBasedGraph;

    public GraphAdditionalsCollector(IRepresentationProvider representationProvider, StructureInfo structureInfo, Representation representation, Collection<NamedElement> stopElements, NamedElement elementForAdditionals, IDomainRoot.Domain domain, PresentationMode presentationMode, boolean isTypeBasedGraph) {
        super(representationProvider, structureInfo, representation, elementForAdditionals, null, domain);
        assert (representationProvider != null) : "Parameter 'representationProvider' of method 'GraphAdditionalsCollector' must not be null";
        assert (stopElements != null) : "Parameter 'stopElements' of method 'GraphAdditionalsCollector' must not be null";
        assert (domain != null) : "Parameter 'domain' of method 'GraphAdditionalsCollector' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'GraphAdditionalsCollector' must not be null";
        this.m_stopElements = stopElements;
        this.m_presentationMode = presentationMode;
        this.m_isTypeBasedGraph = isTypeBasedGraph;
    }

    @Override
    public void visitProgrammingElement(ProgrammingElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitProgrammingElement' must not be null";
        IStructureItem elementStructureItem = element.getStructureItem();
        if (this.getElementForAdditionals() instanceof ProgrammingElement && (element instanceof IType || !this.m_isTypeBasedGraph)) {
            this.addElementToCalculated(element, PotentialDependencyCollector.MatchingType.EXACT);
            this.visitChildrenOf(element);
        } else if (this.getStructureInfo().getPositionInStructure(this.getReferenceStructureItem()) < this.getStructureInfo().getPositionInStructure(elementStructureItem)) {
            this.addElementToCalculated(element.getParent(), PotentialDependencyCollector.MatchingType.EXACT);
        }
    }

    @Override
    public void visitLogicalProgrammingElement(LogicalProgrammingElement element) {
        IStructureItem elementStructureItem = element.getStructureItem();
        if (this.getElementForAdditionals() instanceof LogicalProgrammingElement && (element.getPrimaryProgrammingElement() instanceof IType || !this.m_isTypeBasedGraph)) {
            this.addElementToCalculated(element, PotentialDependencyCollector.MatchingType.EXACT);
            this.visitChildrenOf(element);
        } else if (this.getStructureInfo().getPositionInStructure(this.getReferenceStructureItem()) < this.getStructureInfo().getPositionInStructure(elementStructureItem)) {
            this.addElementToCalculated(element.getParent(), PotentialDependencyCollector.MatchingType.EXACT);
        }
    }

    @Override
    public void visitChildrenOf(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitChildrenOf' must not be null";
        if (this.getDomain() == IDomainRoot.Domain.PHYSICAL && !element.hasChildrenRecursively(ProgrammingElement.class)) {
            return;
        }
        if (element.equals(this.getElementForAdditionals())) {
            return;
        }
        if (this.m_stopElements.contains(element) && !this.getElementForAdditionals().hasAsParent(element, false)) {
            return;
        }
        Set<NamedElement> children = this.getRepresentationProvider().getChildrenFromPresentationMode(element, this.getDomain(), this.m_presentationMode, false);
        for (NamedElement next : children) {
            next.accept(this);
        }
    }

    @Override
    protected boolean useMatchingType() {
        return false;
    }
}

