/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.report;

import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlock;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockIssue;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockOccurrence;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricCategory;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.element.DependencyIssue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementIssue;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.report.ModuleReport;
import com.hello2morrow.sonargraph.core.model.report.Report;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.system.ranking.IIssueRankingProvider;
import com.hello2morrow.sonargraph.core.model.system.ranking.IssueRank;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleReportFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleReportFilter.class);

    public static ModuleReport filterByModule(Report report, Module module, int issueRankLimit) {
        assert (report != null) : "Parameter 'report' of method 'filterReportByModule' must not be null";
        assert (module != null) : "Parameter 'module' of method 'filterReportByModule' must not be null";
        ModuleReport moduleReport = new ModuleReport(report, module, report.getReportContextInfo());
        TFile mainReportFile = report.getTargetFile();
        moduleReport.setMainReportTargetFile(mainReportFile);
        String moduleReportFileName = FileUtility.getFileNameWithoutExtension((TFile)mainReportFile) + "_" + module.getName();
        TFile moduleReportFile = new TFile((File)mainReportFile.getParentFile(), moduleReportFileName + FileUtility.getExtension((TFile)mainReportFile));
        moduleReport.setTargetFile(moduleReportFile);
        module.getChildren(RootDirectoryPath.class).stream().forEach(root -> moduleReport.addModuleElement(module, (NamedElement)root));
        report.getLicensedAnalyzers().forEach(a -> moduleReport.addLicensedAnalyzer((IAnalyzerId)a));
        report.getUnlicensedAnalyzers().forEach(a -> moduleReport.addUnlicensedAnalyzer((IAnalyzerId)a));
        moduleReport.addScriptRunnerStatus(report.getScriptRunnerStatus());
        moduleReport.setScriptRunnerConfiguration(report.getScriptRunnerConfiguration());
        report.getAnalyzerPlugins().forEach(pair -> moduleReport.addAnalyzerPlugin((SonargraphPlugin)pair.getFirst(), (IAnalyzerId)pair.getSecond()));
        report.getModelPlugins().forEach(plugin -> moduleReport.addModelPlugin((SonargraphPlugin)plugin));
        Map<IMetricLevel, Map<IMetricCategory, Map<IMetricDescriptor, List<IMetricValue>>>> moduleMetrics = report.getModuleMetrics().get(module);
        if (moduleMetrics != null) {
            for (Map.Entry<IMetricLevel, Map<IMetricCategory, Map<IMetricDescriptor, List<IMetricValue>>>> levelMap : moduleMetrics.entrySet()) {
                IMetricLevel level = levelMap.getKey();
                for (Map.Entry<IMetricCategory, Map<IMetricDescriptor, List<IMetricValue>>> categoryMap : levelMap.getValue().entrySet()) {
                    for (Map.Entry<IMetricDescriptor, List<IMetricValue>> metricMap : categoryMap.getValue().entrySet()) {
                        IMetricDescriptor descriptor = metricMap.getKey();
                        for (IMetricValue value : metricMap.getValue()) {
                            moduleReport.addModuleLevelMetricAndValue(module, level, descriptor, value, value.getAssociatedElement());
                        }
                    }
                }
            }
        } else {
            LOGGER.warn("No metrics exist for module {}", (Object)module);
        }
        Set<NamedElement> moduleElements = report.getModuleElements().get(module);
        HashSet moduleIssues = new HashSet();
        if (moduleElements == null) {
            LOGGER.warn("Module {} contains no elements for report.", (Object)module);
            return moduleReport;
        }
        report.getThresholdViolationIssues().values().stream().flatMap(l -> l.stream()).filter(th -> moduleElements.contains(th.getAffectedElement())).forEach(th -> {
            moduleReport.addElementIssue((NamedElementIssue)th);
            moduleIssues.add(th);
        });
        report.getDependencyIssues().stream().filter(i -> moduleElements.contains(i.getAffectedElement().getUnderlyingFrom())).forEach(d -> {
            moduleReport.addDependencyIssue((DependencyIssue)d);
            moduleIssues.add(d);
        });
        report.getCycleIssues().values().stream().flatMap(l -> l.stream()).filter(c -> c.getAffectedElement().getCyclicNamedElements().stream().anyMatch(e -> moduleElements.contains(e))).forEach(c -> {
            moduleReport.addElementIssue((NamedElementIssue)c);
            moduleIssues.add(c);
        });
        report.getDuplicateIssues().stream().filter(d -> {
            DuplicateCodeBlockIssue duplicateIssue = d;
            DuplicateCodeBlock block = (DuplicateCodeBlock)duplicateIssue.getAffectedElement();
            return block.getChildren(DuplicateCodeBlockOccurrence.class).stream().anyMatch(o -> moduleElements.contains(o.getSourceFile()));
        }).forEach(d -> {
            moduleReport.addElementIssue((NamedElementIssue)d);
            moduleIssues.add(d);
        });
        report.getNamedElementIssues().stream().filter(i -> moduleElements.contains(i.getAffectedElement())).forEach(i -> {
            moduleReport.addElementIssue((NamedElementIssue)i);
            moduleIssues.add(i);
        });
        List<IssueRank> rankings = report.getSoftwareSystem().getExtension(IIssueRankingProvider.class).getRankings();
        ArrayList<IssueRank> moduleRankings = new ArrayList<IssueRank>();
        if (rankings != null) {
            for (IssueRank next : rankings) {
                if (moduleIssues.contains(next.getRankedElement())) {
                    moduleRankings.add(next);
                }
                if (moduleRankings.size() > issueRankLimit) break;
            }
            moduleReport.setIssueRankings(moduleRankings);
        }
        report.getResolutions().stream().filter(r -> r.getAssociatedIssues().stream().anyMatch(i -> moduleIssues.contains(i))).forEach(r -> moduleReport.addResolution((Resolution)r));
        return moduleReport;
    }
}

