/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.StructureModificationVisitor;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class StructureModificationCollector
extends StructureModificationVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(StructureModificationCollector.class);
    private final Map<ArchitecturalViewNode, List<ArchitecturalViewNode>> m_parentToChildren;
    private final Map<ArchitecturalViewNode, ArchitecturalViewNode> m_childToParent;
    private final List<ArchitecturalViewNode> m_nodes;

    StructureModificationCollector(Map<ArchitecturalViewNode, List<ArchitecturalViewNode>> parentToChildren, Map<ArchitecturalViewNode, ArchitecturalViewNode> childToParent, List<ArchitecturalViewNode> nodes) {
        assert (parentToChildren != null) : "Parameter 'parentToChildren' of method 'StructureModificationCollector' must not be null";
        assert (childToParent != null) : "Parameter 'childToParent' of method 'StructureModificationCollector' must not be null";
        assert (nodes != null) : "Parameter 'nodes' of method 'StructureModificationCollector' must not be null";
        this.m_parentToChildren = parentToChildren;
        this.m_childToParent = childToParent;
        this.m_nodes = nodes;
        LOGGER.debug("Created: " + this.getClass().getSimpleName());
    }

    protected boolean include(ArchitecturalViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'include' must not be null";
        return !node.isSuppressed() && ArchitecturalViewElement.NOT_REMOVED.test(node);
    }

    @Override
    public final void visitArchitecturalViewNode(ArchitecturalViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'visitArchitecturalViewNode' must not be null";
        if (this.include(node)) {
            LOGGER.debug("Collect node: " + node.getElementInfo());
            this.m_nodes.add(node);
            ArchitecturalViewNode parent = node.getNodeParent();
            assert (parent == null || !parent.isSuppressed()) : "Either the parent is 'null' or the parent must not be skipped: " + parent.getElementInfo();
            List<ArchitecturalViewNode> children = this.m_parentToChildren.get(parent);
            if (children == null) {
                children = new ArrayList<ArchitecturalViewNode>();
                this.m_parentToChildren.put(parent, children);
            }
            children.add(node);
            this.m_childToParent.put(node, parent);
        } else {
            LOGGER.debug("Do not collect node: " + node.getElementInfo());
        }
        if (node.isSuppressed() || node.isExpanded()) {
            for (ArchitecturalViewNode next : node.getNodeChildren(ArchitecturalViewElement.NOT_REMOVED, false)) {
                next.accept(this);
            }
        }
    }
}

