/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewElementResolver;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewNodeInfo;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewVisitor;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.FocusHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.IExplorationViewRepresentationHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.NodeHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.RepresentationHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.SetPresentationModeVisitor;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewDependencyDescriptor;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewState;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocus;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewSortMode;
import com.hello2morrow.sonargraph.core.model.explorationview.NullArchitecturalViewNode;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StateHandler
implements IExplorationViewRepresentationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(StateHandler.class);

    private StateHandler() {
    }

    public static ArchitecturalViewState createState(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'createState' must not be null";
        LOGGER.debug("Create state");
        ArchitecturalViewState state = new ArchitecturalViewState();
        representation.accept(new StateCollector(state));
        LOGGER.debug("Create state - done");
        return state;
    }

    public static ArchitecturalViewState createOnDemandState(Set<ArchitecturalViewNode> nodes, Set<String> nodeRelPaths, ExplorationViewRepresentation representation) {
        assert (nodes != null) : "Parameter 'nodes' of method 'createOnDemandState' must not be null";
        assert (nodeRelPaths != null) : "Parameter 'nodeRelPaths' of method 'createOnDemandState' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'createOnDemandState' must not be null";
        LOGGER.debug("Create on demand state");
        ArchitecturalViewState state = new ArchitecturalViewState(nodes, nodeRelPaths);
        LOGGER.debug("Create on demand state - done");
        return state;
    }

    static void applyNodesState(ArchitecturalViewState state, IApplyStateListener listener, ExplorationViewRepresentation representation) {
        ArchitecturalViewNode nextNode;
        assert (state != null) : "Parameter 'state' of method 'applyNodesState' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'applyNodesState' must not be null";
        LOGGER.debug("Apply nodes state");
        for (Map.Entry<ArchitecturalViewNode, String> nextEntry : state.getExpanded().entrySet()) {
            nextNode = nextEntry.getKey();
            if (!nextNode.isValid()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Node is not valid trying to resolve: " + nextEntry.getValue());
                }
                nextNode = ArchitecturalViewElementResolver.resolve(nextEntry.getValue(), ArchitecturalViewNode.class, representation, false);
            }
            if (nextNode == null || !nextNode.isVisible() || !nextNode.isExpandable()) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Expanding node: " + nextNode.getRelativePath());
            }
            representation.getCreator().aboutToAccessChildrenOf(nextNode, representation);
            nextNode.setExpanded(true);
        }
        for (Map.Entry<ArchitecturalViewNode, String> nextEntry : state.getSelected().entrySet()) {
            nextNode = nextEntry.getKey();
            if (!nextNode.isValid()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Node is not valid trying to resolve: " + nextEntry.getValue());
                }
                nextNode = ArchitecturalViewElementResolver.resolve(nextEntry.getValue(), ArchitecturalViewNode.class, representation, false);
            }
            if (nextNode == null || !nextNode.canBeShown()) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Selecting node: " + nextNode.getRelativePath());
            }
            NodeHandler.expandParentChainOf(Collections.singletonList(nextNode), true, representation, true);
            if (listener == null) continue;
            listener.selected(nextNode);
        }
        for (String next : state.getSelectedNodeRelPaths()) {
            nextNode = ArchitecturalViewElementResolver.resolve(next, ArchitecturalViewNode.class, representation, false);
            if (nextNode == null || !nextNode.canBeShown()) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Selecting node: " + nextNode.getRelativePath());
            }
            NodeHandler.expandParentChainOf(Collections.singletonList(nextNode), true, representation, true);
            if (listener == null) continue;
            listener.selected(nextNode);
        }
        LOGGER.debug("Apply nodes state - done");
    }

    static void applyDependenciesState(ArchitecturalViewState state, ExplorationViewRepresentation representation) {
        assert (state != null) : "Parameter 'state' of method 'applyDependenciesState' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'applyDependenciesState' must not be null";
        LOGGER.debug("Apply dependencies state");
        for (Map.Entry<StrictPair<ArchitecturalViewNode, ArchitecturalViewNode>, ArchitecturalViewDependencyDescriptor> nextEntry : state.getSelectedDependencies().entrySet()) {
            ArchitecturalViewNode.ArchitecturalViewDependency nextDependency;
            ArchitecturalViewNode nextFrom = (ArchitecturalViewNode)nextEntry.getKey().getFirst();
            ArchitecturalViewNode nextTo = (ArchitecturalViewNode)nextEntry.getKey().getSecond();
            ArchitecturalViewDependencyDescriptor nextDescriptor = nextEntry.getValue();
            if (!nextFrom.isValid()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("From node is not valid trying to resolve: " + nextDescriptor.getFrom());
                }
                nextFrom = ArchitecturalViewElementResolver.resolve(nextDescriptor.getFrom(), ArchitecturalViewNode.class, representation, false);
            }
            if (!nextTo.isValid()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("To node is not valid trying to resolve: " + nextDescriptor.getTo());
                }
                nextTo = ArchitecturalViewElementResolver.resolve(nextDescriptor.getTo(), ArchitecturalViewNode.class, representation, false);
            }
            if (nextFrom == null || nextTo == null || (nextDependency = nextFrom.getOutgoingDependency(nextTo)) == null) continue;
            nextDependency.setSelected(true);
        }
        LOGGER.debug("Apply dependencies state - done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArchitecturalViewNode applyState(ArchitecturalViewState state, PresentationMode presentationMode, ExplorationViewSortMode levelizationMode, ExplorationViewFocus focus, String revealNodeWithRelativePath, ExplorationViewRepresentation representation) {
        assert (state != null) : "Parameter 'state' of method 'applyState' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'applyState' must not be null";
        assert (representation.isValid()) : "Not valid: " + String.valueOf(representation);
        ExplorationViewRepresentation explorationViewRepresentation = representation;
        synchronized (explorationViewRepresentation) {
            LOGGER.debug("Apply state");
            assert (!representation.inModification()) : "Unexpected representation in modification";
            RepresentationHandler.aboutToChangeStructure(false, representation);
            RepresentationHandler.removeAggregatedDependencies(false, representation);
            RepresentationHandler.collapseAll(true, representation);
            if (presentationMode != null || levelizationMode != null || focus != null) {
                ExplorationViewFocus currentlyAppliedFocus = FocusHandler.startOperation(representation);
                if (presentationMode != null || levelizationMode != null) {
                    if (levelizationMode != null) {
                        representation.setSortMode(levelizationMode);
                    }
                    if (presentationMode != null) {
                        representation.accept(new SetPresentationModeVisitor(presentationMode));
                    }
                    ArchitecturalViewNodeInfo nodeInfo = RepresentationHandler.finishElementStructure(representation);
                    RepresentationHandler.sortNodes((IWorkerContext)DefaultWorkerContext.INSTANCE, nodeInfo.getLeafNodes(), representation);
                }
                FocusHandler.finishOperation(focus != null ? focus : currentlyAppliedFocus, representation);
            }
            StateHandler.applyNodesState(state, null, representation);
            RepresentationHandler.createAggregatedDependencies(false, representation);
            StateHandler.applyDependenciesState(state, representation);
            ArchitecturalViewNode resolvedNode = null;
            if (revealNodeWithRelativePath != null) {
                assert (revealNodeWithRelativePath.length() > 0) : "Parameter 'revealNodeWithRelativePath' of method 'applyState' must not be empty";
                resolvedNode = ArchitecturalViewElementResolver.resolve(revealNodeWithRelativePath, ArchitecturalViewNode.class, representation, true);
                if (resolvedNode != null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Node to reveal resolved '" + revealNodeWithRelativePath + "'");
                    }
                    if (resolvedNode.canBeShown() && !resolvedNode.isVisible()) {
                        NodeHandler.expandParentChainOf(Collections.singletonList(resolvedNode), null, representation, false);
                    }
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Node to reveal not resolved '" + revealNodeWithRelativePath + "'");
                }
            }
            RepresentationHandler.structureChanged(false, false, representation);
            LOGGER.debug("Apply state - done");
            return resolvedNode;
        }
    }

    private static ArchitecturalViewNode resolve(Map<String, ArchitecturalViewNode> relPathToNode, String relPath, ExplorationViewRepresentation representation) {
        assert (relPathToNode != null) : "Parameter 'relPathToNode' of method 'resolve' must not be null";
        assert (relPath != null) : "Parameter 'relPath' of method 'resolve' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'resolve' must not be null";
        NullArchitecturalViewNode nullNode = representation.getNullNode();
        ArchitecturalViewNode nextResolved = relPathToNode.get(relPath);
        if (nextResolved == null) {
            nextResolved = ArchitecturalViewElementResolver.resolve(relPath, ArchitecturalViewNode.class, representation, false);
            if (nextResolved != null) {
                relPathToNode.put(relPath, nextResolved);
            } else {
                relPathToNode.put(relPath, nullNode);
                nextResolved = nullNode;
            }
        }
        return nextResolved == nullNode ? null : nextResolved;
    }

    private static ArchitecturalViewState update(Map<String, ArchitecturalViewNode> relPathToNode, ArchitecturalViewState state, ExplorationViewRepresentation representation) {
        ArchitecturalViewNode nextResolved;
        assert (relPathToNode != null) : "Parameter 'relPathToNode' of method 'update' must not be null";
        assert (state != null) : "Parameter 'state' of method 'update' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'update' must not be null";
        ArchitecturalViewState updated = new ArchitecturalViewState();
        for (String next : state.getExpanded().values()) {
            nextResolved = StateHandler.resolve(relPathToNode, next, representation);
            if (nextResolved == null) continue;
            updated.addExpanded(nextResolved);
        }
        for (String next : state.getSelected().values()) {
            nextResolved = StateHandler.resolve(relPathToNode, next, representation);
            if (nextResolved == null) continue;
            updated.addSelected(nextResolved);
        }
        for (String next : state.getSelectedNodeRelPaths()) {
            nextResolved = StateHandler.resolve(relPathToNode, next, representation);
            if (nextResolved == null) continue;
            updated.addSelectedNodeRelPaths(next);
        }
        for (ArchitecturalViewDependencyDescriptor nextDescriptor : state.getSelectedDependencies().values()) {
            ArchitecturalViewNode nextFrom = StateHandler.resolve(relPathToNode, nextDescriptor.getFrom(), representation);
            ArchitecturalViewNode nextTo = StateHandler.resolve(relPathToNode, nextDescriptor.getTo(), representation);
            if (nextFrom == null || nextTo == null) continue;
            updated.addSelectedDependency(nextFrom, nextTo, nextDescriptor.copy());
        }
        return updated;
    }

    public static List<ArchitecturalViewState> updateStates(List<ArchitecturalViewState> states, ExplorationViewRepresentation representation) {
        assert (states != null && !states.isEmpty()) : "Parameter 'states' of method 'updateStates' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'updateStates' must not be null";
        THashMap relPathToNode = new THashMap();
        ArrayList<ArchitecturalViewState> updated = new ArrayList<ArchitecturalViewState>(states.size());
        for (ArchitecturalViewState next : states) {
            updated.add(StateHandler.update((Map<String, ArchitecturalViewNode>)relPathToNode, next, representation));
        }
        return updated;
    }

    public static interface IApplyStateListener {
        public void selected(ArchitecturalViewNode var1);
    }

    private static final class StateCollector
    extends ArchitecturalViewVisitor
    implements ArchitecturalViewNode.IVisitor {
        private final ArchitecturalViewState m_state;

        StateCollector(ArchitecturalViewState state) {
            assert (state != null) : "Parameter 'state' of method 'StateCollector' must not be null";
            this.m_state = state;
        }

        @Override
        public void visitArchitecturalViewNode(ArchitecturalViewNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitArchitecturalViewNode' must not be null";
            boolean processedOrVisitedChildrenOf = false;
            if (element.isVisible()) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Process state of: " + element.getElementInfo());
                }
                this.m_state.process(element);
                processedOrVisitedChildrenOf = true;
            }
            if (element.isRecursive() || element.isExpanded()) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Visit children of: " + element.getElementInfo());
                }
                this.visitChildrenOf(element);
                processedOrVisitedChildrenOf = true;
            }
            if (!processedOrVisitedChildrenOf && LOGGER.isTraceEnabled()) {
                LOGGER.trace("Neither processed nor children visited: " + element.getElementInfo());
            }
        }
    }
}

