/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewVisitor;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.NodeHandler;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocus;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FocusResetVisitor
extends ArchitecturalViewVisitor
implements ArchitecturalViewNode.IVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(FocusResetVisitor.class);
    private final ExplorationViewRepresentation m_representation;

    private FocusResetVisitor(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'FocusResetVisitor' must not be null";
        this.m_representation = representation;
    }

    @Override
    public void visitArchitecturalViewNode(ArchitecturalViewNode element) {
        assert (element != null) : "Parameter 'element' of method 'visitArchitecturalViewNode' must not be null";
        element.setRemovedByFocus(false);
        element.setHasPartialElements(false);
        element.setHasPartialDependencies(false);
        this.visitChildrenOf(element);
        NodeHandler.updateExpandableState(element, this.m_representation);
        if (!element.isExpandable()) {
            element.setExpanded(false);
        }
    }

    static ExplorationViewFocus reset(boolean resetExistingFocus, ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'reset' must not be null";
        ExplorationViewFocus focus = representation.getFocus();
        if (!focus.isEmpty()) {
            LOGGER.debug("Reset focus" + (resetExistingFocus ? " [resetting existing]" : " [not resetting existing]"));
            if (resetExistingFocus) {
                representation.resetFocus();
            }
            representation.accept(new FocusResetVisitor(representation));
            LOGGER.debug("Reset focus" + (resetExistingFocus ? " [resetting existing]" : " [not resetting existing]") + " - done");
        }
        LOGGER.debug("No need to reset empty focus");
        return focus;
    }
}

