/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewVisitor;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitectureFilterNameCollector;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArtifactNodeQualifiedNameSupport;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitecturalModelProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNodeFilter;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableNode;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableToArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.IAssignableTarget;
import com.hello2morrow.sonargraph.core.model.explorationview.PatternFilterExclude;
import com.hello2morrow.sonargraph.core.model.explorationview.PatternFilterInclude;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArchitectureFileGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchitectureFileGenerator.class);
    private static final String LINE_BREAK = "\n";
    private static final String IDENT = "    ";
    private static final String BLANK = " ";
    private static final String COMMA = ",";
    private static final String COLON = ":";
    private static final String QUOTATION_MARK = "\"";
    private static final String LINE_COMMENT = "//";
    private static final String GENERATED_FROM = "Generated from";
    private static final String DESCRIPTION = "Description";
    private static final String MODEL = "model";
    private static final String ARTIFACT = "artifact";
    private static final String EXPOSED = "exposed";
    private static final String INCLUDE = "include";
    private static final String EXCLUDE = "exclude";
    private static final String STARSTAR = "**";
    private static final String INTERFACE = "interface";
    private static final String DEFAULT = "default";
    private static final String CONNECT_TO = "connect to";
    private static final String CURLY_BRACKET_OPEN = "{";
    private static final String CURLY_BRACKET_CLOSE = "}";
    private final ArchitectureFileGeneratorInfoCollector m_infoCollector = new ArchitectureFileGeneratorInfoCollector();
    private final ArtifactNodeFilterIncludePatternCollector m_includePatternsCollector = new ArtifactNodeFilterIncludePatternCollector(this.m_infoCollector);
    private final HiddenAssignablesArchitectureFilterNameCollector m_hiddenCollector = new HiddenAssignablesArchitectureFilterNameCollector(this.m_infoCollector);

    public static boolean isGenerationPossible(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'isGenerationPossible' must not be null";
        return !representation.getChildren(ArtifactNode.class).isEmpty();
    }

    private Collection<String> getArchitectureFilterNamesOfHiddenAssignables(ArtifactNode artifactNode) {
        assert (artifactNode != null) : "Parameter 'artifactNode' of method 'getArchitectureFilterNamesOfHiddenAssignables' must not be null";
        if (artifactNode.hasHiddenElements()) {
            artifactNode.getChildren(AssignableNode.class).forEach(a -> a.accept(this.m_hiddenCollector));
            return this.m_hiddenCollector.consumeArchitectureFilterNames();
        }
        return Collections.emptySet();
    }

    private StringBuilder indent(int identation, StringBuilder builder) {
        assert (identation >= 0) : "'identation' must not be negative";
        assert (builder != null) : "Parameter 'builder' of method 'indent' must not be null";
        int i = 0;
        while (i < identation) {
            builder.append(IDENT);
            ++i;
        }
        return builder;
    }

    private void addHeader(StringBuilder builder, String source, String description, ExplorationViewRepresentation representation) {
        assert (builder != null) : "Parameter 'builder' of method 'addHeader' must not be null";
        assert (source != null && source.length() > 0) : "Parameter 'source' of method 'addHeader' must not be empty";
        assert (description != null) : "Parameter 'description' of method 'addHeader' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'addHeader' must not be null";
        builder.append(LINE_COMMENT).append(GENERATED_FROM).append(" '").append(source).append("' on ").append(Iso8601DateFormat.formatDateAndTime((Date)new Date(System.currentTimeMillis()))).append(LINE_BREAK);
        if (!description.isEmpty()) {
            builder.append(LINE_COMMENT).append(DESCRIPTION).append(COLON).append(BLANK).append(description).append(LINE_BREAK);
        }
        builder.append(LINE_BREAK);
        if (representation.getStructureMode().isPhysical()) {
            builder.append(MODEL).append(BLANK).append(QUOTATION_MARK).append(IArchitecturalModelProvider.ArchitectureModel.PHYSICAL.getStandardName()).append(QUOTATION_MARK);
        } else {
            builder.append(MODEL).append(BLANK).append(QUOTATION_MARK).append(IArchitecturalModelProvider.ArchitectureModel.LOGICAL.getStandardName()).append(QUOTATION_MARK);
        }
    }

    private void addArtifact(ArtifactNode artifactNode, int indentation, boolean isFirstNestedArtifact, StringBuilder builder) {
        List<ArtifactNode> list;
        Collection<String> hidden;
        assert (artifactNode != null) : "Parameter 'artifactNode' of method 'addArtifact' must not be null";
        assert (builder != null) : "Parameter 'builder' of method 'addArtifact' must not be null";
        builder.append(LINE_BREAK);
        if (!isFirstNestedArtifact) {
            builder.append(LINE_BREAK);
        }
        this.indent(indentation, builder);
        String keyword = artifactNode.getIncomingDependencyMode().getKeyword();
        if (keyword != null) {
            assert (keyword.length() > 0) : "'keyword' of method 'addArtifact' must not be empty";
            builder.append(keyword).append(BLANK);
        }
        artifactNode.getVisibility().forEach(v -> {
            StringBuilder stringBuilder2 = builder.append(v.getKeyword()).append(BLANK);
        });
        keyword = artifactNode.getOutgoingDependencyMode().getKeyword();
        if (keyword != null) {
            assert (keyword.length() > 0) : "'keyword' of method 'addArtifact' must not be empty";
            builder.append(keyword).append(BLANK);
        }
        if ((keyword = artifactNode.getAssignmentMode().getKeyword()) != null) {
            assert (keyword.length() > 0) : "'keyword' of method 'addArtifact' must not be empty";
            builder.append(keyword).append(BLANK);
        }
        if (this.m_infoCollector.needsToBeExposed(artifactNode)) {
            builder.append(EXPOSED).append(BLANK);
        }
        builder.append(ARTIFACT).append(BLANK).append(artifactNode.getShortName()).append(LINE_BREAK);
        this.indent(indentation, builder).append(CURLY_BRACKET_OPEN);
        List<PatternFilterInclude> includePatterns = artifactNode.getFilter().getChildren(PatternFilterInclude.class);
        for (PatternFilterInclude next : includePatterns) {
            builder.append(LINE_BREAK);
            this.indent(indentation + 1, builder).append(INCLUDE).append(BLANK).append(QUOTATION_MARK).append(next.getName()).append(QUOTATION_MARK);
        }
        List<PatternFilterExclude> excludePatterns = artifactNode.getFilter().getChildren(PatternFilterExclude.class);
        for (PatternFilterExclude next : excludePatterns) {
            builder.append(LINE_BREAK);
            this.indent(indentation + 1, builder).append(EXCLUDE).append(BLANK).append(QUOTATION_MARK).append(next.getName()).append(QUOTATION_MARK);
        }
        List<ArtifactNode> artifactNodeChildren = artifactNode.getChildren(ArtifactNode.class);
        if (!artifactNodeChildren.isEmpty()) {
            if (!includePatterns.isEmpty() || !excludePatterns.isEmpty()) {
                builder.append(LINE_BREAK);
            }
            boolean isFirstNested = true;
            for (ArtifactNode artifactNode2 : artifactNodeChildren) {
                this.addArtifact(artifactNode2, indentation + 1, isFirstNested, builder);
                isFirstNested = false;
            }
        }
        if (!(hidden = this.getArchitectureFilterNamesOfHiddenAssignables(artifactNode)).isEmpty()) {
            builder.append(LINE_BREAK);
            if (!(includePatterns.isEmpty() && excludePatterns.isEmpty() && artifactNodeChildren.isEmpty())) {
                builder.append(LINE_BREAK);
            }
            this.indent(indentation + 1, builder).append(INTERFACE).append(BLANK).append(DEFAULT).append(LINE_BREAK);
            this.indent(indentation + 1, builder).append(CURLY_BRACKET_OPEN).append(LINE_BREAK);
            this.indent(indentation + 2, builder).append(INCLUDE).append(BLANK).append(QUOTATION_MARK).append(STARSTAR).append(QUOTATION_MARK);
            for (String string : hidden) {
                builder.append(LINE_BREAK);
                this.indent(indentation + 2, builder).append(EXCLUDE).append(BLANK).append(QUOTATION_MARK).append(string).append(QUOTATION_MARK);
            }
            builder.append(LINE_BREAK);
            this.indent(indentation + 1, builder).append(CURLY_BRACKET_CLOSE);
        }
        if (!(list = artifactNode.getAllowed()).isEmpty()) {
            builder.append(LINE_BREAK);
            if (!(includePatterns.isEmpty() && excludePatterns.isEmpty() && artifactNodeChildren.isEmpty() && hidden.isEmpty())) {
                builder.append(LINE_BREAK);
            }
            this.indent(indentation + 1, builder).append(CONNECT_TO).append(BLANK);
            boolean addSeparator = false;
            for (ArtifactNode nextAllowed : list) {
                if (addSeparator) {
                    builder.append(COMMA).append(BLANK);
                }
                builder.append(this.m_infoCollector.getConnectToName(artifactNode, nextAllowed));
                addSeparator = true;
            }
        }
        builder.append(LINE_BREAK);
        this.indent(indentation, builder).append(CURLY_BRACKET_CLOSE);
    }

    private static void processArtifactFilter(ArtifactNode artifact, String info, Set<String> includePatterns, ArtifactNodeFilter.PatternKind patternKind, Set<ArtifactNode> modifiedManualArtifacts, ExplorationViewRepresentation representation) {
        assert (artifact != null) : "Parameter 'artifact' of method 'processArtifactFilter' must not be null";
        assert (info != null && info.length() > 0) : "Parameter 'info' of method 'processArtifactFilter' must not be empty";
        assert (includePatterns != null) : "Parameter 'includePatterns' of method 'processArtifactFilter' must not be null";
        assert (patternKind != null) : "Parameter 'patternKind' of method 'processArtifactFilter' must not be null";
        assert (modifiedManualArtifacts != null) : "Parameter 'modifiedManualArtifacts' of method 'processArtifactFilter' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'processArtifactFilter' must not be null";
        if (artifact.hasManualFilter()) {
            LOGGER.debug("Processing " + info + " '" + artifact.getName() + "'");
            ArtifactNodeFilter filter = artifact.getFilter();
            boolean filterModified = false;
            switch (patternKind) {
                case EXCLUDE: {
                    for (String next : includePatterns) {
                        if (!filter.needsToBeAdded(next, ArtifactNodeFilter.PatternKind.EXCLUDE)) continue;
                        filter.addChild(new PatternFilterExclude((NamedElement)filter, representation.getAttributeRetriever(representation.getDefaultRetrieverName()), next, next, false, null, false));
                        filterModified = true;
                    }
                    break;
                }
                case INCLUDE: {
                    for (String next : includePatterns) {
                        if (!filter.needsToBeAdded(next, ArtifactNodeFilter.PatternKind.INCLUDE)) continue;
                        filter.addChild(new PatternFilterInclude((NamedElement)filter, representation.getAttributeRetriever(representation.getDefaultRetrieverName()), next, next, false, null, false));
                        filterModified = true;
                    }
                    break;
                }
                default: {
                    assert (false) : "Unhandled pattern kind: " + String.valueOf((Object)patternKind);
                    break;
                }
            }
            if (filterModified) {
                modifiedManualArtifacts.add(artifact);
            }
        }
    }

    private static void processAffectedManualFilterArtifacts(ArtifactNode automaticFilterArtifact, Set<String> includePatterns, Set<ArtifactNode> modifiedManualArtifacts, ExplorationViewRepresentation representation) {
        assert (automaticFilterArtifact != null) : "Parameter 'automaticFilterArtifact' of method 'processAffectedManualFilterArtifacts' must not be null";
        assert (includePatterns != null) : "Parameter 'includePatterns' of method 'processAffectedManualFilterArtifacts' must not be null";
        assert (modifiedManualArtifacts != null) : "Parameter 'modifiedManualArtifacts' of method 'processAffectedManualFilterArtifacts' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'processAffectedManualFilterArtifacts' must not be null";
        LOGGER.debug("Processing automatic filter artifact '" + automaticFilterArtifact.getName() + "'");
        IAssignableTarget parent = automaticFilterArtifact.getParent(IAssignableTarget.class, ParentMode.ONLY_DIRECT_PARENT);
        assert (parent != null) : "Parameter 'parent' of method 'processAffectedManualFilterArtifacts' must not be null";
        List<ArtifactNode> children = parent.getArchitecturalViewElement().getChildren(ArtifactNode.class);
        for (ArtifactNode nextSibling : children) {
            if (nextSibling == automaticFilterArtifact) break;
            ArchitectureFileGenerator.processArtifactFilter(nextSibling, "leading manual artifact sibling", includePatterns, ArtifactNodeFilter.PatternKind.EXCLUDE, modifiedManualArtifacts, representation);
        }
        List<ArtifactNode> parents = automaticFilterArtifact.getParents(ArtifactNode.class, ExplorationViewRepresentation.class);
        for (ArtifactNode nextParent : parents) {
            ArchitectureFileGenerator.processArtifactFilter(nextParent, "manual artifact parent", includePatterns, ArtifactNodeFilter.PatternKind.INCLUDE, modifiedManualArtifacts, representation);
        }
        LOGGER.debug("Processing automatic filter artifact '" + automaticFilterArtifact.getName() + "' - done");
    }

    public void generate(IWorkerContext workerContext, TFile targetFile, String source, String description, ExplorationViewRepresentation representation, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'generate' must not be null";
        assert (targetFile != null) : "Parameter 'targetFile' of method 'generate' must not be null";
        assert (source != null && source.length() > 0) : "Parameter 'source' of method 'generate' must not be empty";
        assert (description != null) : "Parameter 'description' of method 'generate' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'generate' must not be null";
        assert (result != null) : "Parameter 'result' of method 'generate' must not be null";
        workerContext.working("Generating architecture file", true);
        LOGGER.debug("Generating architecture file '" + targetFile.getAbsolutePath() + "'");
        StringBuilder builder = new StringBuilder();
        this.addHeader(builder, source, description, representation);
        List<ArtifactNode> topLevelArtifacts = representation.getChildren(ArtifactNode.class);
        if (!topLevelArtifacts.isEmpty()) {
            LOGGER.debug("Collect generation info");
            representation.accept(this.m_infoCollector);
            representation.accept(this.m_includePatternsCollector);
            LOGGER.debug("Collect generation info - done");
            LOGGER.debug("Complete artifact filter patterns");
            THashSet modifiedManualArtifacts = new THashSet();
            Map<ArtifactNode, FilterNamesEntry> automaticArtifactToArchitectureFilterNames = this.m_includePatternsCollector.getArchitectureFilterNames();
            for (Map.Entry<ArtifactNode, FilterNamesEntry> nextEntry : automaticArtifactToArchitectureFilterNames.entrySet()) {
                ArtifactNode nextArtifact = nextEntry.getKey();
                assert (!nextArtifact.hasManualFilter()) : "Has manual filter: " + String.valueOf(nextArtifact);
                ArtifactNodeFilter nextFilter = nextArtifact.getFilter();
                nextFilter.clear(false);
                FilterNamesEntry nextFilterNamesEntry = nextEntry.getValue();
                Set<String> nextIncludePatterns = nextFilterNamesEntry.getFilterNames();
                if (nextFilterNamesEntry.containsAssignedElements()) {
                    for (String next : nextIncludePatterns) {
                        nextFilter.addChild(new PatternFilterInclude((NamedElement)nextFilter, representation.getAttributeRetriever(representation.getDefaultRetrieverName()), next, next, false, null, false));
                    }
                }
                ArchitectureFileGenerator.processAffectedManualFilterArtifacts(nextArtifact, nextIncludePatterns, (Set<ArtifactNode>)modifiedManualArtifacts, representation);
            }
            LOGGER.debug("Complete artifact filter patterns - done");
            LOGGER.debug("Write artifacts");
            topLevelArtifacts.forEach(a -> this.addArtifact((ArtifactNode)a, 0, false, builder));
            LOGGER.debug("Write artifacts - done");
            LOGGER.debug("Reset created info");
            automaticArtifactToArchitectureFilterNames.keySet().forEach(a -> a.getFilter().clear(false));
            modifiedManualArtifacts.forEach(m -> m.getFilter().clear(true));
            this.m_infoCollector.reset();
            this.m_includePatternsCollector.reset();
            this.m_hiddenCollector.reset();
            LOGGER.debug("Reset created info - done");
        }
        try {
            LOGGER.debug("Write file");
            Files.write(Paths.get(targetFile.getAbsolutePath(), new String[0]), builder.toString().getBytes(), new OpenOption[0]);
            LOGGER.debug("Write file - done");
        }
        catch (IOException e) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_WRITE_FILE, (Throwable)e);
        }
        LOGGER.debug("Generating architecture file '" + targetFile.getAbsolutePath() + "' - done");
    }

    static final class ArchitectureFileGeneratorInfoCollector
    extends ReferenceCountCalculator
    implements ArtifactNode.IVisitor {
        private final Set<ArtifactNode> m_toBeExposedArtifacts = new THashSet();
        private final Map<ArtifactNode, Map<ArtifactNode, String>> m_fromArtifactToConnectToName = new THashMap();

        ArchitectureFileGeneratorInfoCollector() {
        }

        private void addConnectToName(ArtifactNode from, ArtifactNode to, String name) {
            assert (from != null) : "Parameter 'from' of method 'addConnectToName' must not be null";
            assert (to != null) : "Parameter 'to' of method 'addConnectToName' must not be null";
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'addConnectToName' must not be empty";
            assert (from != to) : "Same instances";
            THashMap connectsToName = this.m_fromArtifactToConnectToName.get(from);
            if (connectsToName == null) {
                connectsToName = new THashMap();
                this.m_fromArtifactToConnectToName.put(from, (Map<ArtifactNode, String>)connectsToName);
            }
            connectsToName.put(to, name);
        }

        @Override
        public void visitArtifactNode(ArtifactNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitArtifactNode' must not be null";
            List<ArtifactNode> allowed = element.getAllowed();
            if (!allowed.isEmpty()) {
                List<ArtifactNode> elementParents = element.getParents(ArtifactNode.class, ExplorationViewRepresentation.class);
                Collections.reverse(elementParents);
                for (ArtifactNode nextAllowed : allowed) {
                    List<ArtifactNode> nextAllowedParents = nextAllowed.getParents(ArtifactNode.class, ExplorationViewRepresentation.class);
                    Collections.reverse(nextAllowedParents);
                    String nextQualifiedName = ArtifactNodeQualifiedNameSupport.getQualifiedName(elementParents, nextAllowedParents, nextAllowed, this.m_toBeExposedArtifacts);
                    this.addConnectToName(element, nextAllowed, nextQualifiedName);
                }
            }
            super.visitArchitecturalViewElement(element);
        }

        @Override
        void reset() {
            super.reset();
            this.m_toBeExposedArtifacts.clear();
            this.m_fromArtifactToConnectToName.clear();
        }

        boolean needsToBeExposed(ArtifactNode artifactNode) {
            assert (artifactNode != null) : "Parameter 'artifactNode' of method 'needsToBeExposed' must not be null";
            return this.m_toBeExposedArtifacts.contains(artifactNode);
        }

        String getConnectToName(ArtifactNode from, ArtifactNode to) {
            assert (from != null) : "Parameter 'from' of method 'getConnectToName' must not be null";
            assert (to != null) : "Parameter 'to' of method 'getConnectToName' must not be null";
            assert (from != to) : "Same instances";
            Map<ArtifactNode, String> connectToName = this.m_fromArtifactToConnectToName.get(from);
            assert (connectToName != null) : "'connectToName' of method 'getConnectToName' must not be null";
            String name = connectToName.get(to);
            assert (name != null && name.length() > 0) : "'name' of method 'getConnectToName' must not be empty";
            return name;
        }
    }

    private static final class ArtifactNodeFilterIncludePatternCollector
    extends ArchitectureFilterNameCollector
    implements ExplorationViewRepresentation.IVisitor,
    ArtifactNode.IVisitor {
        private final Map<ArtifactNode, FilterNamesEntry> m_automaticArtifactToFilterNames = new LinkedHashMap<ArtifactNode, FilterNamesEntry>();
        private final Deque<ArtifactNode> m_stack = new ArrayDeque<ArtifactNode>();

        ArtifactNodeFilterIncludePatternCollector(ArchitectureFilterNameCollector.IReferenceCountProvider provider) {
            super(provider);
        }

        void reset() {
            this.m_automaticArtifactToFilterNames.clear();
            this.m_stack.clear();
        }

        @Override
        protected void reachedNonRecursiveLeafNode(AssignableToArtifactNode element, boolean match) {
            assert (element != null) : "Parameter 'element' of method 'reachedNonRecursiveLeafNode' must not be null";
            assert (match) : "Must be a match: " + element.getElementInfo();
        }

        @Override
        public void visitExplorationViewRepresentation(ExplorationViewRepresentation element) {
            assert (element != null) : "Parameter 'element' of method 'visitArchitecturalViewRepresentation' must not be null";
            this.visitChildrenOf(element);
        }

        @Override
        public void visitArtifactNode(ArtifactNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitArtifactNode' must not be null";
            if (!element.hasManualFilter()) {
                this.m_stack.push(element);
                this.visitChildrenOf(element);
                if (!this.m_automaticArtifactToFilterNames.containsKey(element)) {
                    this.m_automaticArtifactToFilterNames.put(element, new FilterNamesEntry());
                }
                this.m_stack.pop();
            } else {
                this.visitChildrenOf(element);
            }
        }

        @Override
        protected void process(Set<String> architectureFilterNames) {
            assert (architectureFilterNames != null && !architectureFilterNames.isEmpty()) : "Parameter 'architectureFilterNames' of method 'process' must not be empty";
            if (!this.m_stack.isEmpty()) {
                boolean isFirst = true;
                for (ArtifactNode nextAutomaticArtifact : this.m_stack) {
                    assert (!nextAutomaticArtifact.hasManualFilter()) : "Has manual filter: " + String.valueOf(nextAutomaticArtifact);
                    FilterNamesEntry assigned = this.m_automaticArtifactToFilterNames.get(nextAutomaticArtifact);
                    if (assigned == null) {
                        assigned = new FilterNamesEntry();
                        this.m_automaticArtifactToFilterNames.put(nextAutomaticArtifact, assigned);
                    }
                    if (isFirst) {
                        assigned.setContainsAssignedElements(true);
                        isFirst = false;
                    }
                    assigned.addFilterNames(architectureFilterNames);
                }
            }
        }

        Map<ArtifactNode, FilterNamesEntry> getArchitectureFilterNames() {
            return Collections.unmodifiableMap(this.m_automaticArtifactToFilterNames);
        }
    }

    private static final class FilterNamesEntry {
        private Set<String> m_filterNames;
        private boolean m_containsAssignedElements;

        FilterNamesEntry() {
        }

        void addFilterNames(Set<String> filterNames) {
            assert (filterNames != null && !filterNames.isEmpty()) : "Parameter 'filterNames' of method 'addFilterNames' must not be empty";
            if (this.m_filterNames == null) {
                this.m_filterNames = new TreeSet<String>();
            }
            this.m_filterNames.addAll(filterNames);
        }

        Set<String> getFilterNames() {
            return this.m_filterNames == null ? Collections.emptySet() : Collections.unmodifiableSet(this.m_filterNames);
        }

        void setContainsAssignedElements(boolean contains) {
            this.m_containsAssignedElements = contains;
        }

        boolean containsAssignedElements() {
            return this.m_containsAssignedElements;
        }
    }

    static final class HiddenAssignablesArchitectureFilterNameCollector
    extends ArchitectureFilterNameCollector {
        private Set<String> m_architectureFilterNames = new TreeSet<String>();

        HiddenAssignablesArchitectureFilterNameCollector(ArchitectureFilterNameCollector.IReferenceCountProvider provider) {
            super(provider);
        }

        void reset() {
            this.m_architectureFilterNames.clear();
        }

        @Override
        protected boolean skipAssignableNode(AssignableNode assignableNode) {
            assert (assignableNode != null) : "Parameter 'assignableNode' of method 'skipAssignableNode' must not be null";
            return super.skipAssignableNode(assignableNode) || !assignableNode.isHidden();
        }

        @Override
        protected final void process(Set<String> architectureFilterNames) {
            assert (architectureFilterNames != null && !architectureFilterNames.isEmpty()) : "Parameter 'architectureFilterNames' of method 'process' must not be empty";
            this.m_architectureFilterNames.addAll(architectureFilterNames);
        }

        final Set<String> consumeArchitectureFilterNames() {
            Set<String> consume = this.m_architectureFilterNames;
            this.m_architectureFilterNames = new TreeSet<String>();
            return Collections.unmodifiableSet(consume);
        }
    }

    static abstract class ReferenceCountCalculator
    extends ArchitecturalViewVisitor
    implements AssignableNode.IVisitor,
    AssignableToArtifactNode.IVisitor,
    ArchitectureFilterNameCollector.IReferenceCountProvider {
        private final Map<NamedElement, ReferenceCounter> m_elementToRefCount = new THashMap();

        ReferenceCountCalculator() {
        }

        private void processAssignableNode(AssignableNode assignableNode) {
            assert (assignableNode != null) : "Parameter 'assignableNode' of method 'processAssignableNode' must not be null";
            for (NamedElement next : assignableNode.getUnderlyingElements()) {
                ReferenceCounter nextRefCount = this.m_elementToRefCount.get(next);
                if (nextRefCount == null) {
                    nextRefCount = new ReferenceCounter();
                    this.m_elementToRefCount.put(next, nextRefCount);
                }
                nextRefCount.increment();
            }
        }

        @Override
        public final void visitAssignableNode(AssignableNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitArtifactNode' must not be null";
            this.processAssignableNode(element);
            this.visitChildrenOf(element);
        }

        @Override
        public final void visitAssignableToArtifactNode(AssignableToArtifactNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitNonRecursiveLeafNode' must not be null";
            this.processAssignableNode(element);
        }

        void reset() {
            this.m_elementToRefCount.clear();
        }

        @Override
        public final int getReferenceCount(NamedElement element) {
            assert (element != null) : "Parameter 'element' of method 'getReferenceCount' must not be null";
            ReferenceCounter counter = this.m_elementToRefCount.get(element);
            assert (counter != null) : "'counter' of method 'getReferenceCount' must not be null";
            return counter.getCount();
        }

        static final class ReferenceCounter {
            private int m_count;

            ReferenceCounter() {
            }

            void increment() {
                ++this.m_count;
            }

            int getCount() {
                assert (this.m_count > 0) : "'m_count' must be greater that 0";
                return this.m_count;
            }
        }
    }
}

