/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.List;

public final class ArchitecturalViewNameValidator
implements ITextValidator {
    private final List<ArchitecturalViewFile> m_available;

    public ArchitecturalViewNameValidator(List<ArchitecturalViewFile> available) {
        assert (available != null) : "Parameter 'available' of method 'ArchitecturalViewNameValidator' must not be null";
        this.m_available = available;
    }

    @Override
    public ValidationResult isValid(String currentInput, String newInput) {
        ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
        if (!FileUtility.isValidName((String)newInput)) {
            result.addError("Architectural view name is not valid");
        }
        if (newInput.endsWith(CoreFileType.ARCHITECTURAL_VIEW.getDefaultExtension())) {
            result.addError("Architectural view name needs to be specified without file extension");
        }
        String newName = "./" + newInput + CoreFileType.ARCHITECTURAL_VIEW.getDefaultExtension();
        for (ArchitecturalViewFile next : this.m_available) {
            if (!next.getName().equalsIgnoreCase(newName)) continue;
            result.addError("Architectural view with name '" + newInput + "' already exists");
            break;
        }
        return result;
    }
}

