/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.sonargraph.core.model.common.SonargraphProduct;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineInfo;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineType;
import com.hello2morrow.sonargraph.core.persistence.diff.BaselineReader;
import com.hello2morrow.sonargraph.core.persistence.system.SystemPropertiesPersistenceProvider;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.PersistentRecentlyUsedList;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentDiffInfoHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistentDiffInfoHandler.class);
    private static final String SYSTEM_BASELINES_RECENTLY_USED_LIST_NAME = "baselines.rud";
    private static final String LOCAL_BASELINES_RECENTLY_USED_LIST_NAME = "localBaselines.rud";
    private static final String PROPERTY_LOCAL_BASELINE_PATH = "localBaselinePath";
    private static final String PROPERTY_USE_LOCAL_BASELINE = "useLocalBaseline";
    private final PersistentRecentlyUsedList m_recentlyUsedSystemBaselinesList;
    private final PersistentRecentlyUsedList m_recentlyUsedLocalBaselinesList;
    private final SoftwareSystem m_softwareSystem;
    private StrictPair<TFile, Boolean> m_localBaseline;
    private final boolean m_usePersistence;

    private static PersistentRecentlyUsedList initRecentlyUsedList(TFile baselinesDirectory, String fileName) {
        assert (baselinesDirectory != null) : "Parameter 'baselinesDirectory' of method 'initRecentlyUsedList' must not be null";
        assert (fileName != null && fileName.length() > 0) : "Parameter 'fileName' of method 'initRecentlyUsedList' must not be empty";
        PersistentRecentlyUsedList recentlyUsedList = new PersistentRecentlyUsedList(new TFile((File)baselinesDirectory, fileName).getAbsolutePath(), 20);
        if (recentlyUsedList.getNumberOfEntries() > 0) {
            List allEntries = recentlyUsedList.getAll();
            ArrayList<String> toBeRemoved = new ArrayList<String>(allEntries.size());
            ArrayList<TFile> allValidPathsAsFiles = new ArrayList<TFile>(allEntries.size());
            for (String nextPath : allEntries) {
                if (!nextPath.endsWith(CoreFileType.REPORT_XML.getDefaultExtension())) {
                    toBeRemoved.add(nextPath);
                    continue;
                }
                boolean isDuplicate = false;
                TFile nextPathAsFile = new TFile(nextPath);
                for (TFile nextAlreadyAddedPathAsFile : allValidPathsAsFiles) {
                    if (!FileUtility.areEqual((TFile)nextPathAsFile, (TFile)nextAlreadyAddedPathAsFile)) continue;
                    isDuplicate = true;
                    break;
                }
                if (isDuplicate) {
                    toBeRemoved.add(nextPath);
                    continue;
                }
                allValidPathsAsFiles.add(nextPathAsFile);
            }
            toBeRemoved.forEach(r -> recentlyUsedList.remove(r));
        }
        return recentlyUsedList;
    }

    private static TFile getHiddenBaselinesDirectory(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'getHiddenBaselinesDirectory' must not be null";
        TFile hiddenDataDirectory = softwareSystem.getUniqueExistingChild(Files.class).getHiddenDataDirectory();
        TFile baselinesDirectory = new TFile((File)hiddenDataDirectory, "baselines");
        baselinesDirectory.mkdir();
        return baselinesDirectory;
    }

    public PersistentDiffInfoHandler(SoftwareSystem softwareSystem, SonargraphProduct product) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'PersistentDiffInfoHandler' must not be null";
        assert (product != null) : "Parameter 'product' of method 'PersistentDiffInfoHandler' must not be null";
        this.m_softwareSystem = softwareSystem;
        if (SonargraphProduct.SONARGRAPH_BUILD.equals((Object)product)) {
            LOGGER.info("Baseline info (system properties and recently used) are not persisted for '" + String.valueOf((Object)product) + "'");
            this.m_recentlyUsedSystemBaselinesList = null;
            this.m_recentlyUsedLocalBaselinesList = null;
            this.m_usePersistence = false;
        } else {
            TFile baselinesDirectory = PersistentDiffInfoHandler.getHiddenBaselinesDirectory(softwareSystem);
            this.m_recentlyUsedSystemBaselinesList = PersistentDiffInfoHandler.initRecentlyUsedList(baselinesDirectory, SYSTEM_BASELINES_RECENTLY_USED_LIST_NAME);
            this.m_recentlyUsedLocalBaselinesList = PersistentDiffInfoHandler.initRecentlyUsedList(baselinesDirectory, LOCAL_BASELINES_RECENTLY_USED_LIST_NAME);
            this.m_usePersistence = true;
        }
    }

    public TFile getHiddenBaselinesDirectory() {
        return PersistentDiffInfoHandler.getHiddenBaselinesDirectory(this.m_softwareSystem);
    }

    public StrictPair<TFile, Boolean> getLocalBaselineInfo(TFile baseDirectory) {
        assert (baseDirectory != null) : "Parameter 'baseDirectory' of method 'getLocalBaselineInfo' must not be null";
        if (this.m_usePersistence) {
            String trimmedLocalBaselinePathValue;
            Boolean useLocalBaseline;
            String localBaselinePathValue = this.m_softwareSystem.getSystemProperty(PROPERTY_LOCAL_BASELINE_PATH);
            String useLocalBaselineValue = this.m_softwareSystem.getSystemProperty(PROPERTY_USE_LOCAL_BASELINE);
            Boolean bl = useLocalBaseline = useLocalBaselineValue == null ? Boolean.FALSE : Boolean.valueOf(useLocalBaselineValue);
            if (localBaselinePathValue != null && !(trimmedLocalBaselinePathValue = localBaselinePathValue.trim()).isEmpty()) {
                if (FileUtility.isRelativePath((String)trimmedLocalBaselinePathValue)) {
                    return new StrictPair((Object)new TFile((File)baseDirectory, trimmedLocalBaselinePathValue), (Object)useLocalBaseline);
                }
                return new StrictPair((Object)new TFile(trimmedLocalBaselinePathValue), (Object)useLocalBaseline);
            }
            if (useLocalBaseline.booleanValue()) {
                LOGGER.error("Local baseline is enabled but no path is specified");
            }
        } else if (this.m_localBaseline != null) {
            LOGGER.info("Get local baseline (no persistence): " + FileUtility.getCanonicalFilePath((TFile)((TFile)this.m_localBaseline.getFirst())));
            return this.m_localBaseline;
        }
        return null;
    }

    public String getLocalBaselinePath() {
        if (this.m_usePersistence) {
            String localBaselinePath = this.m_softwareSystem.getSystemProperty(PROPERTY_LOCAL_BASELINE_PATH);
            return localBaselinePath == null ? "" : localBaselinePath.trim();
        }
        if (this.m_localBaseline != null) {
            return FileUtility.getCanonicalFilePath((TFile)((TFile)this.m_localBaseline.getFirst()));
        }
        return "";
    }

    public boolean isLocalBaselineEnabled() {
        if (this.m_usePersistence) {
            String useLocalBaselineValue = this.m_softwareSystem.getSystemProperty(PROPERTY_USE_LOCAL_BASELINE);
            return useLocalBaselineValue != null ? Boolean.valueOf(useLocalBaselineValue) : false;
        }
        if (this.m_localBaseline != null) {
            return (Boolean)this.m_localBaseline.getSecond();
        }
        return false;
    }

    public void deleted(TFile baseline, OperationResult result) {
        assert (baseline != null) : "Parameter 'baseline' of method 'deleted' must not be null";
        assert (result != null) : "Parameter 'result' of method 'deleted' must not be null";
        if (this.m_usePersistence) {
            assert (this.m_recentlyUsedSystemBaselinesList != null) : "'m_recentlyUsedSystemBaselinesList' of method 'deleted' must not be null";
            assert (this.m_recentlyUsedLocalBaselinesList != null) : "'m_recentlyUsedLocalBaselinesList' of method 'deleted' must not be null";
            String entry = FileUtility.getCanonicalFilePath((TFile)baseline);
            if (this.m_recentlyUsedLocalBaselinesList.contains(entry)) {
                this.m_recentlyUsedLocalBaselinesList.remove(entry);
            }
            if (this.m_recentlyUsedSystemBaselinesList.contains(entry)) {
                this.m_recentlyUsedSystemBaselinesList.remove(entry);
            }
            String localBaselinePathValue = this.m_softwareSystem.getSystemProperty(PROPERTY_LOCAL_BASELINE_PATH);
            if (Platform.isCaseSensitive() ? entry.equals(localBaselinePathValue) : entry.equalsIgnoreCase(localBaselinePathValue)) {
                this.m_softwareSystem.setSystemProperty(PROPERTY_LOCAL_BASELINE_PATH, null);
                this.m_softwareSystem.setSystemProperty(PROPERTY_USE_LOCAL_BASELINE, null);
                SystemPropertiesPersistenceProvider.storeProperties(this.m_softwareSystem, result);
            }
        } else if (this.m_localBaseline != null && FileUtility.refersToSameFile((TFile)baseline, (TFile)((TFile)this.m_localBaseline.getFirst()))) {
            this.m_localBaseline = null;
        }
    }

    public void addLastRecentlyUsed(TFile baseline, BaselineType baselineType) {
        assert (baseline != null) : "Parameter 'baseline' of method 'addLastRecentlyUsed' must not be null";
        assert (baselineType != null) : "Parameter 'baselineType' of method 'addLastRecentlyUsed' must not be null";
        if (this.m_usePersistence) {
            assert (this.m_recentlyUsedSystemBaselinesList != null) : "'m_recentlyUsedSystemBaselinesList' of method 'addLastRecentlyUsed' must not be null";
            assert (this.m_recentlyUsedLocalBaselinesList != null) : "'m_recentlyUsedLocalBaselinesList' of method 'addLastRecentlyUsed' must not be null";
            if (baselineType == BaselineType.SYSTEM) {
                this.m_recentlyUsedSystemBaselinesList.lastRecentlyUsed(FileUtility.getCanonicalFilePath((TFile)baseline));
            } else {
                this.m_recentlyUsedLocalBaselinesList.lastRecentlyUsed(FileUtility.getCanonicalFilePath((TFile)baseline));
            }
        }
    }

    public List<BaselineInfo> getRecentlyUsedBaselineReports(BaselineType type) {
        assert (type != null) : "Parameter 'type' of method 'getRecentlyUsedBaselineReports' must not be null";
        if (this.m_usePersistence) {
            PersistentRecentlyUsedList baselinePaths;
            assert (this.m_recentlyUsedSystemBaselinesList != null) : "'m_recentlyUsedSystemBaselinesList' of method 'getRecentlyUsedBaselineReports' must not be null";
            assert (this.m_recentlyUsedLocalBaselinesList != null) : "'m_recentlyUsedLocalBaselinesList' of method 'getRecentlyUsedBaselineReports' must not be null";
            PersistentRecentlyUsedList persistentRecentlyUsedList = baselinePaths = type == BaselineType.SYSTEM ? this.m_recentlyUsedSystemBaselinesList : this.m_recentlyUsedLocalBaselinesList;
            if (baselinePaths.getNumberOfEntries() > 0) {
                try {
                    ArrayList<BaselineInfo> recentlyUsedEntries = new ArrayList<BaselineInfo>();
                    BaselineReader reader = new BaselineReader();
                    for (String nextPath : baselinePaths.getAll()) {
                        OperationResultWithOutcome<BaselineInfo> readResult = reader.read(new TFile(nextPath));
                        if (readResult.isSuccess()) {
                            recentlyUsedEntries.add((BaselineInfo)readResult.getOutcome());
                            continue;
                        }
                        LOGGER.debug("Removing path '{}' from {} recently used baselines list.", (Object)nextPath, (Object)type.getPresentationName());
                        baselinePaths.remove(nextPath);
                    }
                    return recentlyUsedEntries;
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load recently used baselines", (Throwable)e);
                }
            }
        }
        return Collections.emptyList();
    }

    public boolean setLocalBaselineEnabled(OperationResult result, boolean enabled) {
        assert (result != null) : "Parameter 'result' of method 'setLocalBaselineEnabled' must not be null";
        if (this.m_usePersistence) {
            String localBaselineValue = this.m_softwareSystem.getSystemProperty(PROPERTY_LOCAL_BASELINE_PATH);
            String useLocalBaselineValue = this.m_softwareSystem.getSystemProperty(PROPERTY_USE_LOCAL_BASELINE);
            if (localBaselineValue != null && !localBaselineValue.isEmpty() && useLocalBaselineValue != null && Boolean.valueOf(useLocalBaselineValue) != enabled) {
                this.m_softwareSystem.setSystemProperty(PROPERTY_USE_LOCAL_BASELINE, Boolean.toString(enabled));
                SystemPropertiesPersistenceProvider.storeProperties(this.m_softwareSystem, result);
                return true;
            }
        } else if (this.m_localBaseline != null && (Boolean)this.m_localBaseline.getSecond() != enabled) {
            this.m_localBaseline = new StrictPair((Object)((TFile)this.m_localBaseline.getFirst()), (Object)enabled);
            LOGGER.info((enabled ? "Enable " : "Disable") + " local baseline (no persistence): " + FileUtility.getCanonicalFilePath((TFile)((TFile)this.m_localBaseline.getFirst())));
            return true;
        }
        return false;
    }

    public void setLocalBaseline(TFile baseline, String baselinePath, boolean enabled, OperationResult result) {
        assert (baseline != null) : "Parameter 'baseline' of method 'setLocalBaseline' must not be null";
        assert (baselinePath != null && baselinePath.length() > 0) : "Parameter 'baselinePath' of method 'setLocalBaseline' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'setLocalBaseline' must not be null";
        if (this.m_usePersistence) {
            this.m_softwareSystem.setSystemProperty(PROPERTY_USE_LOCAL_BASELINE, Boolean.toString(enabled));
            this.m_softwareSystem.setSystemProperty(PROPERTY_LOCAL_BASELINE_PATH, baselinePath);
            SystemPropertiesPersistenceProvider.storeProperties(this.m_softwareSystem, result);
        } else {
            this.m_localBaseline = new StrictPair((Object)baseline, (Object)true);
            LOGGER.info("Set local baseline (no persistence): " + FileUtility.getCanonicalFilePath((TFile)baseline));
        }
    }

    public boolean deleteLocalBaselineEntry(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'deleteLocalBaselineEntry' must not be null";
        if (this.m_usePersistence) {
            String localBaselineValue = this.m_softwareSystem.getSystemProperty(PROPERTY_LOCAL_BASELINE_PATH);
            String useLocalBaselineValue = this.m_softwareSystem.getSystemProperty(PROPERTY_USE_LOCAL_BASELINE);
            if (localBaselineValue != null || useLocalBaselineValue != null) {
                this.m_softwareSystem.setSystemProperty(PROPERTY_LOCAL_BASELINE_PATH, null);
                this.m_softwareSystem.setSystemProperty(PROPERTY_USE_LOCAL_BASELINE, null);
                SystemPropertiesPersistenceProvider.storeProperties(this.m_softwareSystem, result);
                return true;
            }
        } else if (this.m_localBaseline != null) {
            this.m_localBaseline = null;
            return true;
        }
        return false;
    }
}

