/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.sonargraph.core.controller.system.diff.DependencyIssueMatcher;
import com.hello2morrow.sonargraph.core.controller.system.diff.SimpleIssueDiffProcessor;
import com.hello2morrow.sonargraph.core.controller.system.diff.SimpleIssueMatcher;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.element.DependencyIssue;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotDependency;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.integration.access.controller.ISystemInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.model.IDependencyIssue;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

public final class DependencyIssueDiffProcessor
extends SimpleIssueDiffProcessor<IDependencyIssue, DependencyIssue> {
    public DependencyIssueDiffProcessor(ISoftwareSystem baselineSystem, ISystemInfoProcessor baselineSystemInfoProcessor, Set<IIssue> allBaselineIssues, SoftwareSystem currentSystem, Set<Issue> allCurrentIssues, Map<NamedElement, String> namedElementToFqNameCache) {
        super(baselineSystem, baselineSystemInfoProcessor, allBaselineIssues, currentSystem, allCurrentIssues, namedElementToFqNameCache, IDependencyIssue.class, DependencyIssue.class);
    }

    @Override
    protected Set<IssueCategory> getIgnoredIssueCategories() {
        return EnumSet.of(IssueCategory.REFACTORING, IssueCategory.TODO);
    }

    @Override
    protected String getAffectedCurrentElementFqName(DependencyIssue currentIssue) {
        assert (currentIssue != null) : "Parameter 'currentIssue' of method 'getAffectedCurrentElementFqName' must not be null";
        ISnapshotDependency.IDependencyEndpoint from = currentIssue.getAffectedElement().getFrom();
        assert (from instanceof NamedElement) : "Unsupported endpoint type " + from.getClass().getName() + " of dependency issue " + String.valueOf(currentIssue);
        NamedElement namedElement = (NamedElement)((Object)from);
        return this.getOrCreateFqNameFromCachedElement(namedElement);
    }

    @Override
    protected SimpleIssueMatcher<IDependencyIssue, DependencyIssue> getIssueMatcher() {
        return new DependencyIssueMatcher(this, this);
    }
}

