/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.sonargraph.core.controller.system.diff.AbstractIssueDiffProcessor;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroupIssue;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.CycleGroupIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.CyclicElementDiff;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.integration.access.controller.ISystemInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.model.ICycleGroupIssue;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.INamedElement;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class CycleGroupIssueDiffProcessor
extends AbstractIssueDiffProcessor<ICycleGroupIssue, CycleGroupIssue> {
    static final int TOLERANCE_FOR_CYCLE_MATCH_IN_PERCENT = 20;

    public CycleGroupIssueDiffProcessor(ISoftwareSystem baselineSystem, ISystemInfoProcessor baselineSystemInfoProcessor, Set<IIssue> allBaselineIssues, SoftwareSystem currentSystem, Set<Issue> allCurrentIssues, Map<NamedElement, String> namedElementToFqNameCache) {
        super(baselineSystem, baselineSystemInfoProcessor, allBaselineIssues, currentSystem, allCurrentIssues, namedElementToFqNameCache, ICycleGroupIssue.class, CycleGroupIssue.class);
    }

    @Override
    protected void computeDiffs(NamedElement parent, List<ICycleGroupIssue> baselineIssues, List<CycleGroupIssue> currentIssues) {
        assert (parent != null) : "Parameter 'parent' of method 'computeDiffs' must not be null";
        assert (baselineIssues != null) : "Parameter 'baselineIssues' of method 'computeDiffs' must not be null";
        assert (currentIssues != null) : "Parameter 'currentIssues' of method 'computeDiffs' must not be null";
        Map<CycleGroupDto, ICycleGroupIssue> baselineCyclesMap = this.collectBaselineCycleGroupIssues(baselineIssues);
        Map<CycleGroupDto, CycleGroupIssue> currentCyclesMap = this.collectCurrentCycleGroupIssues(currentIssues);
        this.processExactMatches(parent, baselineCyclesMap, currentCyclesMap);
        this.processWorsened(parent, baselineCyclesMap, currentCyclesMap);
        this.processImproved(parent, baselineCyclesMap, currentCyclesMap);
        this.processModified(parent, baselineCyclesMap, currentCyclesMap);
        this.processRemoved(parent, baselineCyclesMap);
        this.processAdded(parent, currentCyclesMap);
        assert (baselineCyclesMap.isEmpty()) : "Not all baseline cycles processed! Remaining: " + String.valueOf(baselineCyclesMap.keySet());
        assert (currentCyclesMap.isEmpty()) : "Not all current cycles processed! Remaining: " + String.valueOf(currentCyclesMap.keySet());
    }

    private Map<CycleGroupDto, ICycleGroupIssue> collectBaselineCycleGroupIssues(List<ICycleGroupIssue> baselineIssues) {
        HashMap<CycleGroupDto, ICycleGroupIssue> baselineCyclesMap = new HashMap<CycleGroupDto, ICycleGroupIssue>();
        for (ICycleGroupIssue nextIssue : baselineIssues) {
            TreeSet<String> elementFqNames = new TreeSet<String>();
            for (INamedElement nextCyclicElement : nextIssue.getAffectedNamedElements()) {
                elementFqNames.add(this.getBaselineOriginalFqName(nextCyclicElement));
            }
            CycleGroupDto dto = new CycleGroupDto(nextIssue.getIssueType().getName(), nextIssue.getPresentationName(), elementFqNames);
            baselineCyclesMap.put(dto, nextIssue);
        }
        return baselineCyclesMap;
    }

    private Map<CycleGroupDto, CycleGroupIssue> collectCurrentCycleGroupIssues(List<CycleGroupIssue> currentIssues) {
        HashMap<CycleGroupDto, CycleGroupIssue> currentCycleMap = new HashMap<CycleGroupDto, CycleGroupIssue>();
        for (CycleGroupIssue nextIssue : currentIssues) {
            TreeSet<String> elementFqNames = new TreeSet<String>();
            AnalyzerCycleGroup affectedElement = nextIssue.getAffectedElement();
            assert (affectedElement instanceof AnalyzerCycleGroup) : "Unexpected affected element: " + String.valueOf(affectedElement);
            AnalyzerCycleGroup cycleGroup = affectedElement;
            for (NamedElement nextCyclicElement : cycleGroup.getCyclicNamedElements()) {
                elementFqNames.add(this.getOrCreateFqNameFromCachedElement(nextCyclicElement));
            }
            CycleGroupDto dto = new CycleGroupDto(nextIssue.getId().getStandardName(), nextIssue.getAffectedElement().getPresentationName(true), elementFqNames);
            currentCycleMap.put(dto, nextIssue);
        }
        return currentCycleMap;
    }

    private void processExactMatches(NamedElement parent, Map<CycleGroupDto, ICycleGroupIssue> baselineCyclesMap, Map<CycleGroupDto, CycleGroupIssue> currentCyclesMap) {
        assert (parent != null) : "Parameter 'parent' of method 'processExactMatches' must not be null";
        assert (baselineCyclesMap != null) : "Parameter 'baselineCyclesMap' of method 'processExactMatches' must not be null";
        assert (currentCyclesMap != null) : "Parameter 'currentCyclesMap' of method 'processExactMatches' must not be null";
        ArrayList<CycleGroupDto> matchedBaselines = new ArrayList<CycleGroupDto>();
        for (Map.Entry<CycleGroupDto, ICycleGroupIssue> nextBaselineEntry : baselineCyclesMap.entrySet()) {
            CycleGroupIssueDiff.CycleChange cycleChange;
            IDiffElement.Change change;
            CycleGroupIssue current = currentCyclesMap.remove(nextBaselineEntry.getKey());
            if (current == null) continue;
            ICycleGroupIssue baseline2 = nextBaselineEntry.getValue();
            Pair<IDiffElement.Change, String> resolutionChange = this.determineResolutionChange(baseline2, current);
            int baselineDepsToRemove = baseline2.getParserDependenciesToRemove();
            int currentDepsToRemove = current.getAffectedElement().getParserDependenciesToRemove();
            Object changeDetails = (String)resolutionChange.getSecond();
            if (((String)changeDetails).length() > 0) {
                changeDetails = (String)changeDetails + ". ";
            }
            if (baselineDepsToRemove == currentDepsToRemove) {
                change = IDiffElement.Change.UNMODIFIED;
                cycleChange = CycleGroupIssueDiff.CycleChange.UNMODIFIED;
            } else if (baselineDepsToRemove > currentDepsToRemove) {
                change = IDiffElement.Change.IMPROVED;
                changeDetails = (String)changeDetails + "Parser dependencies to remove: " + baselineDepsToRemove + " -> " + currentDepsToRemove;
                cycleChange = CycleGroupIssueDiff.CycleChange.PARSER_DEPENDENCIES_CHANGED;
            } else {
                change = IDiffElement.Change.WORSENED;
                changeDetails = (String)changeDetails + "Parser dependencies to remove: " + baselineDepsToRemove + " -> " + currentDepsToRemove;
                cycleChange = CycleGroupIssueDiff.CycleChange.PARSER_DEPENDENCIES_CHANGED;
            }
            if (resolutionChange.getFirst() != IDiffElement.Change.UNMODIFIED) {
                change = (IDiffElement.Change)((Object)resolutionChange.getFirst());
            }
            CycleGroupIssueDiff diff = ((String)changeDetails).length() == 0 ? new CycleGroupIssueDiff(parent, baseline2, current, change, cycleChange) : new CycleGroupIssueDiff(parent, baseline2, current, change, (String)changeDetails, cycleChange);
            parent.addChild(diff);
            this.addCyclicElementsForUnchangedCycle(diff, baseline2, current);
            matchedBaselines.add(nextBaselineEntry.getKey());
        }
        matchedBaselines.forEach(baseline -> {
            Object v = baselineCyclesMap.remove(baseline);
        });
    }

    private void addCyclicElementsForUnchangedCycle(CycleGroupIssueDiff parent, ICycleGroupIssue baseline, CycleGroupIssue current) {
        ArrayList<INamedElement> affectedBaselineElements = new ArrayList<INamedElement>(baseline.getAffectedNamedElements());
        affectedBaselineElements.sort(new Comparator<INamedElement>(){

            @Override
            public int compare(INamedElement o1, INamedElement o2) {
                return o1.getFqName().compareTo(o2.getFqName());
            }
        });
        AnalyzerCycleGroup currentCycleGroup = current.getAffectedElement();
        ArrayList<NamedElement> affectedCurrentElements = new ArrayList<NamedElement>(currentCycleGroup.getCyclicNamedElements());
        affectedCurrentElements.sort(new Comparator<NamedElement>(){

            @Override
            public int compare(NamedElement o1, NamedElement o2) {
                return o1.getFullyQualifiedName().compareTo(o2.getFullyQualifiedName());
            }
        });
        int i = 0;
        while (i < affectedCurrentElements.size()) {
            INamedElement baselineElement = (INamedElement)affectedBaselineElements.get(i);
            NamedElement currentElement = (NamedElement)affectedCurrentElements.get(i);
            CyclicElementDiff diff = new CyclicElementDiff((NamedElement)parent, baselineElement, currentElement, IDiffElement.Change.UNMODIFIED);
            parent.addChild(diff);
            ++i;
        }
    }

    private void processWorsened(NamedElement parent, Map<CycleGroupDto, ICycleGroupIssue> baselineCyclesMap, Map<CycleGroupDto, CycleGroupIssue> currentCyclesMap) {
        assert (parent != null) : "Parameter 'parent' of method 'processWorsened' must not be null";
        assert (baselineCyclesMap != null) : "Parameter 'baselineCyclesMap' of method 'processWorsened' must not be null";
        assert (currentCyclesMap != null) : "Parameter 'currentCyclesMap' of method 'processWorsened' must not be null";
        ArrayList<CycleGroupDto> matchedCurrent = new ArrayList<CycleGroupDto>();
        for (Map.Entry<CycleGroupDto, CycleGroupIssue> nextCurrentEntry : currentCyclesMap.entrySet()) {
            CycleGroupDto current2 = nextCurrentEntry.getKey();
            CycleGroupIssue currentIssue = nextCurrentEntry.getValue();
            ArrayList<Pair<CycleGroupDto, ICycleGroupIssue>> baselineCandidates = new ArrayList<Pair<CycleGroupDto, ICycleGroupIssue>>();
            for (Map.Entry<CycleGroupDto, ICycleGroupIssue> nextBaselineEntry : baselineCyclesMap.entrySet()) {
                CycleGroupDto baseline = nextBaselineEntry.getKey();
                if (!current2.getType().equals(baseline.getType())) continue;
                HashSet<String> baselineCyclicElements = new HashSet<String>(baseline.getCyclicElementFqNames());
                if (current2.getCyclicElementFqNames().containsAll(baseline.getCyclicElementFqNames())) {
                    baselineCandidates.add(new Pair((Object)baseline, (Object)nextBaselineEntry.getValue()));
                    continue;
                }
                if (current2.getCyclicElementFqNames().size() <= baselineCyclicElements.size()) continue;
                baselineCyclicElements.retainAll(current2.getCyclicElementFqNames());
                double similarity = (double)baselineCyclicElements.size() * 1.0 / (double)baseline.getCyclicElementFqNames().size();
                if (Double.compare(similarity, 0.6) <= 0) continue;
                baselineCandidates.add((Pair<CycleGroupDto, ICycleGroupIssue>)new Pair((Object)baseline, (Object)nextBaselineEntry.getValue()));
            }
            if (baselineCandidates.size() == 1) {
                IDiffElement.Change resultingChange;
                ICycleGroupIssue baselineIssue = (ICycleGroupIssue)((Pair)baselineCandidates.get(0)).getSecond();
                Pair<IDiffElement.Change, String> pair = this.determineResolutionChange(baselineIssue, currentIssue);
                StringBuilder changeDetails = new StringBuilder();
                if (pair.getFirst() != IDiffElement.Change.UNMODIFIED) {
                    resultingChange = (IDiffElement.Change)((Object)pair.getFirst());
                    changeDetails.append((String)pair.getSecond()).append(". ");
                } else {
                    resultingChange = IDiffElement.Change.WORSENED;
                }
                changeDetails.append("Involved cyclic elements: ").append(((CycleGroupDto)((Pair)baselineCandidates.get(0)).getFirst()).getCyclicElementFqNames().size());
                changeDetails.append(" -> ");
                changeDetails.append(current2.getCyclicElementFqNames().size());
                CycleGroupIssueDiff diff = new CycleGroupIssueDiff(parent, baselineIssue, currentIssue, resultingChange, changeDetails.toString(), CycleGroupIssueDiff.CycleChange.CYCLIC_ELEMENTS_CHANGED);
                parent.addChild(diff);
                this.addCyclicElementsForWorsenedCycle(diff, baselineCandidates, currentIssue);
                matchedCurrent.add(current2);
            } else if (baselineCandidates.size() > 1) {
                StringBuilder currentChangeDetails = new StringBuilder("New cycle group integrating baseline groups: ");
                for (Pair pair : baselineCandidates) {
                    currentChangeDetails.append(((CycleGroupDto)pair.getFirst()).getCycleName()).append(", ");
                    ICycleGroupIssue baseline = (ICycleGroupIssue)pair.getSecond();
                    Pair<IDiffElement.Change, String> resolutionChange = this.determineResolutionChange(baseline, currentIssue);
                    StringBuilder changeDetails = new StringBuilder();
                    if (resolutionChange.getFirst() != IDiffElement.Change.UNMODIFIED) {
                        changeDetails.append((String)resolutionChange.getSecond()).append(" ");
                    }
                    changeDetails.append("Integrated into: " + current2.getCycleName());
                    CycleGroupIssueDiff baselineRemovedDiff = new CycleGroupIssueDiff(parent, baseline, null, IDiffElement.Change.REMOVED, changeDetails.toString(), CycleGroupIssueDiff.CycleChange.INTEGRATED);
                    parent.addChild(baselineRemovedDiff);
                    this.addRemovedCyclicElements(baselineRemovedDiff, baseline);
                }
                CycleGroupIssueDiff cycleGroupIssueDiff = new CycleGroupIssueDiff(parent, null, nextCurrentEntry.getValue(), IDiffElement.Change.WORSENED, currentChangeDetails.substring(0, currentChangeDetails.length() - 2), CycleGroupIssueDiff.CycleChange.INTEGRATED);
                parent.addChild(cycleGroupIssueDiff);
                this.addCyclicElementsForWorsenedCycle(cycleGroupIssueDiff, baselineCandidates, currentIssue);
                matchedCurrent.add(current2);
            }
            baselineCandidates.forEach(c -> {
                Object v = baselineCyclesMap.remove(c.getFirst());
            });
        }
        matchedCurrent.forEach(current -> {
            Object v = currentCyclesMap.remove(current);
        });
    }

    private void addRemovedCyclicElements(CycleGroupIssueDiff parent, ICycleGroupIssue baseline) {
        assert (parent != null) : "Parameter 'parent' of method 'addRemovedCyclicElements' must not be null";
        assert (baseline != null) : "Parameter 'baseline' of method 'addRemovedCyclicElements' must not be null";
        for (INamedElement next : baseline.getAffectedNamedElements()) {
            CyclicElementDiff diff = new CyclicElementDiff((NamedElement)parent, next, null, IDiffElement.Change.REMOVED);
            parent.addChild(diff);
        }
    }

    private void addAddedCyclicElements(CycleGroupIssueDiff parent, CycleGroupIssue current) {
        assert (parent != null) : "Parameter 'parent' of method 'addAddedCyclicElements' must not be null";
        assert (current != null) : "Parameter 'current' of method 'addAddedCyclicElements' must not be null";
        AnalyzerCycleGroup cycleGroup = current.getAffectedElement();
        for (NamedElement next : cycleGroup.getCyclicNamedElements()) {
            CyclicElementDiff diff = new CyclicElementDiff((NamedElement)parent, null, next, IDiffElement.Change.ADDED);
            parent.addChild(diff);
        }
    }

    private void addCyclicElementsForWorsenedCycle(CycleGroupIssueDiff parent, List<Pair<CycleGroupDto, ICycleGroupIssue>> baselineCandidates, CycleGroupIssue currentIssue) {
        assert (parent != null) : "Parameter 'parent' of method 'addCyclicElementsForWorsenedCycle' must not be null";
        assert (baselineCandidates != null && baselineCandidates.size() > 0) : "Parameter 'baselineCandidates' of method 'addCyclicElementsForWorsenedCycle' must not be empty";
        assert (currentIssue != null) : "Parameter 'currentIsseu' of method 'addCyclicElementsForWorsenedCycle' must not be null";
        TreeMap<String, Pair> baselineFqNameToElementMap = new TreeMap<String, Pair>();
        for (Pair<CycleGroupDto, ICycleGroupIssue> next : baselineCandidates) {
            for (INamedElement nextCyclic : ((ICycleGroupIssue)next.getSecond()).getAffectedNamedElements()) {
                baselineFqNameToElementMap.put(nextCyclic.getFqName(), new Pair((Object)nextCyclic, (Object)((ICycleGroupIssue)next.getSecond())));
            }
        }
        AnalyzerCycleGroup currentGroup = currentIssue.getAffectedElement();
        for (NamedElement namedElement : currentGroup.getCyclicNamedElements()) {
            CyclicElementDiff diff;
            Pair baselinePair = (Pair)baselineFqNameToElementMap.remove(namedElement.getFullyQualifiedName());
            if (baselinePair != null) {
                INamedElement baselineCyclic = (INamedElement)baselinePair.getFirst();
                diff = baselineCandidates.size() > 1 ? new CyclicElementDiff((NamedElement)parent, baselineCyclic, namedElement, IDiffElement.Change.UNMODIFIED, "Baseline cycle group: " + ((ICycleGroupIssue)baselinePair.getSecond()).getPresentationName()) : new CyclicElementDiff((NamedElement)parent, baselineCyclic, namedElement, IDiffElement.Change.UNMODIFIED);
            } else {
                diff = new CyclicElementDiff((NamedElement)parent, null, namedElement, IDiffElement.Change.ADDED);
            }
            parent.addChild(diff);
        }
        for (Map.Entry entry : baselineFqNameToElementMap.entrySet()) {
            CyclicElementDiff diff = new CyclicElementDiff((NamedElement)parent, (INamedElement)((Pair)entry.getValue()).getFirst(), null, IDiffElement.Change.REMOVED);
            parent.addChild(diff);
        }
    }

    private void addCyclicElementsForImprovedCycle(CycleGroupIssueDiff parent, ICycleGroupIssue baselineIssue, List<Pair<CycleGroupDto, CycleGroupIssue>> currentCandidates) {
        assert (parent != null) : "Parameter 'parent' of method 'addCyclicElementsForImprovedCycle' must not be null";
        assert (baselineIssue != null) : "Parameter 'baselineIssue' of method 'addCyclicElementsForImprovedCycle' must not be null";
        assert (currentCandidates != null && !currentCandidates.isEmpty()) : "Parameter 'currentCandidates' of method 'addCyclicElementsForImprovedCycle' must not be empty";
        HashMap<String, Pair> currentEntriesFqNameToElement = new HashMap<String, Pair>();
        for (Pair<CycleGroupDto, CycleGroupIssue> nextCurrentPair : currentCandidates) {
            AnalyzerCycleGroup cycleGroup = ((CycleGroupIssue)nextCurrentPair.getSecond()).getAffectedElement();
            for (NamedElement nextCyclic : cycleGroup.getCyclicNamedElements()) {
                currentEntriesFqNameToElement.put(nextCyclic.getFullyQualifiedName(), new Pair((Object)nextCyclic, (Object)((CycleGroupIssue)nextCurrentPair.getSecond())));
            }
        }
        for (INamedElement nextBaselineCyclic : baselineIssue.getAffectedNamedElements()) {
            CyclicElementDiff diff;
            Pair currentPair = (Pair)currentEntriesFqNameToElement.remove(nextBaselineCyclic.getFqName());
            if (currentPair == null) {
                diff = new CyclicElementDiff((NamedElement)parent, nextBaselineCyclic, null, IDiffElement.Change.REMOVED);
            } else {
                NamedElement currentCyclic = (NamedElement)currentPair.getFirst();
                diff = currentCandidates.size() > 1 ? new CyclicElementDiff((NamedElement)parent, nextBaselineCyclic, currentCyclic, IDiffElement.Change.ADDED, "Baseline cycle group: " + baselineIssue.getPresentationName()) : new CyclicElementDiff((NamedElement)parent, nextBaselineCyclic, currentCyclic, IDiffElement.Change.UNMODIFIED);
            }
            parent.addChild(diff);
        }
    }

    private void processImproved(NamedElement parent, Map<CycleGroupDto, ICycleGroupIssue> baselineCyclesMap, Map<CycleGroupDto, CycleGroupIssue> currentCyclesMap) {
        assert (parent != null) : "Parameter 'parent' of method 'processImproved' must not be null";
        assert (baselineCyclesMap != null) : "Parameter 'baselineCyclesMap' of method 'processImproved' must not be null";
        assert (currentCyclesMap != null) : "Parameter 'currentCyclesMap' of method 'processImproved' must not be null";
        ArrayList<CycleGroupDto> matchedBaseline = new ArrayList<CycleGroupDto>();
        for (Map.Entry<CycleGroupDto, ICycleGroupIssue> nextBaselineEntry : baselineCyclesMap.entrySet()) {
            CycleGroupDto baseline2 = nextBaselineEntry.getKey();
            ArrayList<Pair<CycleGroupDto, CycleGroupIssue>> currentCandidates = new ArrayList<Pair<CycleGroupDto, CycleGroupIssue>>();
            for (Map.Entry<CycleGroupDto, CycleGroupIssue> nextCurrentEntry : currentCyclesMap.entrySet()) {
                CycleGroupDto cycleGroupDto = nextCurrentEntry.getKey();
                if (!baseline2.getType().equals(cycleGroupDto.getType())) continue;
                HashSet<String> currentCyclicElements = new HashSet<String>(cycleGroupDto.getCyclicElementFqNames());
                if (baseline2.getCyclicElementFqNames().containsAll(currentCyclicElements)) {
                    currentCandidates.add(new Pair((Object)cycleGroupDto, (Object)nextCurrentEntry.getValue()));
                    continue;
                }
                if (baseline2.getCyclicElementFqNames().size() <= currentCyclicElements.size()) continue;
                currentCyclicElements.retainAll(baseline2.getCyclicElementFqNames());
                double similarity = (double)currentCyclicElements.size() * 1.0 / (double)cycleGroupDto.getCyclicElementFqNames().size();
                if (Double.compare(similarity, 0.6) <= 0) continue;
                currentCandidates.add((Pair<CycleGroupDto, CycleGroupIssue>)new Pair((Object)cycleGroupDto, (Object)nextCurrentEntry.getValue()));
            }
            ICycleGroupIssue baselineIssue = nextBaselineEntry.getValue();
            if (currentCandidates.size() == 1) {
                IDiffElement.Change resultingChange;
                CycleGroupIssue currentIssue = (CycleGroupIssue)((Pair)currentCandidates.get(0)).getSecond();
                Pair<IDiffElement.Change, String> pair = this.determineResolutionChange(baselineIssue, currentIssue);
                StringBuilder changeDetails = new StringBuilder();
                if (pair.getFirst() != IDiffElement.Change.UNMODIFIED) {
                    resultingChange = (IDiffElement.Change)((Object)pair.getFirst());
                    changeDetails.append((String)pair.getSecond()).append(". ");
                } else {
                    resultingChange = IDiffElement.Change.IMPROVED;
                }
                changeDetails.append("Involved cyclic elements: ").append(baseline2.getCyclicElementFqNames().size());
                changeDetails.append(" -> ");
                changeDetails.append(((CycleGroupDto)((Pair)currentCandidates.get(0)).getFirst()).getCyclicElementFqNames().size());
                CycleGroupIssueDiff diff = new CycleGroupIssueDiff(parent, baselineIssue, currentIssue, resultingChange, changeDetails.toString(), CycleGroupIssueDiff.CycleChange.CYCLIC_ELEMENTS_CHANGED);
                parent.addChild(diff);
                this.addCyclicElementsForImprovedCycle(diff, baselineIssue, currentCandidates);
                matchedBaseline.add(baseline2);
            } else if (currentCandidates.size() > 1) {
                StringBuilder baselineChangeDetails = new StringBuilder("Split into: ");
                for (Pair pair : currentCandidates) {
                    baselineChangeDetails.append(((CycleGroupDto)pair.getFirst()).getCycleName()).append(", ");
                    CycleGroupIssue currentIssue = (CycleGroupIssue)pair.getSecond();
                    Pair<IDiffElement.Change, String> resolutionChange = this.determineResolutionChange(baselineIssue, currentIssue);
                    StringBuilder changeDescription = new StringBuilder();
                    if (resolutionChange.getFirst() != IDiffElement.Change.UNMODIFIED) {
                        changeDescription.append((String)resolutionChange.getSecond()).append(". ");
                    }
                    changeDescription.append("New cycle group split from: ").append(baseline2.getCycleName()).append(" [Baseline]");
                    CycleGroupIssueDiff currentAddedDiff = new CycleGroupIssueDiff(parent, null, currentIssue, IDiffElement.Change.IMPROVED, changeDescription.toString(), CycleGroupIssueDiff.CycleChange.SPLIT);
                    parent.addChild(currentAddedDiff);
                    this.addAddedCyclicElements(currentAddedDiff, (CycleGroupIssue)pair.getSecond());
                }
                CycleGroupIssueDiff cycleGroupIssueDiff = new CycleGroupIssueDiff(parent, baselineIssue, null, IDiffElement.Change.REMOVED, baselineChangeDetails.substring(0, baselineChangeDetails.length() - 2), CycleGroupIssueDiff.CycleChange.SPLIT);
                parent.addChild(cycleGroupIssueDiff);
                this.addCyclicElementsForImprovedCycle(cycleGroupIssueDiff, baselineIssue, currentCandidates);
                matchedBaseline.add(baseline2);
            }
            currentCandidates.forEach(c -> {
                Object v = currentCyclesMap.remove(c.getFirst());
            });
        }
        matchedBaseline.forEach(baseline -> {
            Object v = baselineCyclesMap.remove(baseline);
        });
    }

    private void processModified(NamedElement parent, Map<CycleGroupDto, ICycleGroupIssue> baselineCyclesMap, Map<CycleGroupDto, CycleGroupIssue> currentCyclesMap) {
        assert (parent != null) : "Parameter 'parent' of method 'processImproved' must not be null";
        assert (baselineCyclesMap != null) : "Parameter 'baselineCyclesMap' of method 'processImproved' must not be null";
        assert (currentCyclesMap != null) : "Parameter 'currentCyclesMap' of method 'processImproved' must not be null";
        ArrayList<CycleGroupDto> matchedBaseline = new ArrayList<CycleGroupDto>();
        for (Map.Entry<CycleGroupDto, ICycleGroupIssue> nextBaselineEntry : baselineCyclesMap.entrySet()) {
            CycleGroupDto baseline2 = nextBaselineEntry.getKey();
            Pair currentBestCandidate = null;
            for (Map.Entry<CycleGroupDto, CycleGroupIssue> nextCurrentEntry : currentCyclesMap.entrySet()) {
                double sizeDifference;
                CycleGroupDto current = nextCurrentEntry.getKey();
                if (!baseline2.getType().equals(current.getType()) || Double.compare(1.0 - (sizeDifference = (double)Math.abs(baseline2.getCyclicElementFqNames().size() - current.getCyclicElementFqNames().size()) * 1.0 / (double)baseline2.getCyclicElementFqNames().size()), 0.6) < 0) continue;
                HashSet<String> currentCyclicElements = new HashSet<String>(current.getCyclicElementFqNames());
                currentCyclicElements.retainAll(baseline2.getCyclicElementFqNames());
                double similarity = (double)currentCyclicElements.size() * 1.0 / (double)baseline2.getCyclicElementFqNames().size();
                if (Double.compare(similarity, 0.6) < 0 || currentBestCandidate != null && Double.compare((Double)currentBestCandidate.getFirst(), similarity) >= 0) continue;
                currentBestCandidate = new Pair((Object)similarity, (Object)new Pair((Object)current, (Object)nextCurrentEntry.getValue()));
            }
            if (currentBestCandidate == null) continue;
            CycleGroupDto current = (CycleGroupDto)((Pair)currentBestCandidate.getSecond()).getFirst();
            TreeSet<String> baselineChangedFqNames = new TreeSet<String>(baseline2.getCyclicElementFqNames());
            baselineChangedFqNames.removeAll(current.getCyclicElementFqNames());
            TreeSet<String> currentChangedFqNames = new TreeSet<String>(current.getCyclicElementFqNames());
            currentChangedFqNames.removeAll(baseline2.getCyclicElementFqNames());
            ICycleGroupIssue baselineIssue = nextBaselineEntry.getValue();
            CycleGroupIssue currentIssue = (CycleGroupIssue)((Pair)currentBestCandidate.getSecond()).getSecond();
            StringBuilder changeDetails = new StringBuilder();
            IDiffElement.Change resultingChange = null;
            Pair<IDiffElement.Change, String> resolutionChange = this.determineResolutionChange(baselineIssue, currentIssue);
            int cycleGroupSizeComparison = Integer.compare(baseline2.getCyclicElementFqNames().size(), current.getCyclicElementFqNames().size());
            CycleGroupIssueDiff.CycleChange cycleChange = CycleGroupIssueDiff.CycleChange.CYCLIC_ELEMENTS_CHANGED;
            if (resolutionChange.getFirst() != IDiffElement.Change.UNMODIFIED) {
                resultingChange = (IDiffElement.Change)((Object)resolutionChange.getFirst());
                changeDetails.append((String)resolutionChange.getSecond()).append(". ");
            } else {
                resultingChange = cycleGroupSizeComparison == 0 ? IDiffElement.Change.MODIFIED : (cycleGroupSizeComparison < 0 ? IDiffElement.Change.WORSENED : IDiffElement.Change.IMPROVED);
            }
            if (cycleGroupSizeComparison == 0) {
                changeDetails.append(baselineChangedFqNames.size()).append(" of ").append(baseline2.getCyclicElementFqNames().size()).append(" cyclic elements ");
                if (baselineChangedFqNames.size() == 1) {
                    changeDetails.append("has changed");
                } else {
                    changeDetails.append("have changed");
                }
                cycleChange = CycleGroupIssueDiff.CycleChange.CYCLIC_ELEMENTS_MODIFIED;
            } else {
                changeDetails.append("Involved cyclic elements: ").append(baseline2.getCyclicElementFqNames().size());
                changeDetails.append(" -> ");
                changeDetails.append(current.getCyclicElementFqNames().size());
                cycleChange = CycleGroupIssueDiff.CycleChange.CYCLIC_ELEMENTS_MODIFIED;
            }
            changeDetails.append(" (").append((int)((Double)currentBestCandidate.getFirst() * 100.0)).append("% similarity). ");
            changeDetails.append(baseline2.getCycleName());
            changeDetails.append(" -> ");
            changeDetails.append(current.getCycleName());
            CycleGroupIssueDiff modifiedDiff = new CycleGroupIssueDiff(parent, baselineIssue, currentIssue, resultingChange, changeDetails.toString(), cycleChange);
            parent.addChild(modifiedDiff);
            this.addCyclicElementsForModifiedCycle(modifiedDiff, baselineIssue, currentIssue);
            matchedBaseline.add(baseline2);
            currentCyclesMap.remove(((Pair)currentBestCandidate.getSecond()).getFirst());
        }
        matchedBaseline.forEach(baseline -> {
            Object v = baselineCyclesMap.remove(baseline);
        });
    }

    private void addCyclicElementsForModifiedCycle(CycleGroupIssueDiff parent, ICycleGroupIssue baselineIssue, CycleGroupIssue currentIssue) {
        assert (parent != null) : "Parameter 'parent' of method 'addCyclicElementsForModifiedCycle' must not be null";
        assert (baselineIssue != null) : "Parameter 'baselineIssue' of method 'addCyclicElementsForModifiedCycle' must not be null";
        assert (currentIssue != null) : "Parameter 'currentIssue' of method 'addCyclicElementsForModifiedCycle' must not be null";
        HashMap<String, INamedElement> baselineFqNameToNamedElementMap = new HashMap<String, INamedElement>();
        for (INamedElement next : baselineIssue.getAffectedNamedElements()) {
            baselineFqNameToNamedElementMap.put(next.getFqName(), next);
        }
        AnalyzerCycleGroup currentCycle = currentIssue.getAffectedElement();
        HashMap<String, NamedElement> currentFqNameToNamedElementMap = new HashMap<String, NamedElement>();
        for (NamedElement next : currentCycle.getCyclicNamedElements()) {
            currentFqNameToNamedElementMap.put(next.getFullyQualifiedName(), next);
        }
        TreeMap<String, CyclicElementDiff> cyclicElements = new TreeMap<String, CyclicElementDiff>();
        for (Map.Entry nextBaselineEntry : baselineFqNameToNamedElementMap.entrySet()) {
            String fqName = (String)nextBaselineEntry.getKey();
            NamedElement currentCyclic = (NamedElement)currentFqNameToNamedElementMap.remove(fqName);
            CyclicElementDiff diff = currentCyclic == null ? new CyclicElementDiff((NamedElement)parent, (INamedElement)nextBaselineEntry.getValue(), null, IDiffElement.Change.REMOVED) : new CyclicElementDiff((NamedElement)parent, (INamedElement)nextBaselineEntry.getValue(), currentCyclic, IDiffElement.Change.UNMODIFIED);
            cyclicElements.put(fqName, diff);
        }
        for (Map.Entry nextCurrentEntry : currentFqNameToNamedElementMap.entrySet()) {
            CyclicElementDiff diff = new CyclicElementDiff((NamedElement)parent, null, (NamedElement)nextCurrentEntry.getValue(), IDiffElement.Change.ADDED);
            cyclicElements.put((String)nextCurrentEntry.getKey(), diff);
        }
        for (CyclicElementDiff diff : cyclicElements.values()) {
            parent.addChild(diff);
        }
    }

    private void processRemoved(NamedElement parent, Map<CycleGroupDto, ICycleGroupIssue> baselineCyclesMap) {
        for (ICycleGroupIssue nextRemoved : baselineCyclesMap.values()) {
            CycleGroupIssueDiff diff = new CycleGroupIssueDiff(parent, nextRemoved, null, IDiffElement.Change.REMOVED, nextRemoved.getDescription(), CycleGroupIssueDiff.CycleChange.REMOVED);
            parent.addChild(diff);
            ArrayList<INamedElement> affectedNamedElements = new ArrayList<INamedElement>(nextRemoved.getAffectedNamedElements());
            affectedNamedElements.sort(new Comparator<INamedElement>(){

                @Override
                public int compare(INamedElement o1, INamedElement o2) {
                    return o1.getFqName().compareTo(o2.getFqName());
                }
            });
            for (INamedElement removedCyclic : affectedNamedElements) {
                CyclicElementDiff cyclicDiff = new CyclicElementDiff((NamedElement)diff, removedCyclic, null, IDiffElement.Change.REMOVED);
                diff.addChild(cyclicDiff);
            }
        }
        baselineCyclesMap.clear();
    }

    private void processAdded(NamedElement parent, Map<CycleGroupDto, CycleGroupIssue> currentCyclesMap) {
        for (CycleGroupIssue nextAdded : currentCyclesMap.values()) {
            CycleGroupIssueDiff diff = new CycleGroupIssueDiff(parent, null, nextAdded, IDiffElement.Change.ADDED, nextAdded.getAffectedElement().getDescription(), CycleGroupIssueDiff.CycleChange.ADDED);
            parent.addChild(diff);
            AnalyzerCycleGroup cycle = nextAdded.getAffectedElement();
            ArrayList<NamedElement> cyclicNamedElements = new ArrayList<NamedElement>(cycle.getCyclicNamedElements());
            cyclicNamedElements.sort(new Comparator<NamedElement>(){

                @Override
                public int compare(NamedElement o1, NamedElement o2) {
                    return o1.getFullyQualifiedName().compareTo(o2.getFullyQualifiedName());
                }
            });
            for (NamedElement addedCyclic : cyclicNamedElements) {
                CyclicElementDiff cyclicDiff = new CyclicElementDiff((NamedElement)diff, null, addedCyclic, IDiffElement.Change.ADDED);
                diff.addChild(cyclicDiff);
            }
        }
        currentCyclesMap.clear();
    }

    private static final class CycleGroupDto {
        private final String m_cycleName;
        private final Set<String> m_cyclicElementFqNames;
        private final String m_type;

        public CycleGroupDto(String type, String cycleName, Set<String> cyclicElementFqNames) {
            assert (type != null && type.length() > 0) : "Parameter 'type' of method 'CycleGroupDto' must not be empty";
            assert (cycleName != null && cycleName.length() > 0) : "Parameter 'cycleName' of method 'CycleGroupDto' must not be empty";
            assert (cyclicElementFqNames != null && !cyclicElementFqNames.isEmpty()) : "Parameter 'cyclicElementFqNames' of method 'CycleGroupDto' must not be empty";
            this.m_type = type;
            this.m_cycleName = cycleName;
            this.m_cyclicElementFqNames = Collections.unmodifiableSet(cyclicElementFqNames);
        }

        public String getCycleName() {
            return this.m_cycleName;
        }

        public Set<String> getCyclicElementFqNames() {
            return this.m_cyclicElementFqNames;
        }

        public String getType() {
            return this.m_type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.m_type == null ? 0 : this.m_type.hashCode());
            result = 31 * result + (this.m_cyclicElementFqNames == null ? 0 : this.m_cyclicElementFqNames.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CycleGroupDto other = (CycleGroupDto)obj;
            if (this.m_type == null ? other.m_type != null : !this.m_type.equals(other.m_type)) {
                return false;
            }
            return !(this.m_cyclicElementFqNames == null ? other.m_cyclicElementFqNames != null : !this.m_cyclicElementFqNames.equals(other.m_cyclicElementFqNames));
        }

        public String toString() {
            return this.m_cycleName;
        }
    }
}

