/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.base;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IIssue;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementIssue;
import com.hello2morrow.sonargraph.core.model.element.pattern.SimilarityMatchPattern;
import com.hello2morrow.sonargraph.core.model.resolution.GeneratedIssueBasedTaskDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.Matching;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractSimilarityMatcher<T extends NamedElement, I extends NamedElementIssue, S> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSimilarityMatcher.class);
    private final double m_similarityThreshold;

    public AbstractSimilarityMatcher(double similarityThreshold) {
        this.m_similarityThreshold = similarityThreshold;
    }

    protected abstract T getAffectedElement(I var1);

    protected abstract Set<S> getElementsForSimilarityMatch(T var1);

    protected abstract Set<S> getReferenceElementsForSimilarityMatch(Matching var1);

    protected abstract I getIssueFromResolution(Resolution var1);

    protected void migrateMatchingInfo(T element, Matching matching) {
        assert (element != null) : "Parameter 'element' of method 'migrateMatchingInfo' must not be null";
        assert (matching != null) : "Parameter 'matching' of method 'migrateMatchingInfo' must not be null";
    }

    protected boolean matchPatternBased(Resolution resolution, I issue) {
        return false;
    }

    protected boolean supportsPatternBasedMacthing() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean matchResolution(List<? extends Resolution> resolutions, I issue, Set<Issue> collector) {
        void var7_13;
        assert (resolutions != null && resolutions.size() > 0) : "Parameter 'resolutions' of method 'matchResolution' must not be empty";
        assert (issue != null) : "Parameter 'issue' of method 'matchResolution' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'matchResolution' must not be null";
        boolean matched = false;
        T affectedElement = this.getAffectedElement(issue);
        String fqName = ((NamedElement)affectedElement).getFullyQualifiedName();
        if (this.supportsPatternBasedMacthing()) {
            for (Resolution resolution : resolutions) {
                assert (!(resolution instanceof GeneratedIssueBasedTaskDefinition)) : "'GeneratedIssueBasedTaskDefinition' not expected: " + resolution.getClass().getName();
                if (!resolution.getIssueType().matches(((Issue)issue).getKey()) || !this.matchPatternBased(resolution, issue)) continue;
                return true;
            }
        }
        Object var7_9 = null;
        StrictPair bestMatch = null;
        for (Resolution resolution : resolutions) {
            SimilarityMatchPattern previousPattern;
            SimilarityMatchPattern pattern;
            assert (!(resolution instanceof GeneratedIssueBasedTaskDefinition)) : "'GeneratedIssueBasedTaskDefinition' not expected: " + resolution.getClass().getName();
            if (!resolution.getIssueType().matches(((Issue)issue).getKey()) || (pattern = resolution.getUniqueChild(SimilarityMatchPattern.class)) == null) continue;
            double similarityOfPreviousMatch = pattern.getSimilarityOfMatch();
            if (resolution.getAssociatedIssues().size() > 0 && Double.compare(similarityOfPreviousMatch, 1.0) == 0) continue;
            if (pattern.matches(fqName)) {
                if (resolution.getAssociatedIssues().size() > 0 && Double.compare(similarityOfPreviousMatch, 0.0) > 0) {
                    assert (Double.compare(1.0, similarityOfPreviousMatch) > 0 && pattern.getMatchedFqName() != null && !pattern.getMatchedFqName().equals(fqName)) : "There cannot be two exact matches of " + ((Issue)issue).getKey() + " issues for resolution " + String.valueOf(resolution);
                    I i = this.getIssueFromResolution(resolution);
                    if (i != null) {
                        resolution.reset((IIssue)i);
                    }
                }
                ((Issue)issue).setResolution(resolution);
                Matching matching = resolution.getUniqueExistingChild(Matching.class);
                this.migrateMatchingInfo(affectedElement, matching);
                pattern.setSimilarityOfMatch(1.0, fqName);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Exact match of {} found for resolution {}", (Object)((Element)affectedElement).getPresentationName(true), (Object)resolution.getPresentationName(true));
                }
                matched = true;
                break;
            }
            Set<S> elementsToCompare = this.getElementsForSimilarityMatch(affectedElement);
            if (elementsToCompare.isEmpty()) {
                LOGGER.warn("No fuzzy matching, because necessary information is missing for {}. Probably loaded analysis results from an old snapshot.", (Object)((Element)affectedElement).getPresentationName(true));
                continue;
            }
            Matching matching = resolution.getUniqueExistingChild(Matching.class);
            Set<S> referenceElements = this.getReferenceElementsForSimilarityMatch(matching);
            double similarity = this.getSimilarity(referenceElements, elementsToCompare);
            if (Double.compare(similarity, this.m_similarityThreshold) < 0) continue;
            if (bestMatch == null) {
                if (Double.compare(similarity, similarityOfPreviousMatch) <= 0) continue;
                bestMatch = new StrictPair((Object)similarity, (Object)new StrictPair((Object)resolution, (Object)pattern));
                continue;
            }
            int compare = Double.compare(similarity, (Double)bestMatch.getFirst());
            if (compare <= 0 || Double.compare(similarity, (previousPattern = (SimilarityMatchPattern)((StrictPair)bestMatch.getSecond()).getSecond()).getSimilarityOfMatch()) <= 0) continue;
            bestMatch = new StrictPair((Object)similarity, (Object)new StrictPair((Object)resolution, (Object)pattern));
        }
        if (!matched && bestMatch != null) {
            I i;
            Resolution resolution = (Resolution)((StrictPair)bestMatch.getSecond()).getFirst();
            SimilarityMatchPattern pattern = (SimilarityMatchPattern)((StrictPair)bestMatch.getSecond()).getSecond();
            double similarityOfPreviousMatch = pattern.getSimilarityOfMatch();
            if (resolution.getAssociatedIssues().size() > 0 && Double.compare((Double)bestMatch.getFirst(), similarityOfPreviousMatch) > 0 && pattern.getMatchedFqName() != null && !pattern.getMatchedFqName().equals(fqName) && (i = this.getIssueFromResolution(resolution)) != null) {
                resolution.reset((IIssue)i);
            }
            ((Issue)issue).setResolution(resolution);
            pattern.setSimilarityOfMatch((Double)bestMatch.getFirst(), fqName);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Best matching resolution ({}) found with similarity {} for {}", new Object[]{resolution.getPresentationName(true), (double)((Double)bestMatch.getFirst()), ((Element)affectedElement).getPresentationName(true)});
            }
            matched = true;
        }
        if (var7_13 != null) {
            collector.remove(var7_13);
            if (this.matchResolution(resolutions, var7_13, collector)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Found another resolution for previously matched issue '{}'", (Object)var7_13);
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Failed to find another resolution for previously matched issue '{}'", (Object)var7_13.getAffectedElement());
            }
        }
        return matched;
    }

    protected abstract double getSimilarity(Set<S> var1, Set<S> var2);
}

