/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.architecturediagram;

import com.hello2morrow.sonargraph.core.foundation.common.graph.CycleAnalyzer;
import com.hello2morrow.sonargraph.core.foundation.common.graph.GraphNode;
import com.hello2morrow.sonargraph.core.foundation.common.graph.ICycleAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponent;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

final class UmlComponentLevelAnalyzer
implements ICycleAnalyzerAdapter {
    private final Map<UmlComponent, GraphNode<UmlComponent>> m_umlComponentToNode = new THashMap();
    private final Map<INode<?>, Integer> m_nodeToGroupIndex = new THashMap();
    private final Set<INode<?>> m_cyclicNodes = new THashSet();

    private UmlComponentLevelAnalyzer(Collection<UmlComponent> umlComponents) {
        assert (umlComponents != null && !umlComponents.isEmpty()) : "Parameter 'umlComponents' of method 'UmlComponentLevelAnalyzer' must not be empty";
        for (UmlComponent umlComponent : umlComponents) {
            GraphNode<UmlComponent> previous = this.m_umlComponentToNode.put(umlComponent, new GraphNode<UmlComponent>(umlComponent));
            assert (previous == null) : "'previous' of method 'UmlComponentLevelAnalyzer' must be null";
        }
        for (GraphNode graphNode : this.m_umlComponentToNode.values()) {
            UmlComponent nextUmlComponent = (UmlComponent)graphNode.getUnderlyingObject();
            for (UmlComponent connected : nextUmlComponent.getConnectedElements()) {
                GraphNode<UmlComponent> connectedNode = this.m_umlComponentToNode.get(connected);
                if (connectedNode == null) continue;
                graphNode.connectTo(connectedNode);
            }
        }
        this.m_umlComponentToNode.values().forEach(n -> n.finishModification());
    }

    public Collection<GraphNode<UmlComponent>> getNodes() {
        return this.m_umlComponentToNode.values();
    }

    @Override
    public boolean calculateLevels() {
        return true;
    }

    @Override
    public boolean isCyclic(INode<?> node) {
        assert (node != null) : "Parameter 'node' of method 'isCyclic' must not be null";
        return this.m_cyclicNodes.contains(node);
    }

    @Override
    public void setGroupIndex(INode<?> node, int groupIndex, boolean isCyclic) {
        assert (node != null) : "Parameter 'node' of method 'setGroupIndex' must not be null";
        if (isCyclic) {
            this.m_cyclicNodes.add(node);
        }
        this.m_nodeToGroupIndex.put(node, groupIndex);
    }

    @Override
    public int getGroupIndex(INode<?> node) {
        assert (node != null) : "Parameter 'node' of method 'getGroupIndex' must not be null";
        Integer val = this.m_nodeToGroupIndex.get(node);
        return val == null ? -1 : val;
    }

    @Override
    public void setLevel(INode<?> node, int level) {
        assert (node != null && node instanceof GraphNode) : "Unexpected class in method 'setLevel': " + String.valueOf(node);
        Object umlComponent = ((GraphNode)node).getUnderlyingObject();
        assert (umlComponent != null && umlComponent instanceof UmlComponent) : "Unexpected class in method 'setLevel': " + String.valueOf(umlComponent);
        ((UmlComponent)umlComponent).setLevel(level);
    }

    static void analyze(Collection<UmlComponent> umlComponents) {
        assert (umlComponents != null && !umlComponents.isEmpty()) : "Parameter 'umlComponents' of method 'analyze' must not be empty";
        UmlComponentLevelAnalyzer analyzer = new UmlComponentLevelAnalyzer(umlComponents);
        CycleAnalyzer.compute(analyzer, (IWorkerContext)DefaultWorkerContext.INSTANCE);
    }
}

