/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.architecture;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitecturalModelProvider;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableAttributeRetriever;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import gnu.trove.map.hash.THashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AssignableAttributeRetriever<T extends NamedElement>
implements IAssignableAttributeRetriever {
    private static final Logger LOGGER = LoggerFactory.getLogger(AssignableAttributeRetriever.class);
    private Map<T, String> m_elementToDatum;
    private Map<T, Set<String>> m_elementToData;

    protected AssignableAttributeRetriever() {
    }

    @Override
    public final String getPresentationName() {
        Language language = this.getLanguage();
        return "[" + (language != null ? this.getLanguage().getPresentationName() : "Core") + "] " + StringUtility.convertMixedCaseToHumanizedString((String)this.getShortName());
    }

    protected final Set<String> getData(T element) {
        assert (element != null) : "Parameter 'element' of method 'getData' must not be null";
        return this.m_elementToData != null ? this.m_elementToData.get(element) : null;
    }

    protected final void setData(T element, Set<String> data) {
        assert (element != null) : "Parameter 'element' of method 'setData' must not be null";
        assert (data != null) : "Parameter 'data' of method 'setData' must not be null";
        if (this.m_elementToData == null) {
            this.m_elementToData = new THashMap();
        }
        Set<String> previous = this.m_elementToData.put(element, data);
        assert (previous == null) : "'previous' of method 'setData' must be null";
    }

    protected final String getDatum(T element) {
        assert (element != null) : "Parameter 'element' of method 'getDatum' must not be null";
        return this.m_elementToDatum != null ? this.m_elementToDatum.get(element) : null;
    }

    protected final void setDatum(T element, String datum) {
        String previous;
        assert (element != null) : "Parameter 'element' of method 'setDatum' must not be null";
        assert (datum != null) : "Parameter 'datum' of method 'setDatum' must not be null";
        if (this.m_elementToDatum == null) {
            this.m_elementToDatum = new THashMap();
        }
        if ((previous = this.m_elementToDatum.put(element, datum)) != null) {
            if (!datum.equals(previous)) {
                LOGGER.error("Different Data set for: " + String.valueOf(element) + " (" + datum + "/" + previous + ")");
            } else {
                LOGGER.warn("Datum set more than once for: " + String.valueOf(element));
            }
        }
    }

    protected final String createAttribute(Set<String> data) {
        assert (data != null) : "Parameter 'data' of method 'createAttribute' must not be null";
        if (!data.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (String next : data) {
                builder.append(next).append(";");
            }
            builder.deleteCharAt(builder.length() - 1);
            return builder.toString();
        }
        return null;
    }

    protected final String createAttribute(String datum) {
        assert (datum != null) : "Parameter 'datum' of method 'createAttribute' must not be null";
        return !datum.isEmpty() ? datum : null;
    }

    @Override
    public boolean availableFor(IArchitecturalModelProvider.ArchitectureModel architectureModel) {
        assert (architectureModel != null) : "Parameter 'architectureModel' of method 'availableFor' must not be null";
        switch (architectureModel) {
            case LOGICAL: 
            case PHYSICAL: {
                return true;
            }
        }
        assert (false) : "Unhandled architecture model: " + String.valueOf((Object)architectureModel);
        return false;
    }

    protected String computeAttributeForComponent(IWorkerContext workerContext, IComponent assignable, String[] params) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'computeAttributeForComponent' must not be null";
        assert (assignable != null) : "Parameter 'assignable' of method 'computeAttributeForComponent' must not be null";
        return null;
    }

    protected String computeAttributeForLogicalProgrammingElement(IWorkerContext workerContext, LogicalProgrammingElement assignable, String[] params) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'computeAttributeForLogicalProgrammingElement' must not be null";
        assert (assignable != null) : "Parameter 'assignable' of method 'computeAttributeForLogicalProgrammingElement' must not be null";
        return null;
    }

    @Override
    public final String getAttribute(IWorkerContext workerContext, IAssignableToArtifact assignable, String[] params) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'getAttribute' must not be null";
        assert (assignable != null) : "Parameter 'assignable' of method 'getAttribute' must not be null";
        if (assignable instanceof IComponent) {
            return this.computeAttributeForComponent(workerContext, (IComponent)assignable, params);
        }
        return this.computeAttributeForLogicalProgrammingElement(workerContext, (LogicalProgrammingElement)assignable, params);
    }

    @Override
    public String getBreakCharacters() {
        return "/";
    }

    @Override
    public int getNumberOfParameters() {
        return 0;
    }

    @Override
    public void reset() {
        LOGGER.debug("Reset cache of '" + this.getClass().getSimpleName() + "'");
        this.m_elementToDatum = null;
        this.m_elementToData = null;
    }

    public String toString() {
        Language language = this.getLanguage();
        return this.getName() + (String)(language != null ? " [" + String.valueOf(language) + "]" : "");
    }
}

